/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.CompilerException;
import uk.ac.ed.inf.biopepa.core.compiler.FunctionEvaluators;
import uk.ac.ed.inf.biopepa.core.compiler.IPredefinedFunctionEvaluator;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemKind;
import uk.ac.ed.inf.biopepa.core.dom.AST;
import uk.ac.ed.inf.biopepa.core.dom.FunctionCall;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledFunction
extends CompiledExpression {
    Function function = null;
    List<CompiledExpression> arguments = new ArrayList<CompiledExpression>(3);

    public static Function getFunction(String function) {
        Function[] functionArray = Function.values();
        int n = functionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Function f = functionArray[n2];
            if (f.name.equals(function)) {
                return f;
            }
            ++n2;
        }
        return null;
    }

    public Function getFunction() {
        return this.function;
    }

    void setFunction(Function function) {
        if (this.arguments.size() > function.arg) {
            throw new IllegalStateException();
        }
        this.function = function;
    }

    void setArgument(int index, CompiledExpression argument) {
        if (this.function != null && this.function.arg < index) {
            throw new IllegalArgumentException();
        }
        int i = this.arguments.size();
        while (i <= index) {
            this.arguments.add(null);
            ++i;
        }
        this.arguments.set(index, argument);
    }

    public List<CompiledExpression> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.function.name).append("(");
        for (CompiledExpression en : this.arguments) {
            sb.append(en.toString()).append(", ");
        }
        sb.replace(sb.length() - 2, sb.length(), ")");
        return sb.toString();
    }

    public static Function checkFunction(ModelCompiler compiler, FunctionCall call) throws CompilerException {
        Function f = CompiledFunction.getFunction(call.getName().getIdentifier());
        if (f == null) {
            compiler.problemRequestor.accept(ProblemKind.UNSUPPORTED_FUNCTION_USED, call);
            throw new CompilerException();
        }
        if (call.arguments().size() != f.arg) {
            compiler.problemRequestor.accept(ProblemKind.INVALID_NUMBER_OF_ARGUMENTS, call);
            throw new CompilerException();
        }
        return f;
    }

    public static IPredefinedFunctionEvaluator getFunctionEvaluator(ModelCompiler compiler, FunctionCall call) throws CompilerException {
        Function f = CompiledFunction.checkFunction(compiler, call);
        switch (f) {
            case LOG: 
            case EXP: 
            case H: 
            case FLOOR: 
            case CEILING: 
            case TANH: {
                return new FunctionEvaluators.GenericOneArgumentFunction(compiler, call);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean accept(CompiledExpressionVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public CompiledFunction clone() {
        CompiledFunction cf = new CompiledFunction();
        cf.function = this.function;
        for (CompiledExpression ce : this.arguments) {
            if (ce != null) {
                cf.arguments.add(ce.clone());
                continue;
            }
            cf.arguments.add(null);
        }
        if (this.expandedForm != null) {
            cf.expandedForm = this.expandedForm.clone();
        }
        return cf;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Function {
        LOG(AST.Literals.LOGARITHM.getToken(), 1, false),
        EXP(AST.Literals.EXP.getToken(), 1, false),
        H(AST.Literals.HEAVISIDE.getToken(), 1, false),
        FLOOR(AST.Literals.FLOOR.getToken(), 1, false),
        CEILING(AST.Literals.CEILING.getToken(), 1, false),
        fMA(AST.Literals.MASS_ACTION.getToken(), 1, true),
        fMM(AST.Literals.MICHAELIS_MENTEN.getToken(), 2, true),
        TANH(AST.Literals.TANH.getToken(), 1, false);

        int arg;
        String name;
        boolean rate;

        private Function(String name, int arg, boolean rate) {
            this.arg = arg;
            this.name = name;
            this.rate = rate;
        }

        public String getID() {
            return this.name;
        }

        public boolean isRateLaw() {
            return this.rate;
        }

        public int args() {
            return this.arg;
        }
    }
}

