/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.AbstractDefinitionCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.CompilerException;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentData;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentPrefixVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemKind;
import uk.ac.ed.inf.biopepa.core.dom.LocatedName;
import uk.ac.ed.inf.biopepa.core.dom.Name;
import uk.ac.ed.inf.biopepa.core.dom.VariableDeclaration;

public class ComponentCompiler
extends AbstractDefinitionCompiler {
    ComponentCompiler(ModelCompiler compiler, VariableDeclaration dec) throws CompilerException {
        super(compiler, VariableDeclaration.Kind.COMPONENT, dec);
    }

    protected boolean hasDuplicates(String name) {
        return this.compiler.containsCompartment(name) || this.compiler.containsCompositionalDefinition(name) || this.compiler.containsFunctionalRate(name) || this.compiler.containsVariable(name) || this.compiler.containsComponent(name);
    }

    public ComponentData doGetData() throws BioPEPAException {
        Name name = this.dec.getName();
        if (name instanceof LocatedName) {
            this.compiler.problemRequestor.accept(ProblemKind.INVALID_LOCATED_NAME_USE, name);
            throw new CompilerException();
        }
        String identifier = name.getIdentifier();
        ComponentPrefixVisitor v = new ComponentPrefixVisitor(this.compiler, identifier);
        ComponentData d = new ComponentData(identifier, this.dec);
        this.dec.getRightHandSide().accept(v);
        d.setPrefixes(v.getActions());
        return d;
    }
}

