/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledDynamicComponent;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledOperatorNode;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledSystemVariable;
import uk.ac.ed.inf.biopepa.core.compiler.CompilerException;
import uk.ac.ed.inf.biopepa.core.compiler.DefaultCompilerVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.EvaluationException;
import uk.ac.ed.inf.biopepa.core.compiler.IPredefinedFunctionEvaluator;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemInfo;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemKind;
import uk.ac.ed.inf.biopepa.core.compiler.VariableData;
import uk.ac.ed.inf.biopepa.core.dom.ASTNode;
import uk.ac.ed.inf.biopepa.core.dom.FunctionCall;
import uk.ac.ed.inf.biopepa.core.dom.InfixExpression;
import uk.ac.ed.inf.biopepa.core.dom.Name;
import uk.ac.ed.inf.biopepa.core.dom.NumberLiteral;
import uk.ac.ed.inf.biopepa.core.dom.SystemVariable;

public class ExpressionEvaluatorVisitor
extends DefaultCompilerVisitor {
    protected CompiledExpression node = null;

    public ExpressionEvaluatorVisitor(ModelCompiler compiler) {
        super(compiler);
    }

    public CompiledExpression getExpressionNode() {
        return this.node;
    }

    public boolean visit(Name name) throws BioPEPAException {
        String identifier = name.getIdentifier();
        if (identifier == null) {
            throw new IllegalArgumentException();
        }
        if (identifier == this.compiler.getCurrentlyVisitedVariable()) {
            this.compiler.problemRequestor.accept(ProblemKind.CIRCULAR_USAGE, name);
            throw new CompilerException();
        }
        if (this.compiler.isDynamic(identifier)) {
            this.node = new CompiledDynamicComponent(identifier);
            return true;
        }
        VariableData data = this.compiler.checkAndGetVariableData(identifier);
        if (data == null) {
            this.compiler.problemRequestor.accept(ProblemKind.VARIABLE_USED_BUT_NOT_DEFINED, name);
            throw new CompilerException();
        }
        this.node = data.getValue().clone();
        this.node.setExpandedForm(new CompiledDynamicComponent(identifier));
        return true;
    }

    public boolean visit(InfixExpression infixExpression) throws BioPEPAException {
        ExpressionEvaluatorVisitor vlhs = new ExpressionEvaluatorVisitor(this.compiler);
        infixExpression.getLeftHandSide().accept(vlhs);
        ExpressionEvaluatorVisitor vrhs = new ExpressionEvaluatorVisitor(this.compiler);
        infixExpression.getRightHandSide().accept(vrhs);
        if (vlhs.node instanceof CompiledNumber && vrhs.node instanceof CompiledNumber) {
            Number number;
            CompiledNumber lenn = (CompiledNumber)vlhs.node;
            CompiledNumber renn = (CompiledNumber)vrhs.node;
            switch (infixExpression.getOperator()) {
                case PLUS: {
                    if (lenn.evaluatesToDouble() || renn.evaluatesToDouble()) {
                        number = new Double(lenn.doubleValue() + renn.doubleValue());
                        break;
                    }
                    number = new Long(lenn.longValue() + renn.longValue());
                    break;
                }
                case MINUS: {
                    if (lenn.evaluatesToDouble() || renn.evaluatesToDouble()) {
                        number = new Double(lenn.doubleValue() - renn.doubleValue());
                        break;
                    }
                    number = new Long(lenn.longValue() - renn.longValue());
                    break;
                }
                case TIMES: {
                    if (lenn.evaluatesToDouble() || renn.evaluatesToDouble()) {
                        number = new Double(lenn.doubleValue() * renn.doubleValue());
                        break;
                    }
                    number = new Long(lenn.longValue() * renn.longValue());
                    break;
                }
                case DIVIDE: {
                    long r;
                    long l;
                    long a;
                    if (renn.doubleValue() == 0.0) {
                        this.compiler.problemRequestor.accept(ProblemInfo.Severity.ERROR, "Divide by zero.", (ASTNode)infixExpression);
                        throw new CompilerException();
                    }
                    if (lenn.evaluatesToLong() && renn.evaluatesToLong() && (a = (l = lenn.longValue()) / (r = renn.longValue())) * r == l) {
                        number = new Long(a);
                        break;
                    }
                    number = new Double(lenn.doubleValue() / renn.doubleValue());
                    break;
                }
                case POWER: {
                    double d = Math.pow(lenn.doubleValue(), renn.doubleValue());
                    if (Double.isNaN(d) || Double.isInfinite(d)) {
                        this.compiler.problemRequestor.accept(ProblemInfo.Severity.ERROR, "Cannot evaluate the expression.", (ASTNode)infixExpression);
                        throw new CompilerException();
                    }
                    if (d - (double)((long)d) != 0.0) {
                        number = new Double(d);
                        break;
                    }
                    number = new Long((long)d);
                    break;
                }
                default: {
                    this.compiler.problemRequestor.accept(ProblemKind.INVALID_OPERATOR_FOR_DOUBLE, infixExpression);
                    throw new CompilerException();
                }
            }
            this.node = new CompiledNumber(number);
            if (lenn.hasExpandedForm() || renn.hasExpandedForm()) {
                CompiledOperatorNode eNode = new CompiledOperatorNode();
                eNode.setOperator(infixExpression.getOperator());
                eNode.left = lenn.hasExpandedForm() ? lenn.expandedForm : lenn;
                eNode.right = renn.hasExpandedForm() ? renn.expandedForm : renn;
                this.node.setExpandedForm(eNode);
            }
            return true;
        }
        CompiledOperatorNode tnode = new CompiledOperatorNode();
        tnode.setOperator(infixExpression.getOperator());
        tnode.setLeft(vlhs.node);
        tnode.setRight(vrhs.node);
        this.node = tnode;
        return true;
    }

    public boolean visit(NumberLiteral numberLiteral) throws BioPEPAException {
        Number number;
        try {
            number = Long.parseLong(numberLiteral.getToken());
        }
        catch (NumberFormatException numberFormatException) {
            try {
                number = Double.parseDouble(numberLiteral.getToken());
            }
            catch (NumberFormatException numberFormatException2) {
                this.compiler.problemRequestor.accept(ProblemKind.INVALID_NUMBER_LITERAL, numberLiteral);
                throw new CompilerException();
            }
        }
        this.node = new CompiledNumber(number);
        return true;
    }

    public boolean visit(FunctionCall functionCall) throws BioPEPAException {
        IPredefinedFunctionEvaluator evaluator = CompiledFunction.getFunctionEvaluator(this.compiler, functionCall);
        try {
            this.node = evaluator.evaluate();
        }
        catch (EvaluationException evaluationException) {}
        return true;
    }

    public boolean visit(SystemVariable variable) throws BioPEPAException {
        switch (variable.getVariable()) {
            case TIME: {
                this.node = new CompiledSystemVariable(CompiledSystemVariable.Variable.TIME);
            }
        }
        return true;
    }
}

