/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompilerException;
import uk.ac.ed.inf.biopepa.core.compiler.EvaluationException;
import uk.ac.ed.inf.biopepa.core.compiler.ExpressionEvaluatorVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.IPredefinedFunctionEvaluator;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.dom.Expression;
import uk.ac.ed.inf.biopepa.core.dom.FunctionCall;

public class FunctionEvaluators {

    public static class GenericOneArgumentFunction
    implements IPredefinedFunctionEvaluator {
        private ModelCompiler compiler;
        private FunctionCall call;
        private CompiledFunction.Function function;

        public GenericOneArgumentFunction(ModelCompiler compiler, FunctionCall call) throws CompilerException {
            this.compiler = compiler;
            this.call = call;
            this.function = CompiledFunction.checkFunction(compiler, call);
        }

        public CompiledExpression evaluate() throws EvaluationException {
            Expression e = this.call.arguments().get(0);
            ExpressionEvaluatorVisitor v = new ExpressionEvaluatorVisitor(this.compiler);
            try {
                e.accept(v);
            }
            catch (BioPEPAException bioPEPAException) {
                throw new EvaluationException();
            }
            if (v.getExpressionNode() instanceof CompiledNumber) {
                CompiledNumber number = null;
                double d = ((CompiledNumber)v.getExpressionNode()).doubleValue();
                switch (this.function) {
                    case H: {
                        number = new CompiledNumber(d > 0.0 ? new Long(1L) : new Long(0L));
                        break;
                    }
                    case FLOOR: {
                        number = new CompiledNumber((long)Math.floor(d));
                        break;
                    }
                    case CEILING: {
                        number = new CompiledNumber((long)Math.ceil(d));
                        break;
                    }
                    case LOG: {
                        number = new CompiledNumber(Math.log(d));
                        break;
                    }
                    case EXP: {
                        number = new CompiledNumber(Math.exp(d));
                        break;
                    }
                    case TANH: {
                        number = new CompiledNumber(Math.tanh(d));
                        break;
                    }
                    default: {
                        System.err.println("shouldn't get here?");
                    }
                }
                return number;
            }
            CompiledFunction efn = new CompiledFunction();
            efn.setFunction(this.function);
            efn.setArgument(0, v.getExpressionNode());
            return efn;
        }
    }
}

