/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.ExpressionEvaluatorVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.dom.Expression;
import uk.ac.ed.inf.biopepa.core.dom.FunctionCall;
import uk.ac.ed.inf.biopepa.core.dom.InfixExpression;
import uk.ac.ed.inf.biopepa.core.dom.Name;
import uk.ac.ed.inf.biopepa.core.dom.NumberLiteral;

public class FunctionalRateCheckerVisitor
extends ExpressionEvaluatorVisitor {
    private boolean top = true;
    boolean predefinedLaw = false;

    public FunctionalRateCheckerVisitor(ModelCompiler compiler) {
        super(compiler);
    }

    public boolean visit(Name name) throws BioPEPAException {
        this.top = false;
        return super.visit(name);
    }

    public boolean visit(InfixExpression infixExpression) throws BioPEPAException {
        this.top = false;
        return super.visit(infixExpression);
    }

    public boolean visit(NumberLiteral numberLiteral) throws BioPEPAException {
        this.top = false;
        return super.visit(numberLiteral);
    }

    public boolean visit(FunctionCall functionCall) throws BioPEPAException {
        if (this.top) {
            this.top = false;
            CompiledFunction.Function f = CompiledFunction.checkFunction(this.compiler, functionCall);
            if (f.isRateLaw()) {
                this.predefinedLaw = true;
                CompiledFunction efn = new CompiledFunction();
                efn.setFunction(f);
                int i = 0;
                for (Expression e : functionCall.arguments()) {
                    ExpressionEvaluatorVisitor eev = new ExpressionEvaluatorVisitor(this.compiler);
                    e.accept(eev);
                    efn.setArgument(i++, eev.getExpressionNode());
                    this.node = efn;
                }
                return true;
            }
        }
        return super.visit(functionCall);
    }
}

