/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.analysis.StaticAnalysis;
import uk.ac.ed.inf.biopepa.core.compiler.ActionSetCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.CompartmentCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.CompartmentData;
import uk.ac.ed.inf.biopepa.core.compiler.CompilerException;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentData;
import uk.ac.ed.inf.biopepa.core.compiler.CompositionalVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.Data;
import uk.ac.ed.inf.biopepa.core.compiler.DefaultProblemPolicy;
import uk.ac.ed.inf.biopepa.core.compiler.DynamicComponentGathererVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.FunctionalRateCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.FunctionalRateData;
import uk.ac.ed.inf.biopepa.core.compiler.IProblemPolicy;
import uk.ac.ed.inf.biopepa.core.compiler.IProblemRequestor;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemInfo;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemKind;
import uk.ac.ed.inf.biopepa.core.compiler.SpeciesData;
import uk.ac.ed.inf.biopepa.core.compiler.SpeciesDefinitionCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.SystemEquationData;
import uk.ac.ed.inf.biopepa.core.compiler.SystemEquationNode;
import uk.ac.ed.inf.biopepa.core.compiler.VariableCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.VariableData;
import uk.ac.ed.inf.biopepa.core.dom.ASTNode;
import uk.ac.ed.inf.biopepa.core.dom.Component;
import uk.ac.ed.inf.biopepa.core.dom.Cooperation;
import uk.ac.ed.inf.biopepa.core.dom.Expression;
import uk.ac.ed.inf.biopepa.core.dom.ExpressionStatement;
import uk.ac.ed.inf.biopepa.core.dom.LocatedName;
import uk.ac.ed.inf.biopepa.core.dom.Model;
import uk.ac.ed.inf.biopepa.core.dom.Name;
import uk.ac.ed.inf.biopepa.core.dom.Statement;
import uk.ac.ed.inf.biopepa.core.dom.VariableDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelCompiler {
    IProblemRequestor problemRequestor;
    private Model model;
    private String currentlyVisitedVariableName = null;
    private Map<String, VariableData> variables = new HashMap<String, VariableData>();
    private Set<String> dynamicComponents = new HashSet<String>();
    private Map<String, CompartmentData> compartments = new HashMap<String, CompartmentData>();
    private Map<String, SpeciesData> species = new HashMap<String, SpeciesData>();
    private Map<String, FunctionalRateData> functionalRates = new HashMap<String, FunctionalRateData>();
    private Map<String, ComponentData> components = new HashMap<String, ComponentData>();
    private Map<String, SystemEquationData> compositions = new HashMap<String, SystemEquationData>();
    private SystemEquationNode systemEquation = null;
    private List<ProblemInfo> problems = new ArrayList<ProblemInfo>();

    public ModelCompiler(Model model) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        this.model = model;
        this.problemRequestor = new IProblemRequestor(){
            IProblemPolicy policy = new DefaultProblemPolicy();

            public boolean accept(ProblemKind problem, ASTNode affectedNode) {
                return this.accept(problem, "", affectedNode);
            }

            public boolean accept(ProblemInfo.Severity severity, String message, ASTNode node) {
                ProblemInfo info = new ProblemInfo();
                info.severity = severity;
                info.message = message;
                info.sourceRange = node.getSourceRange();
                ModelCompiler.this.problems.add(info);
                return true;
            }

            public boolean accept(ProblemKind problem, String additionalComment, ASTNode affectedNode) {
                StringBuffer message = new StringBuffer(problem.toString());
                message.append(additionalComment).append(".");
                ProblemInfo info = new ProblemInfo();
                info.severity = this.policy.isWarning(problem) ? ProblemInfo.Severity.WARNING : ProblemInfo.Severity.ERROR;
                info.message = message.toString();
                info.sourceRange = affectedNode.getSourceRange();
                ModelCompiler.this.problems.add(info);
                return true;
            }

            public IProblemPolicy getProblemPolicy() {
                return this.policy;
            }

            public void setProblemPolicy(IProblemPolicy policy) {
                throw new IllegalArgumentException();
            }
        };
    }

    public ProblemInfo[] compile() {
        try {
            this.discoverDynamicComponents();
            this.compileVariableDeclarations();
            this.compileCompartmentDeclarations();
            this.compileSpeciesDeclarations();
            this.compileFunctionalRates();
            this.compileComponents();
            this.compileSystemEquation();
            this.compileOutWildCards();
            this.generateWarnings();
            this.problems.addAll(StaticAnalysis.analysis(this.model, this));
        }
        catch (BioPEPAException bioPEPAException) {}
        return this.problems.toArray(new ProblemInfo[this.problems.size()]);
    }

    public boolean containsVariable(String name) {
        return this.variables.containsKey(name);
    }

    public boolean containsComponent(String name) {
        return this.components.containsKey(name);
    }

    public boolean containsCompartment(String name) {
        return this.compartments.containsKey(name);
    }

    public boolean containsSpecies(String name) {
        return this.species.containsKey(name);
    }

    public boolean containsFunctionalRate(String name) {
        return this.functionalRates.containsKey(name);
    }

    public boolean containsCompositionalDefinition(String name) {
        return this.compositions.containsKey(name);
    }

    public boolean containsAnyDeclaration(String name) {
        return this.containsCompartment(name) || this.containsVariable(name) || this.containsSpecies(name) || this.containsFunctionalRate(name) || this.containsCompositionalDefinition(name) || this.containsComponent(name);
    }

    int getNumberOfDefinedCompartments() {
        return this.compartments.size();
    }

    String getCurrentlyVisitedVariable() {
        return this.currentlyVisitedVariableName;
    }

    public boolean isDynamic(String name) {
        return this.dynamicComponents.contains(name);
    }

    VariableData checkAndGetVariableData(String name) {
        VariableData data = this.variables.get(name);
        if (data == null) {
            return null;
        }
        data.registerNewUsage();
        return data;
    }

    CompartmentData checkAndGetCompartmentData(String name) {
        CompartmentData data = this.compartments.get(name);
        if (data == null) {
            return null;
        }
        data.registerNewUsage();
        return data;
    }

    SpeciesData checkAndGetSpeciesData(String identifier) {
        SpeciesData data = this.species.get(identifier);
        if (data == null) {
            return null;
        }
        data.registerNewUsage();
        return data;
    }

    FunctionalRateData checkAndGetFunctionalRate(String identifier) {
        FunctionalRateData data = this.functionalRates.get(identifier);
        if (data == null) {
            return null;
        }
        data.registerNewUsage();
        return data;
    }

    SystemEquationData checkAndGetComposition(String name) {
        SystemEquationData data = this.compositions.get(name);
        if (data == null) {
            return null;
        }
        data.registerNewUsage();
        return data;
    }

    ComponentData checkAndGetComponentData(String name) {
        ComponentData data = this.components.get(name);
        if (data == null) {
            return null;
        }
        data.registerNewUsage();
        return data;
    }

    private void discoverDynamicComponents() throws BioPEPAException {
        DynamicComponentGathererVisitor dcgv = new DynamicComponentGathererVisitor(this);
        for (Statement statement : this.model.statements()) {
            if (statement instanceof VariableDeclaration) {
                Expression rhs;
                VariableDeclaration dec = (VariableDeclaration)statement;
                if (dec.getKind() == VariableDeclaration.Kind.CONTAINER) {
                    Name name = dec.getName();
                    if (name instanceof LocatedName) {
                        this.dynamicComponents.add(((LocatedName)name).getName());
                        continue;
                    }
                    this.dynamicComponents.add(dec.getName().getIdentifier());
                    continue;
                }
                if (dec.getKind() != VariableDeclaration.Kind.COMPONENT || !((rhs = dec.getRightHandSide()) instanceof Cooperation) && !(rhs instanceof Component)) continue;
                rhs.accept(dcgv);
                continue;
            }
            if (!(statement instanceof ExpressionStatement)) continue;
            ((ExpressionStatement)statement).getExpression().accept(dcgv);
        }
        this.dynamicComponents.addAll(dcgv.components);
    }

    private void compileVariableDeclarations() throws BioPEPAException {
        for (Statement statement : this.model.statements()) {
            VariableDeclaration dec;
            if (!(statement instanceof VariableDeclaration) || (dec = (VariableDeclaration)statement).getKind() != VariableDeclaration.Kind.VARIABLE) continue;
            VariableCompiler visitor = new VariableCompiler(this, dec);
            this.currentlyVisitedVariableName = dec.getName().getIdentifier();
            VariableData data = (VariableData)visitor.getData();
            assert (data != null);
            this.variables.put(data.getName(), data);
        }
        this.currentlyVisitedVariableName = null;
    }

    private void compileCompartmentDeclarations() throws BioPEPAException {
        for (Statement statement : this.model.statements()) {
            VariableDeclaration dec;
            if (!(statement instanceof VariableDeclaration) || (dec = (VariableDeclaration)statement).getKind() != VariableDeclaration.Kind.CONTAINER) continue;
            CompartmentCompiler visitor = new CompartmentCompiler(this, dec);
            CompartmentData data = (CompartmentData)visitor.getData();
            assert (data != null);
            this.compartments.put(data.getName(), data);
        }
    }

    private void compileSpeciesDeclarations() throws BioPEPAException {
        for (Statement statement : this.model.statements()) {
            VariableDeclaration dec;
            if (!(statement instanceof VariableDeclaration) || (dec = (VariableDeclaration)statement).getKind() != VariableDeclaration.Kind.SPECIES) continue;
            SpeciesDefinitionCompiler visitor = new SpeciesDefinitionCompiler(this, dec);
            List<SpeciesData> speciesList = visitor.doGetDataList();
            for (SpeciesData sd : speciesList) {
                assert (sd != null);
                this.species.put(sd.getName(), sd);
            }
        }
    }

    private void compileFunctionalRates() throws BioPEPAException {
        for (Statement statement : this.model.statements()) {
            VariableDeclaration dec;
            if (!(statement instanceof VariableDeclaration) || (dec = (VariableDeclaration)statement).getKind() != VariableDeclaration.Kind.FUNCTION) continue;
            FunctionalRateCompiler visitor = new FunctionalRateCompiler(this, VariableDeclaration.Kind.FUNCTION, dec);
            FunctionalRateData data = (FunctionalRateData)visitor.getData();
            assert (data != null);
            this.functionalRates.put(data.getName(), data);
        }
    }

    private void compileComponents() throws BioPEPAException {
        Expression rhs;
        VariableDeclaration dec;
        for (Statement statement : this.model.statements()) {
            if (!(statement instanceof VariableDeclaration) || (dec = (VariableDeclaration)statement).getKind() != VariableDeclaration.Kind.COMPONENT || (rhs = dec.getRightHandSide()) instanceof Cooperation || rhs instanceof Component) continue;
            ComponentCompiler cc = new ComponentCompiler(this, dec);
            ComponentData cd = (ComponentData)cc.getData();
            assert (cd != null);
            this.components.put(cd.getName(), cd);
        }
        for (Statement statement : this.model.statements()) {
            if (!(statement instanceof VariableDeclaration) || (dec = (VariableDeclaration)statement).getKind() != VariableDeclaration.Kind.COMPONENT || !((rhs = dec.getRightHandSide()) instanceof Cooperation) && !(rhs instanceof Component)) continue;
            if (this.containsAnyDeclaration(dec.getName().getIdentifier())) {
                this.problemRequestor.accept(ProblemKind.DUPLICATE_USAGE, dec);
                throw new CompilerException();
            }
            CompositionalVisitor visitor = new CompositionalVisitor(this);
            rhs.accept(visitor);
            String identifier = dec.getName().getIdentifier();
            SystemEquationData data = new SystemEquationData(identifier, dec);
            data.setSystemEquationNode(visitor.getData());
            this.compositions.put(identifier, data);
        }
    }

    private void compileSystemEquation() throws BioPEPAException {
        boolean foundSystemEquation = false;
        for (Statement s : this.model.statements()) {
            if (!(s instanceof ExpressionStatement)) continue;
            if (!foundSystemEquation) {
                Expression systemEquation = ((ExpressionStatement)s).getExpression();
                CompositionalVisitor v = new CompositionalVisitor(this);
                systemEquation.accept(v);
                this.systemEquation = v.result;
                continue;
            }
            this.problemRequestor.accept(ProblemKind.MULTIPLE_SYSTEM_EQUATIONS, s);
            throw new CompilerException();
        }
    }

    private void compileOutWildCards() {
        ActionSetCompiler asc = new ActionSetCompiler(this);
        asc.computeWildCardSets();
    }

    private void generateWarnings() {
        this.findUnused(this.variables);
        this.findUnused(this.compartments);
        this.findUnused(this.components);
        this.findUnused(this.functionalRates);
        this.findUnused(this.compositions);
    }

    public VariableData getVariableData(String name) {
        return this.variables.get(name);
    }

    public CompartmentData getCompartmentData(String name) {
        return this.compartments.get(name);
    }

    public ComponentData getComponentData(String name) {
        return this.components.get(name);
    }

    public SpeciesData getSpeciesData(String identifier) {
        return this.species.get(identifier);
    }

    public FunctionalRateData getFunctionalRate(String identifier) {
        return this.functionalRates.get(identifier);
    }

    public SystemEquationData getComposition(String name) {
        return this.compositions.get(name);
    }

    public SystemEquationNode getSystemEquation() {
        return this.systemEquation;
    }

    private void findUnused(Map<String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            Data datum = (Data)entry.getValue();
            if (datum.usages != 0) continue;
            this.problemRequestor.accept(ProblemInfo.Severity.INFO, ProblemKind.DEFINITION_DECLARED_BUT_NOT_USED.toString(), datum.declaration);
        }
    }

    public Collection<VariableData> getAllVariables() {
        return this.variables.values();
    }

    public VariableData[] getDynamicVariables() {
        ArrayList<VariableData> list = new ArrayList<VariableData>();
        for (VariableData vd : this.variables.values()) {
            if (!vd.isDynamic()) continue;
            list.add(vd);
        }
        return list.toArray(new VariableData[0]);
    }

    public VariableData[] getStaticVariables() {
        ArrayList<VariableData> list = new ArrayList<VariableData>();
        for (VariableData vd : this.variables.values()) {
            if (vd.isDynamic()) continue;
            list.add(vd);
        }
        return list.toArray(new VariableData[0]);
    }

    void debug() {
        System.out.println("Variables:\n****");
        for (VariableData variableData : this.variables.values()) {
            System.out.println(String.valueOf(variableData.name) + "=" + variableData.getValue() + " (" + variableData.getUsage() + ")");
        }
        System.out.println("Compartments:\n****");
        for (CompartmentData compartmentData : this.compartments.values()) {
            System.out.println(compartmentData);
        }
        System.out.println("Species:\n****");
        for (SpeciesData speciesData : this.species.values()) {
            System.out.println(speciesData);
        }
        System.out.println("Functional Rates:\n****");
        for (FunctionalRateData functionalRateData : this.functionalRates.values()) {
            System.out.println(functionalRateData + "(" + functionalRateData.getUsage() + ")");
        }
        System.out.println("Components:\n****");
        for (ComponentData componentData : this.components.values()) {
            System.out.println(componentData);
        }
        System.out.println("System Equation:\n***");
        System.out.println(this.systemEquation);
    }
}

