/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.dom;

import java.util.List;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.dom.ASTVisitor;
import uk.ac.ed.inf.biopepa.core.dom.Component;
import uk.ac.ed.inf.biopepa.core.dom.Cooperation;
import uk.ac.ed.inf.biopepa.core.dom.ExpressionStatement;
import uk.ac.ed.inf.biopepa.core.dom.FunctionCall;
import uk.ac.ed.inf.biopepa.core.dom.InfixExpression;
import uk.ac.ed.inf.biopepa.core.dom.Model;
import uk.ac.ed.inf.biopepa.core.dom.Name;
import uk.ac.ed.inf.biopepa.core.dom.NameSet;
import uk.ac.ed.inf.biopepa.core.dom.NumberLiteral;
import uk.ac.ed.inf.biopepa.core.dom.PostfixExpression;
import uk.ac.ed.inf.biopepa.core.dom.Prefix;
import uk.ac.ed.inf.biopepa.core.dom.PropertyInitialiser;
import uk.ac.ed.inf.biopepa.core.dom.PropertyLiteral;
import uk.ac.ed.inf.biopepa.core.dom.Statement;
import uk.ac.ed.inf.biopepa.core.dom.SystemVariable;
import uk.ac.ed.inf.biopepa.core.dom.Transport;
import uk.ac.ed.inf.biopepa.core.dom.VariableDeclaration;

public class PrettyPrinterVisitor
implements ASTVisitor {
    protected StringBuffer buffer = new StringBuffer();

    public String getString() {
        return this.buffer.toString();
    }

    public boolean visit(Model model) throws BioPEPAException {
        for (Statement s : model.statements()) {
            PrettyPrinterVisitor v = new PrettyPrinterVisitor();
            s.accept(v);
            this.buffer.append(String.valueOf(v.getString()) + "\n");
        }
        return true;
    }

    public boolean visit(VariableDeclaration variableDeclaration) throws BioPEPAException {
        PrettyPrinterVisitor nameVisitor = new PrettyPrinterVisitor();
        variableDeclaration.getName().accept(nameVisitor);
        String token = null;
        String keyword = "";
        if (variableDeclaration.getKind() == VariableDeclaration.Kind.VARIABLE) {
            token = " = ";
        } else if (variableDeclaration.getKind() == VariableDeclaration.Kind.COMPONENT) {
            token = " = ";
        } else if (variableDeclaration.getKind() == VariableDeclaration.Kind.SPECIES) {
            token = " : ";
            keyword = "spec ";
        } else if (variableDeclaration.getKind() == VariableDeclaration.Kind.FUNCTION) {
            token = " : ";
            keyword = "func ";
        } else if (variableDeclaration.getKind() == VariableDeclaration.Kind.CONTAINER) {
            token = " : ";
            keyword = "comp ";
        }
        this.buffer.append(String.valueOf(keyword) + nameVisitor.getString());
        this.buffer.append(token);
        PrettyPrinterVisitor variableDefinition = new PrettyPrinterVisitor();
        variableDeclaration.getRightHandSide().accept(variableDefinition);
        this.buffer.append(variableDefinition.getString());
        return true;
    }

    public boolean visit(Name name) throws BioPEPAException {
        this.buffer.append(name.getIdentifier());
        return true;
    }

    public boolean visit(PostfixExpression postfixExpression) throws BioPEPAException {
        PrettyPrinterVisitor operand = new PrettyPrinterVisitor();
        postfixExpression.getOperand().accept(operand);
        this.buffer.append(String.valueOf(postfixExpression.getOperator().getLiteral()) + " " + operand.getString());
        return true;
    }

    public boolean visit(InfixExpression infixExpression) throws BioPEPAException {
        PrettyPrinterVisitor operand1 = new PrettyPrinterVisitor();
        PrettyPrinterVisitor operand2 = new PrettyPrinterVisitor();
        infixExpression.getLeftHandSide().accept(operand1);
        infixExpression.getRightHandSide().accept(operand2);
        this.buffer.append(operand1.getString());
        this.buffer.append(" " + infixExpression.getOperator().getLiteral() + " ");
        this.buffer.append(operand2.getString());
        return true;
    }

    public boolean visit(NumberLiteral numberLiteral) throws BioPEPAException {
        this.buffer.append(numberLiteral.getToken());
        return true;
    }

    public boolean visit(Prefix prefix) throws BioPEPAException {
        PrettyPrinterVisitor v1 = new PrettyPrinterVisitor();
        PrettyPrinterVisitor v2 = new PrettyPrinterVisitor();
        prefix.getActionType().accept(v1);
        prefix.getStoichometry().accept(v2);
        this.buffer.append("(").append(v1.getString());
        this.buffer.append(", ").append(v2.getString()).append(")");
        return true;
    }

    public boolean visit(Component component) throws BioPEPAException {
        this.buffer.append(component.getName().getIdentifier());
        this.buffer.append("[");
        PrettyPrinterVisitor v = new PrettyPrinterVisitor();
        component.getLevel().accept(v);
        this.buffer.append(v.getString());
        this.buffer.append("]");
        return true;
    }

    public boolean visit(ExpressionStatement statement) throws BioPEPAException {
        this.buffer.append("// System equation\n");
        PrettyPrinterVisitor v = new PrettyPrinterVisitor();
        statement.getExpression().accept(v);
        this.buffer.append(String.valueOf(v.getString()) + "\n");
        return true;
    }

    public boolean visit(Cooperation cooperation) throws BioPEPAException {
        PrettyPrinterVisitor v1 = new PrettyPrinterVisitor();
        cooperation.getLeftHandSide().accept(v1);
        PrettyPrinterVisitor v2 = new PrettyPrinterVisitor();
        cooperation.getRightHandSide().accept(v2);
        PrettyPrinterVisitor v3 = new PrettyPrinterVisitor();
        cooperation.getActionSet().accept(v3);
        this.buffer.append(v1.getString()).append(" <");
        this.buffer.append(v3.getString()).append("> ").append(v2.getString());
        return true;
    }

    public boolean visit(NameSet nameSet) throws BioPEPAException {
        List<Name> locations = nameSet.names();
        int i = locations.size();
        for (Name name : locations) {
            PrettyPrinterVisitor ppv = new PrettyPrinterVisitor();
            name.accept(ppv);
            this.buffer.append(ppv.getString());
            if (--i <= 0) continue;
            this.buffer.append(", ");
        }
        return true;
    }

    public boolean visit(PropertyLiteral propertyLiteral) throws BioPEPAException {
        this.buffer.append(propertyLiteral.getKind().getLiteral());
        return true;
    }

    public boolean visit(FunctionCall functionCall) throws BioPEPAException {
        this.buffer.append(functionCall.getName().getIdentifier());
        this.buffer.append("(");
        int i = 0;
        while (i < functionCall.arguments().size()) {
            PrettyPrinterVisitor v = new PrettyPrinterVisitor();
            functionCall.arguments().get(i).accept(v);
            this.buffer.append(v.getString());
            if (i != functionCall.arguments().size() - 1) {
                this.buffer.append(", ");
            }
            ++i;
        }
        this.buffer.append(")");
        return true;
    }

    public boolean visit(PropertyInitialiser propertyInitialiser) throws BioPEPAException {
        int i = 0;
        while (i < propertyInitialiser.properties().size()) {
            PrettyPrinterVisitor v = new PrettyPrinterVisitor();
            propertyInitialiser.properties().get(i).accept(v);
            this.buffer.append(v.getString());
            if (i != propertyInitialiser.properties().size() - 1) {
                this.buffer.append(", ");
            }
            ++i;
        }
        return true;
    }

    public boolean visit(Transport transport) throws BioPEPAException {
        PrettyPrinterVisitor ppv = new PrettyPrinterVisitor();
        transport.getActonType().accept(ppv);
        this.buffer.append(ppv.getString());
        this.buffer.append("[");
        ppv = new PrettyPrinterVisitor();
        transport.getLeftHandSide().accept(ppv);
        this.buffer.append(ppv.getString()).append(" ");
        this.buffer.append(transport.getOperator().getLiteral());
        ppv = new PrettyPrinterVisitor();
        transport.getRightHandSide().accept(ppv);
        this.buffer.append(" ").append(ppv.getString());
        this.buffer.append("]");
        return true;
    }

    public boolean visit(SystemVariable variable) throws BioPEPAException {
        this.buffer.append(variable.getVariable().toString());
        return true;
    }
}

