/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.dom.internal;

import java_cup.runtime.Symbol;
import java_cup.runtime.SymbolFactory;
import uk.ac.ed.inf.biopepa.core.dom.ASTNode;
import uk.ac.ed.inf.biopepa.core.dom.internal.BioPEPASymbol;

public class BioPEPASymbolFactory
implements SymbolFactory {
    public Symbol newLocationAwareSymbol(String name, int id, Object value, int startPosition, int endPosition, int line, int column) {
        BioPEPASymbol symbol = new BioPEPASymbol(id, value);
        symbol.left = startPosition;
        symbol.right = endPosition;
        symbol.line = line;
        symbol.column = column;
        return symbol;
    }

    public Symbol newSymbol(String name, int id) {
        return this.newSymbol(name, id, null, null, null);
    }

    public Symbol newSymbol(String name, int id, Object value) {
        return this.newSymbol(name, id, null, null, value);
    }

    public Symbol newSymbol(String name, int id, Symbol left, Symbol right) {
        return this.newSymbol(name, id, left, right, null);
    }

    public Symbol newSymbol(String name, int id, Symbol left, Symbol right, Object value) {
        BioPEPASymbol symbol = new BioPEPASymbol(id);
        symbol.value = value;
        if (left != null) {
            symbol.left = left.left;
            symbol.line = ((BioPEPASymbol)left).line;
        }
        if (right != null) {
            symbol.right = right.right;
        }
        if (value != null && value instanceof ASTNode) {
            ASTNode node = (ASTNode)value;
            node.setSourceRange(left.left, right.right - left.left, ((BioPEPASymbol)left).line, ((BioPEPASymbol)left).column);
        }
        return symbol;
    }

    public Symbol startSymbol(String name, int id, int state) {
        BioPEPASymbol symbol = new BioPEPASymbol(id);
        symbol.parse_state = state;
        symbol.left = 0;
        symbol.right = 0;
        symbol.value = null;
        return symbol;
    }
}

