/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.chem.Compartment;
import org.systemsbiology.chem.Model;
import org.systemsbiology.chem.Parameter;
import org.systemsbiology.chem.Reaction;
import org.systemsbiology.chem.ReservedSymbolMapperChemCommandLanguage;
import org.systemsbiology.chem.SimulationController;
import org.systemsbiology.chem.SimulationProgressReporter;
import org.systemsbiology.chem.SimulationResults;
import org.systemsbiology.chem.Simulator;
import org.systemsbiology.chem.SimulatorParameters;
import org.systemsbiology.chem.SimulatorStochasticBase;
import org.systemsbiology.chem.SimulatorStochasticGibsonBruck;
import org.systemsbiology.chem.SimulatorStochasticGillespie;
import org.systemsbiology.chem.SimulatorStochasticTauLeapBase;
import org.systemsbiology.chem.SimulatorStochasticTauLeapComplex;
import org.systemsbiology.chem.Species;
import org.systemsbiology.chem.odetojava.SimulatorOdeToJavaBase;
import org.systemsbiology.chem.odetojava.SimulatorOdeToJavaRungeKuttaAdaptive;
import org.systemsbiology.chem.odetojava.SimulatorOdeToJavaRungeKuttaImplicit;
import org.systemsbiology.math.Expression;
import org.systemsbiology.math.ReservedSymbolMapper;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.Value;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.CompartmentData;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledDynamicComponent;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledOperatorNode;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledSystemVariable;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.interfaces.ProgressMonitor;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.interfaces.Solver;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;
import uk.ac.ed.inf.biopepa.core.sba.Parameters;
import uk.ac.ed.inf.biopepa.core.sba.SBAComponentBehaviour;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;

public class ISBJava {
    private Model model;
    Map<String, Number> parameterMap = new HashMap<String, Number>();
    private SBAModel sbaModel;
    private String[] toObserve;
    private SimulationController simulationController;
    private SimulationProgressReporter simulationProgressReporter;
    private Simulator simulator;
    private SimulatorParameters simulatorParameters;
    private Set<String> addedParameters;

    private static Parameters odeParameters() {
        Parameters parameters = ISBJava.parameters();
        parameters.add(Parameters.Parameter.Step_Size);
        parameters.add(Parameters.Parameter.Absolute_Error);
        parameters.add(Parameters.Parameter.Relative_Error);
        return parameters;
    }

    private static final Parameters parameters() {
        Parameters parameters = new Parameters();
        parameters.add(Parameters.Parameter.Start_Time);
        parameters.add(Parameters.Parameter.Stop_Time);
        parameters.add(Parameters.Parameter.Data_Points);
        parameters.add(Parameters.Parameter.Components);
        return parameters;
    }

    private static Parameters stochasticParameters() {
        Parameters parameters = ISBJava.parameters();
        parameters.add(Parameters.Parameter.Independent_Replications);
        return parameters;
    }

    public ISBJava(SBAModel model, String[] toObserve) {
        this.sbaModel = model;
        this.toObserve = toObserve;
    }

    private Value generateRate(SBAReaction reaction, ExperimentSet.ExperimentLine experimentLine, boolean reverse) throws BioPEPAException {
        RatesVisitor rv = new RatesVisitor(experimentLine);
        rv.reaction = reaction;
        rv.reversing = reverse;
        reaction.reactionRate.accept(rv);
        return rv.getValue();
    }

    private void mapModel(ExperimentSet.ExperimentLine experimentLine) throws BioPEPAException {
        Map<String, Number> componentOverrides = experimentLine.getInitialPopulations();
        this.model = new Model();
        this.model.setReservedSymbolMapper((ReservedSymbolMapper)new ReservedSymbolMapperChemCommandLanguage());
        HashMap<String, Compartment> compartments = new HashMap<String, Compartment>();
        Compartment compartment = new Compartment("main");
        compartments.put(null, compartment);
        this.addedParameters = new HashSet<String>();
        for (Map.Entry<String, Double> me : this.sbaModel.compartments.entrySet()) {
            compartment = new Compartment(me.getKey());
            compartment.setVolume(me.getValue().doubleValue());
            compartments.put(me.getKey(), compartment);
            this.parameterMap.put(me.getKey(), new Double(me.getValue()));
        }
        HashMap<String, Species> speciesMap = new HashMap<String, Species>();
        ComponentNode[] componentNodeArray = this.sbaModel.getComponents();
        int n = componentNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentNode cn = componentNodeArray[n2];
            CompartmentData cd = cn.getCompartment();
            String componentName = cn.getName();
            Number componentCountNumber = componentOverrides.get(componentName);
            double componentCount = componentCountNumber == null ? (double)cn.getCount() : componentCountNumber.doubleValue();
            Species species = new Species(componentName, (Compartment)compartments.get(cd == null ? null : cd.getName()));
            species.setSpeciesPopulation(componentCount);
            speciesMap.put(componentName, species);
            this.parameterMap.put(componentName, new Double(componentCount));
            ++n2;
        }
        SBAReaction[] sBAReactionArray = this.sbaModel.getReactions();
        int n3 = sBAReactionArray.length;
        n = 0;
        while (n < n3) {
            SBAReaction r = sBAReactionArray[n];
            if (r.isEnabled() && experimentLine.isReactionActiviated(r.getName())) {
                Reaction reaction = r.isReversible() ? new Reaction(r.forwardName) : new Reaction(r.name);
                for (SBAComponentBehaviour cb : r.reactants) {
                    reaction.addReactant((Species)speciesMap.get(cb.getName()), cb.stoichiometry, cb.type.equals((Object)SBAComponentBehaviour.Type.REACTANT));
                }
                for (SBAComponentBehaviour cb : r.products) {
                    reaction.addProduct((Species)speciesMap.get(cb.getName()), cb.stoichiometry);
                }
                reaction.setRate(this.generateRate(r, experimentLine, false));
                this.model.addReaction(reaction);
                if (r.isReversible()) {
                    reaction = new Reaction(r.reversibleName);
                    for (SBAComponentBehaviour cb : r.products) {
                        reaction.addReactant((Species)speciesMap.get(cb.getName()), cb.stoichiometry, true);
                    }
                    for (SBAComponentBehaviour cb : r.reactants) {
                        reaction.addProduct((Species)speciesMap.get(cb.getName()), cb.stoichiometry);
                    }
                    reaction.setRate(this.generateRate(r, experimentLine, true));
                    this.model.addReaction(reaction);
                }
            }
            ++n;
        }
        String[] stringArray = this.toObserve;
        int n4 = this.toObserve.length;
        int n5 = 0;
        while (n5 < n4) {
            CompiledExpression ce;
            String s = stringArray[n5];
            if (!this.addedParameters.contains(s) && (ce = this.sbaModel.getDynamicExpression(s)) != null) {
                RatesVisitor rv = new RatesVisitor(experimentLine);
                ce.accept(rv);
                this.model.addParameter(new Parameter(s, new Expression(rv.element)));
            }
            ++n5;
        }
    }

    private SimulationResults run(Parameters requiredParameters, Parameters suppliedParameters, ProgressMonitor monitor) throws BioPEPAException {
        this.simulationProgressReporter = new SimulationProgressReporter();
        this.simulator.setProgressReporter(this.simulationProgressReporter);
        this.simulationController = new SimulationController();
        this.simulator.setController(this.simulationController);
        if (!suppliedParameters.setOfKeys().containsAll(requiredParameters.setOfKeys())) {
            throw new IllegalArgumentException("Incorrect parameters supplied.");
        }
        double startTime = (Double)suppliedParameters.getValue(Parameters.Parameter.Start_Time);
        double stopTime = (Double)suppliedParameters.getValue(Parameters.Parameter.Stop_Time);
        if (startTime < 0.0 || startTime >= stopTime) {
            throw new IllegalArgumentException("Start time < 0.00 || start time >= stop time.");
        }
        int samples = (Integer)suppliedParameters.getValue(Parameters.Parameter.Data_Points);
        if (samples < 3) {
            throw new IllegalArgumentException(String.valueOf(Parameters.Parameter.Data_Points.toString()) + " must be greater than 2.");
        }
        String[] species = (String[])suppliedParameters.getValue(Parameters.Parameter.Components);
        if (species.length == 0) {
            throw new IllegalArgumentException(String.valueOf(Parameters.Parameter.Components.toString()) + " must contain at least one component.");
        }
        Parameters.Parameter[] parameterArray = requiredParameters.arrayOfKeys();
        int n = parameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            double tDouble;
            Parameters.Parameter p = parameterArray[n2];
            if (p.equals((Object)Parameters.Parameter.Step_Size)) {
                tDouble = (Double)suppliedParameters.getValue(p);
                if (tDouble <= 0.0) {
                    throw new IllegalArgumentException(String.valueOf(p.toString()) + " must be greater than 0.00.");
                }
                this.simulatorParameters.setStepSizeFraction(tDouble);
            } else if (p.equals((Object)Parameters.Parameter.Independent_Replications)) {
                int tInt = (Integer)suppliedParameters.getValue(p);
                if (tInt < 1) {
                    throw new IllegalArgumentException(String.valueOf(p.toString()) + " must be greater than 0.");
                }
                this.simulatorParameters.setEnsembleSize(tInt);
            } else if (p.equals((Object)Parameters.Parameter.Relative_Error)) {
                tDouble = (Double)suppliedParameters.getValue(p);
                if (tDouble <= 0.0) {
                    throw new IllegalArgumentException(String.valueOf(p.toString()) + " must be greater than 0.00.");
                }
                this.simulatorParameters.setMaxAllowedRelativeError(tDouble);
            } else if (p.equals((Object)Parameters.Parameter.Absolute_Error)) {
                tDouble = (Double)suppliedParameters.getValue(p);
                if (tDouble <= 0.0) {
                    throw new IllegalArgumentException(String.valueOf(p.toString()) + " must be greater than 0.00.");
                }
                this.simulatorParameters.setMaxAllowedAbsoluteError(tDouble);
            }
            ++n2;
        }
        this.simulationProgressReporter.setSimulationFinished(false);
        Thread monitorController = null;
        if (monitor != null) {
            monitorController = new Thread(){

                public void run() {
                    try {
                        int SCALING_UNIT = 100;
                        int previous = 0;
                        int current = 0;
                        monitor.beginTask(SCALING_UNIT);
                        while (!ISBJava.this.simulationProgressReporter.getSimulationFinished()) {
                            if (monitor.isCanceled()) {
                                ISBJava.this.simulationController.setCancelled(true);
                            }
                            ISBJava.this.simulationProgressReporter.waitForUpdate();
                            current = (int)(ISBJava.this.simulationProgressReporter.getFractionComplete() * 100.0);
                            monitor.worked(current - previous);
                            previous = current;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            monitorController.start();
        }
        SimulationResults results = null;
        try {
            if (this.simulator instanceof SimulatorStochasticBase) {
                results = ((SimulatorStochasticBase)this.simulator).simulate(startTime, stopTime, this.simulatorParameters, samples, species);
            } else if (this.simulator instanceof SimulatorOdeToJavaBase) {
                results = ((SimulatorOdeToJavaBase)this.simulator).simulate(startTime, stopTime, this.simulatorParameters, samples, species);
            }
        }
        catch (Exception e) {
            throw new BioPEPAException(e.getMessage());
        }
        return results;
    }

    static class DormandPrince
    implements Solver {
        DormandPrince() {
        }

        public String getDescriptiveName() {
            return "Adaptive step-size 5th-order Dormand Prince ODE Solver";
        }

        public Parameters getRequiredParameters() {
            return ISBJava.odeParameters();
        }

        public String getShortName() {
            return "dopr-adaptive";
        }

        public Result startTimeSeriesAnalysis(SBAModel model, Parameters parameters, ExperimentSet.ExperimentLine experimentLine, ProgressMonitor monitor) throws BioPEPAException {
            ISBJava isbjava = new ISBJava(model, (String[])parameters.getValue(Parameters.Parameter.Components));
            isbjava.simulator = (Simulator)new SimulatorOdeToJavaRungeKuttaAdaptive();
            isbjava.simulatorParameters = ((SimulatorOdeToJavaBase)isbjava.simulator).getDefaultSimulatorParameters();
            isbjava.mapModel(experimentLine);
            try {
                ((SimulatorOdeToJavaRungeKuttaAdaptive)isbjava.simulator).initialize(isbjava.model);
            }
            catch (Exception e) {
                throw new BioPEPAException(e);
            }
            SimulationResults results = isbjava.run(this.getRequiredParameters(), parameters, monitor);
            if (monitor.isCanceled()) {
                return null;
            }
            return new Results(results, false, parameters, isbjava.parameterMap, this.getDescriptiveName());
        }

        public Solver.SolverResponse getResponse(final SBAModel model) {
            return new Solver.SolverResponse(){

                public String getMessage() {
                    if (model.nonDifferentiableFunctions) {
                        return "The model uses functions that may invalidate the results from ODE analysis.";
                    }
                    return null;
                }

                public Solver.SolverResponse.Suitability getSuitability() {
                    if (model.nonDifferentiableFunctions) {
                        return Solver.SolverResponse.Suitability.WARNING;
                    }
                    return Solver.SolverResponse.Suitability.PERMISSIBLE;
                }
            };
        }
    }

    static class GibsonBruck
    implements Solver {
        GibsonBruck() {
        }

        public String getDescriptiveName() {
            return "Gibson-Bruck Stochastic Algorithm";
        }

        public Parameters getRequiredParameters() {
            return ISBJava.stochasticParameters();
        }

        public String getShortName() {
            return "gibson-bruck";
        }

        public Result startTimeSeriesAnalysis(SBAModel model, Parameters parameters, ExperimentSet.ExperimentLine experimentLine, ProgressMonitor monitor) throws BioPEPAException {
            ISBJava isbjava = new ISBJava(model, (String[])parameters.getValue(Parameters.Parameter.Components));
            isbjava.simulator = (Simulator)new SimulatorStochasticGibsonBruck();
            isbjava.simulatorParameters = ((SimulatorStochasticBase)isbjava.simulator).getDefaultSimulatorParameters();
            isbjava.mapModel(experimentLine);
            try {
                ((SimulatorStochasticGibsonBruck)isbjava.simulator).initialize(isbjava.model);
            }
            catch (Exception e) {
                throw new BioPEPAException(e);
            }
            SimulationResults results = isbjava.run(this.getRequiredParameters(), parameters, monitor);
            if (monitor.isCanceled()) {
                return null;
            }
            return new Results(results, true, parameters, isbjava.parameterMap, this.getDescriptiveName());
        }

        public Solver.SolverResponse getResponse(final SBAModel model) {
            return new Solver.SolverResponse(){

                public String getMessage() {
                    if (model.timeDependentRates) {
                        return "This algorithm may not correctly simulate models dependent on time.";
                    }
                    return null;
                }

                public Solver.SolverResponse.Suitability getSuitability() {
                    if (model.timeDependentRates) {
                        return Solver.SolverResponse.Suitability.WARNING;
                    }
                    return Solver.SolverResponse.Suitability.PERMISSIBLE;
                }
            };
        }
    }

    static class Gillespie
    implements Solver {
        Gillespie() {
        }

        public String getDescriptiveName() {
            return "Gillespie's Stochastic Algorithm";
        }

        public Parameters getRequiredParameters() {
            return ISBJava.stochasticParameters();
        }

        public String getShortName() {
            return "gillespie";
        }

        public Result startTimeSeriesAnalysis(SBAModel model, Parameters parameters, ExperimentSet.ExperimentLine experimentLine, ProgressMonitor monitor) throws BioPEPAException {
            ISBJava isbjava = new ISBJava(model, (String[])parameters.getValue(Parameters.Parameter.Components));
            isbjava.simulator = (Simulator)new SimulatorStochasticGillespie();
            isbjava.simulatorParameters = ((SimulatorStochasticBase)isbjava.simulator).getDefaultSimulatorParameters();
            isbjava.mapModel(experimentLine);
            try {
                ((SimulatorStochasticGillespie)isbjava.simulator).initialize(isbjava.model);
            }
            catch (Exception e) {
                throw new BioPEPAException(e);
            }
            SimulationResults results = isbjava.run(this.getRequiredParameters(), parameters, monitor);
            if (monitor.isCanceled()) {
                return null;
            }
            return new Results(results, true, parameters, isbjava.parameterMap, this.getDescriptiveName());
        }

        public Solver.SolverResponse getResponse(final SBAModel model) {
            return new Solver.SolverResponse(){

                public String getMessage() {
                    if (model.timeDependentRates) {
                        return "This algorithm may not correctly simulate models dependent on time.";
                    }
                    return null;
                }

                public Solver.SolverResponse.Suitability getSuitability() {
                    if (model.timeDependentRates) {
                        return Solver.SolverResponse.Suitability.WARNING;
                    }
                    return Solver.SolverResponse.Suitability.PERMISSIBLE;
                }
            };
        }
    }

    static class IMEX
    implements Solver {
        IMEX() {
        }

        public String getDescriptiveName() {
            return "Implicit-Explicit Runge Kutta ODE Solver";
        }

        public Parameters getRequiredParameters() {
            return ISBJava.odeParameters();
        }

        public String getShortName() {
            return "imex-stiff";
        }

        public Result startTimeSeriesAnalysis(SBAModel model, Parameters parameters, ExperimentSet.ExperimentLine experimentLine, ProgressMonitor monitor) throws BioPEPAException {
            ISBJava isbjava = new ISBJava(model, (String[])parameters.getValue(Parameters.Parameter.Components));
            isbjava.simulator = (Simulator)new SimulatorOdeToJavaRungeKuttaImplicit();
            isbjava.simulatorParameters = ((SimulatorOdeToJavaBase)isbjava.simulator).getDefaultSimulatorParameters();
            isbjava.mapModel(experimentLine);
            try {
                ((SimulatorOdeToJavaRungeKuttaImplicit)isbjava.simulator).initialize(isbjava.model);
            }
            catch (Exception e) {
                throw new BioPEPAException(e);
            }
            SimulationResults results = isbjava.run(this.getRequiredParameters(), parameters, monitor);
            if (monitor.isCanceled()) {
                return null;
            }
            return new Results(results, false, parameters, isbjava.parameterMap, this.getDescriptiveName());
        }

        public Solver.SolverResponse getResponse(final SBAModel model) {
            return new Solver.SolverResponse(){

                public String getMessage() {
                    if (model.nonDifferentiableFunctions) {
                        return "The model uses functions that may invalidate the results from ODE analysis.";
                    }
                    return null;
                }

                public Solver.SolverResponse.Suitability getSuitability() {
                    if (model.nonDifferentiableFunctions) {
                        return Solver.SolverResponse.Suitability.WARNING;
                    }
                    return Solver.SolverResponse.Suitability.PERMISSIBLE;
                }
            };
        }
    }

    public class RatesVisitor
    extends CompiledExpressionVisitor {
        Expression.Element element;
        SBAReaction reaction;
        boolean root = true;
        boolean reversing = false;
        ExperimentSet.ExperimentLine experimentLine;

        public RatesVisitor(ExperimentSet.ExperimentLine experLine) {
            this.experimentLine = experLine;
        }

        public boolean visit(CompiledDynamicComponent component) {
            String name = component.getName();
            CompiledExpression ce = ISBJava.this.sbaModel.getDynamicExpression(name);
            if (ce != null && !ISBJava.this.addedParameters.contains(name)) {
                ISBJava.this.addedParameters.add(name);
                ce.accept(this);
                if (this.element.mCode.equals(Expression.ElementCode.NUMBER)) {
                    ISBJava.this.model.addParameter(new Parameter(name, this.element.mNumericValue));
                } else {
                    ISBJava.this.model.addParameter(new Parameter(name, new Expression(this.element)));
                }
            }
            this.element = new Expression.Element(Expression.ElementCode.SYMBOL);
            this.element.mSymbol = new Symbol(name);
            return true;
        }

        public boolean visit(CompiledFunction function) {
            if (this.removeInline(function)) {
                return true;
            }
            if (this.root) {
                this.root = false;
                if (function.getFunction().isRateLaw()) {
                    switch (function.getFunction()) {
                        case fMA: {
                            Expression.Element e2;
                            function.getArguments().get(0).accept(this);
                            if (this.element.mCode.equals(Expression.ElementCode.NUMBER)) break;
                            List<SBAComponentBehaviour> reactants = this.reaction.reactants;
                            if (this.reversing) {
                                reactants = this.reaction.products;
                            }
                            if (reactants.size() == 0) break;
                            Expression.Element e1 = this.prep(reactants.get(0));
                            int i = 1;
                            while (i < reactants.size()) {
                                e2 = new Expression.Element(Expression.ElementCode.MULT);
                                e2.mSecondOperand = e1;
                                e2.mFirstOperand = this.prep(reactants.get(i));
                                e1 = e2;
                                ++i;
                            }
                            e2 = new Expression.Element(Expression.ElementCode.MULT);
                            e2.mSecondOperand = e1;
                            e2.mFirstOperand = this.element;
                            this.element = e2;
                            break;
                        }
                        case fMM: {
                            function.getArguments().get(0).accept(this);
                            Expression.Element e1 = new Expression.Element(Expression.ElementCode.MULT);
                            e1.mFirstOperand = this.element;
                            Expression.Element e2 = new Expression.Element(Expression.ElementCode.MULT);
                            SBAComponentBehaviour substrate = null;
                            Expression.Element[] eArray = new Expression.Element[2];
                            int i = 0;
                            for (SBAComponentBehaviour cb : this.reaction.reactants) {
                                if (cb.type.equals((Object)SBAComponentBehaviour.Type.REACTANT)) {
                                    substrate = cb;
                                }
                                eArray[i++] = this.prep(cb);
                            }
                            e2.mFirstOperand = eArray[0];
                            e2.mSecondOperand = eArray[1];
                            e1.mSecondOperand = e2;
                            e2 = new Expression.Element(Expression.ElementCode.DIV);
                            e2.mFirstOperand = e1;
                            e1 = e2;
                            e2 = new Expression.Element(Expression.ElementCode.ADD);
                            function.getArguments().get(1).accept(this);
                            e2.mFirstOperand = this.element;
                            e2.mSecondOperand = this.prep(substrate);
                            e1.mSecondOperand = e2;
                            this.element = e1;
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    return true;
                }
            }
            if (function.getFunction().args() == 1) {
                Expression.Element newElement;
                function.getArguments().get(0).accept(this);
                switch (function.getFunction()) {
                    case LOG: {
                        newElement = new Expression.Element(Expression.ElementCode.LN);
                        break;
                    }
                    case EXP: {
                        newElement = new Expression.Element(Expression.ElementCode.EXP);
                        break;
                    }
                    case H: {
                        newElement = new Expression.Element(Expression.ElementCode.THETA);
                        break;
                    }
                    case FLOOR: {
                        newElement = new Expression.Element(Expression.ElementCode.FLOOR);
                        break;
                    }
                    case CEILING: {
                        newElement = new Expression.Element(Expression.ElementCode.CEIL);
                        break;
                    }
                    case TANH: {
                        newElement = new Expression.Element(Expression.ElementCode.TANH);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                newElement.mFirstOperand = this.element;
                this.element = newElement;
            }
            return true;
        }

        public boolean visit(CompiledNumber number) {
            if (this.removeInline(number)) {
                return true;
            }
            this.element = new Expression.Element(number.doubleValue());
            return false;
        }

        public boolean visit(CompiledOperatorNode operator) {
            if (this.removeInline(operator)) {
                return true;
            }
            this.root = false;
            operator.getLeft().accept(this);
            Expression.Element left = this.element;
            operator.getRight().accept(this);
            Expression.Element right = this.element;
            Expression.ElementCode code = null;
            switch (operator.getOperator()) {
                case PLUS: {
                    code = Expression.ElementCode.ADD;
                    break;
                }
                case MINUS: {
                    code = Expression.ElementCode.SUBT;
                    break;
                }
                case DIVIDE: {
                    code = Expression.ElementCode.DIV;
                    break;
                }
                case MULTIPLY: {
                    code = Expression.ElementCode.MULT;
                    break;
                }
                case POWER: {
                    code = Expression.ElementCode.POW;
                }
            }
            this.element = new Expression.Element(code);
            this.element.mFirstOperand = left;
            this.element.mSecondOperand = right;
            return true;
        }

        private boolean removeInline(CompiledExpression ce) {
            if (ce.hasExpandedForm() && ce.returnExpandedForm() instanceof CompiledDynamicComponent) {
                CompiledDynamicComponent cdc = (CompiledDynamicComponent)ce.returnExpandedForm();
                String cvName = cdc.getName();
                cvName = ce.returnExpandedForm().toString();
                Number expandedValue = this.experimentLine.getRateValue(cvName);
                if (expandedValue != null) {
                    this.element = new Expression.Element(expandedValue.doubleValue());
                    return true;
                }
                if (ISBJava.this.sbaModel.inline(cvName)) {
                    return false;
                }
                return cdc.accept(this);
            }
            return false;
        }

        public Value getValue() {
            if (this.element.mCode.equals(Expression.ElementCode.NUMBER)) {
                return new Value(this.element.mNumericValue);
            }
            return new Value(new Expression(this.element));
        }

        private final Expression.Element prep(SBAComponentBehaviour cb) {
            Expression.Element e = null;
            if (cb.stoichiometry > 1) {
                e = new Expression.Element(Expression.ElementCode.POW);
                e.mFirstOperand = new Expression.Element(Expression.ElementCode.SYMBOL);
                e.mFirstOperand.mSymbol = new Symbol(cb.getName());
                e.mSecondOperand = new Expression.Element((double)cb.stoichiometry);
            } else {
                e = new Expression.Element(Expression.ElementCode.SYMBOL);
                e.mSymbol = new Symbol(cb.getName());
            }
            return e;
        }

        public boolean visit(CompiledSystemVariable variable) {
            if (this.removeInline(variable)) {
                return true;
            }
            switch (variable.getVariable()) {
                case TIME: {
                    this.element = new Expression.Element(Expression.ElementCode.SYMBOL);
                    this.element.mSymbol = new Symbol("time");
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Results
    implements Result {
        String[] actionNames;
        String[] componentNames;
        Map<String, Number> modelParameters = new HashMap<String, Number>();
        Map<String, Number> uModelParameters = Collections.unmodifiableMap(this.modelParameters);
        String simulator;
        Map<String, Number> simulatorParameters = new HashMap<String, Number>();
        Map<String, Number> uSimulatorParameters = Collections.unmodifiableMap(this.simulatorParameters);
        boolean throughput = false;
        double[] throughputValues;
        double[] time;
        double[][] results;
        private int[] resultHashes;
        private int timeHashes;

        /*
         * WARNING - void declaration
         */
        Results(SimulationResults results, boolean throughput, Parameters parameters, Map<String, Number> modelParameters, String simulator) {
            void var6_11;
            this.componentNames = results.getResultsSymbolNames();
            this.throughput = throughput;
            this.simulator = simulator;
            for (Map.Entry<Parameters.Parameter, Object> entry : parameters.parameters.entrySet()) {
                if (entry.getKey().equals((Object)Parameters.Parameter.Components) || !(entry.getValue() instanceof Number)) continue;
                this.simulatorParameters.put(entry.getKey().descriptiveName, (Number)entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : modelParameters.entrySet()) {
                this.modelParameters.put((String)entry.getKey(), (Number)entry.getValue());
            }
            this.time = results.getResultsTimeValues();
            this.timeHashes = Arrays.hashCode(this.time);
            this.results = new double[this.componentNames.length][];
            boolean bl = false;
            while (var6_11 < this.componentNames.length) {
                this.results[var6_11] = new double[this.time.length];
                ++var6_11;
            }
            Object[] objectArray = results.getResultsSymbolValues();
            int i2 = 0;
            while (i2 < objectArray.length) {
                double[] d = (double[])objectArray[i2];
                int j = 0;
                while (j < d.length) {
                    this.results[j][i2] = d[j];
                    ++j;
                }
                ++i2;
            }
            this.resultHashes = new int[this.componentNames.length];
            int i = 0;
            while (i < this.resultHashes.length) {
                this.resultHashes[i] = Arrays.hashCode(this.results[i]);
                ++i;
            }
            if (throughput) {
                this.actionNames = results.getReactionNames();
                this.throughputValues = new double[this.actionNames.length];
                double[] times = results.getReactionTimes();
                double[] firings = results.getReactionCounts();
                int i3 = 0;
                while (i3 < times.length) {
                    this.throughputValues[i3] = times[i3] / firings[i3];
                    ++i3;
                }
            }
        }

        @Override
        public String[] getActionNames() {
            if (this.actionNames == null) {
                return new String[0];
            }
            return (String[])this.actionNames.clone();
        }

        @Override
        public double getActionThroughput(int index) {
            return this.throughputValues[index];
        }

        @Override
        public String[] getComponentNames() {
            if (this.componentNames == null) {
                return new String[0];
            }
            return (String[])this.componentNames.clone();
        }

        @Override
        public Map<String, Number> getModelParameters() {
            return this.uModelParameters;
        }

        @Override
        public double getPopulation(int index) {
            return this.results[index][this.results[0].length - 1];
        }

        @Override
        public String getSimulatorName() {
            return this.simulator;
        }

        @Override
        public Map<String, Number> getSimulatorParameters() {
            return this.uSimulatorParameters;
        }

        @Override
        public double[] getTimeSeries(int index) {
            if (Arrays.hashCode(this.results[index]) != this.resultHashes[index]) {
                throw new IllegalStateException("Time series has been modified since initial storage.");
            }
            return this.results[index];
        }

        @Override
        public boolean throughputSupported() {
            return this.throughput;
        }

        @Override
        public double[] getTimePoints() {
            if (Arrays.hashCode(this.time) != this.timeHashes) {
                throw new IllegalStateException(" has been modified since initial storage.");
            }
            return this.time;
        }
    }

    static class TauLeap
    implements Solver {
        TauLeap() {
        }

        public String getDescriptiveName() {
            return "Gillespie's Tau-Leap Stochastic Algorithm";
        }

        public Parameters getRequiredParameters() {
            Parameters p = ISBJava.stochasticParameters();
            p.add(Parameters.Parameter.Step_Size);
            p.add(Parameters.Parameter.Relative_Error);
            return p;
        }

        public String getShortName() {
            return "tau-leap";
        }

        public Result startTimeSeriesAnalysis(SBAModel model, Parameters parameters, ExperimentSet.ExperimentLine experimentLine, ProgressMonitor monitor) throws BioPEPAException {
            ISBJava isbjava = new ISBJava(model, (String[])parameters.getValue(Parameters.Parameter.Components));
            isbjava.simulator = (Simulator)new SimulatorStochasticTauLeapComplex();
            isbjava.simulatorParameters = ((SimulatorStochasticTauLeapBase)isbjava.simulator).getDefaultSimulatorParameters();
            isbjava.mapModel(experimentLine);
            try {
                ((SimulatorStochasticTauLeapComplex)isbjava.simulator).initialize(isbjava.model);
            }
            catch (Exception e) {
                throw new BioPEPAException(e);
            }
            SimulationResults results = isbjava.run(this.getRequiredParameters(), parameters, monitor);
            if (monitor.isCanceled()) {
                return null;
            }
            return new Results(results, false, parameters, isbjava.parameterMap, this.getDescriptiveName());
        }

        public Solver.SolverResponse getResponse(final SBAModel model) {
            return new Solver.SolverResponse(){

                public String getMessage() {
                    if (model.timeDependentRates) {
                        return "This algorithm cannot simulate models dependent on time.";
                    }
                    return null;
                }

                public Solver.SolverResponse.Suitability getSuitability() {
                    if (model.timeDependentRates) {
                        return Solver.SolverResponse.Suitability.UNSUITABLE;
                    }
                    return Solver.SolverResponse.Suitability.PERMISSIBLE;
                }
            };
        }
    }
}

