/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba;

import uk.ac.ed.inf.biopepa.core.compiler.PrefixData;
import uk.ac.ed.inf.biopepa.core.dom.AST;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBAComponentBehaviour
implements Comparable<SBAComponentBehaviour> {
    private static final String IN = AST.Literals.LOCATION.getToken();
    String name;
    String compartment = null;
    Type type;
    int stoichiometry = 1;

    SBAComponentBehaviour(String name, String compartment, Type type) {
        if (name == null || type == null) {
            throw new IllegalArgumentException("Component and type must be declared at initialisation.");
        }
        this.name = name;
        this.compartment = compartment;
        this.type = type;
    }

    SBAComponentBehaviour(String name, String compartment, PrefixData.Operator operator) {
        if (name == null || operator == null) {
            throw new IllegalArgumentException("Component and operator must be declared at initialisation.");
        }
        this.name = name;
        this.compartment = compartment;
        if (operator.equals((Object)PrefixData.Operator.REACTANT)) {
            this.type = Type.REACTANT;
        } else if (operator.equals((Object)PrefixData.Operator.PRODUCT)) {
            this.type = Type.PRODUCT;
        } else if (operator.equals((Object)PrefixData.Operator.ACTIVATOR)) {
            this.type = Type.CATALYST;
        } else if (operator.equals((Object)PrefixData.Operator.INHIBITOR)) {
            this.type = Type.INHIBITOR;
        } else if (operator.equals((Object)PrefixData.Operator.GENERIC)) {
            this.type = Type.MODIFIER;
        } else {
            throw new IllegalArgumentException("Unknown Operator.");
        }
    }

    public SBAComponentBehaviour clone() {
        SBAComponentBehaviour clone = new SBAComponentBehaviour(this.name, this.compartment, this.type);
        clone.stoichiometry = this.stoichiometry;
        return clone;
    }

    @Override
    public int compareTo(SBAComponentBehaviour c) {
        return this.getName().compareTo(c.getName());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SBAComponentBehaviour)) {
            return false;
        }
        return this.compareTo((SBAComponentBehaviour)o) == 0;
    }

    public String getName() {
        if (this.compartment == null) {
            return this.name;
        }
        return String.valueOf(this.name) + IN + this.compartment;
    }

    public int getStoichiometry() {
        return this.stoichiometry;
    }

    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    void setStoichiometry(int stoichiometry) {
        if (!this.type.equals((Object)Type.REACTANT) && !this.type.equals((Object)Type.PRODUCT) && stoichiometry != 1) {
            throw new UnsupportedOperationException("Stoichiometry is not supported for components of type " + this.type.toString() + ".");
        }
        if (stoichiometry < 1) {
            throw new IllegalArgumentException("Stoichiometric values must be greater than zero.");
        }
        this.stoichiometry = stoichiometry;
    }

    public String toCMDL() {
        boolean dollar = this.type.equals((Object)Type.CATALYST) || this.type.equals((Object)Type.INHIBITOR) || this.type.equals((Object)Type.MODIFIER);
        StringBuilder sb = new StringBuilder();
        int i = this.stoichiometry;
        while (i > 0) {
            if (dollar) {
                sb.append("$");
            }
            sb.append(this.getName()).append(" + ");
            --i;
        }
        sb.delete(sb.length() - 3, sb.length());
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.stoichiometry > 1) {
            sb.append(this.stoichiometry).append(".");
        }
        sb.append(this.type.equals((Object)Type.CATALYST) || this.type.equals((Object)Type.INHIBITOR) || this.type.equals((Object)Type.MODIFIER) ? "$" : "");
        sb.append(this.getName());
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        REACTANT("reactant"),
        PRODUCT("product"),
        CATALYST("catalyst"),
        INHIBITOR("inhibitor"),
        MODIFIER("modifier");

        String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

