/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import uk.ac.ed.inf.biopepa.core.compiler.ActionData;
import uk.ac.ed.inf.biopepa.core.compiler.CompartmentData;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledDynamicComponent;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledOperatorNode;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledSystemVariable;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.compiler.CooperationNode;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.PrefixData;
import uk.ac.ed.inf.biopepa.core.compiler.SystemEquationNode;
import uk.ac.ed.inf.biopepa.core.compiler.TransportData;
import uk.ac.ed.inf.biopepa.core.compiler.VariableData;
import uk.ac.ed.inf.biopepa.core.sba.SBAComponentBehaviour;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;

public class SBAModel {
    boolean timeDependentRates;
    boolean nonDifferentiableFunctions;
    Map<String, Double> compartments = new HashMap<String, Double>();
    ModelCompiler compiledBioPEPA;
    private int componentCount;
    private Map<String, Set<ComponentNode>> components = new HashMap<String, Set<ComponentNode>>();
    private Map<String, CompiledExpression> dynamicVariables = new HashMap<String, CompiledExpression>();
    private Set<String> dontInline = new HashSet<String>();
    private Map<String, SBAReaction> reactions = new HashMap<String, SBAReaction>();

    public SBAModel(ModelCompiler compiledBioPEPA) {
        this.compiledBioPEPA = compiledBioPEPA;
    }

    public CompartmentData[] getCompartments() {
        CompartmentData[] cd = new CompartmentData[this.compartments.size()];
        int i = 0;
        for (String s : this.compartments.keySet()) {
            cd[i++] = this.compiledBioPEPA.getCompartmentData(s);
        }
        return cd;
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public String[] getComponentNames() {
        String[] sArray = new String[this.componentCount];
        int i = 0;
        for (Map.Entry<String, Set<ComponentNode>> me : this.components.entrySet()) {
            for (ComponentNode node : me.getValue()) {
                sArray[i++] = node.getName();
            }
        }
        Arrays.sort(sArray, String.CASE_INSENSITIVE_ORDER);
        return sArray;
    }

    public ComponentNode[] getComponents() {
        String[] sArray1 = this.components.keySet().toArray(new String[0]);
        Arrays.sort(sArray1, String.CASE_INSENSITIVE_ORDER);
        ComponentNode[] speciesArray = new ComponentNode[this.componentCount];
        HashMap<String, ComponentNode> map = new HashMap<String, ComponentNode>();
        int i = 0;
        String[] stringArray = sArray1;
        int n = sArray1.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            map.clear();
            for (ComponentNode cn : this.components.get(s)) {
                map.put(cn.getName(), cn);
            }
            String[] sArray2 = map.keySet().toArray(new String[0]);
            Arrays.sort(sArray2, String.CASE_INSENSITIVE_ORDER);
            String[] stringArray2 = sArray2;
            int n3 = sArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String s2 = stringArray2[n4];
                speciesArray[i++] = (ComponentNode)map.get(s2);
                ++n4;
            }
            ++n2;
        }
        return speciesArray;
    }

    public long getNamedComponentCount(String componentName) {
        ComponentNode[] componentNodes;
        ComponentNode[] componentNodeArray = componentNodes = this.getComponents();
        int n = componentNodes.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentNode compNode = componentNodeArray[n2];
            if (compNode.getName().equals(componentName)) {
                return compNode.getCount();
            }
            ++n2;
        }
        return 0L;
    }

    public void setComponentCount(String componentName, long newCount) {
        ComponentNode[] componentNodeArray = this.getComponents();
        int n = componentNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentNode compNode = componentNodeArray[n2];
            if (componentName.equals(compNode.getName())) {
                compNode.setCount(newCount);
                return;
            }
            ++n2;
        }
    }

    public CompiledExpression getDynamicExpression(String name) {
        return this.dynamicVariables.get(name);
    }

    boolean inline(String name) {
        return !this.dontInline.contains(name);
    }

    public CompiledExpression getStaticExpression(String name) {
        if (this.dynamicVariables.containsKey(name)) {
            return null;
        }
        VariableData vd = this.compiledBioPEPA.getVariableData(name);
        if (vd != null) {
            return vd.getValue();
        }
        return null;
    }

    public String[] getDynamicVariableNames() {
        String[] sArray = this.dynamicVariables.keySet().toArray(new String[0]);
        Arrays.sort(sArray, String.CASE_INSENSITIVE_ORDER);
        return sArray;
    }

    public SBAReaction[] getReactions() {
        String[] sArray = this.reactions.keySet().toArray(new String[0]);
        Arrays.sort(sArray, String.CASE_INSENSITIVE_ORDER);
        SBAReaction[] reactionArray = new SBAReaction[sArray.length];
        int i = sArray.length - 1;
        while (i >= 0) {
            reactionArray[i] = this.reactions.get(sArray[i]);
            --i;
        }
        return reactionArray;
    }

    public void parseBioPEPA() {
        List<SBAReaction> lSBAR;
        SystemEquationVisitor sev = new SystemEquationVisitor();
        sev.visit(this.compiledBioPEPA.getSystemEquation());
        HashSet<String> used = new HashSet<String>();
        VariableData[] variableDataArray = this.compiledBioPEPA.getDynamicVariables();
        int n = variableDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableData vd = variableDataArray[n2];
            this.dynamicVariables.put(vd.getName(), vd.getValue());
            used.add(vd.getName());
            if (vd.getUsage() > 1) {
                this.dontInline.add(vd.getName());
            }
            ++n2;
        }
        for (Map.Entry<String, List<SBAReaction>> me : sev.currentReactions.entrySet()) {
            lSBAR = me.getValue();
            if (lSBAR.size() != 1 || lSBAR.get(0).isReversible()) continue;
            this.reactions.put(me.getKey(), me.getValue().get(0));
            used.add(me.getKey());
        }
        for (Map.Entry<String, List<SBAReaction>> me : sev.currentReactions.entrySet()) {
            lSBAR = me.getValue();
            if (lSBAR.size() <= 1 && !lSBAR.get(0).isReversible()) continue;
            String name = me.getKey();
            int i = name.length() + 1;
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            Pattern p = Pattern.compile(String.valueOf(name) + "_\\d+");
            for (String existing : used) {
                if (!p.matcher(existing).matches()) continue;
                numbers.add(new Integer(existing.substring(i)));
            }
            if (numbers.size() > 0) {
                int[] intArray = new int[numbers.size()];
                int index = 0;
                while (index < intArray.length) {
                    intArray[index] = (Integer)numbers.get(index);
                    ++index;
                }
                Arrays.sort(intArray);
                i = intArray[intArray.length - 1] + 1;
            } else {
                i = 1;
                if (used.contains(name)) {
                    ++i;
                }
            }
            for (SBAReaction r : lSBAR) {
                if (r.isReversible()) {
                    if (used.contains(name)) {
                        r.name = String.valueOf(name) + "_" + i;
                    }
                    r.forwardName = String.valueOf(name) + "_" + i++;
                    r.reversibleName = String.valueOf(name) + "_" + i++;
                    used.add(r.forwardName);
                    used.add(r.reversibleName);
                } else {
                    r.name = String.valueOf(name) + "_" + i++;
                }
                this.reactions.put(r.name, r);
                used.add(r.name);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.compartments.size() > 0) {
            sb.append("// Compartments\n");
            for (Map.Entry<String, Double> me : this.compartments.entrySet()) {
                sb.append(me.getKey()).append(" = ").append(me.getValue()).append(";\n");
            }
            sb.append("\n");
        }
        sb.append("// Components\n");
        ComponentNode[] componentNodeArray = this.getComponents();
        int n = componentNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentNode cn = componentNodeArray[n2];
            sb.append(cn.getName()).append(" = ").append(cn.getCount()).append(";\n");
            ++n2;
        }
        sb.append("\n");
        sb.append("// Reactions\n");
        for (SBAReaction r : this.reactions.values()) {
            sb.append(r.toString()).append(";\n");
        }
        return sb.toString();
    }

    private class SystemEquationVisitor {
        Set<String> actions = new HashSet<String>();
        Map<String, List<SBAReaction>> currentReactions = new HashMap<String, List<SBAReaction>>();
        List<SBAReaction> newList;
        FunctionChecker fc = new FunctionChecker();

        private SystemEquationVisitor() {
        }

        void visit(ComponentNode node) {
            HashSet<ComponentNode> s;
            SBAModel sBAModel = SBAModel.this;
            sBAModel.componentCount = sBAModel.componentCount + 1;
            SBAReaction reaction = null;
            String name = node.getComponent();
            String compartmentName = null;
            CompartmentData compartment = node.getCompartment();
            if (compartment != null) {
                compartmentName = compartment.getName();
                SBAModel.this.compartments.put(compartmentName, compartment.getVolume());
                if (SBAModel.this.components.containsKey(name)) {
                    ((Set)SBAModel.this.components.get(name)).add(node);
                } else {
                    s = new HashSet();
                    s.add(node);
                    SBAModel.this.components.put(name, s);
                }
            } else {
                s = new HashSet<ComponentNode>();
                s.add(node);
                SBAModel.this.components.put(name, s);
            }
            PrefixData[] prefixDataArray = SBAModel.this.compiledBioPEPA.getComponentData(node.getComponent()).getPrefixes();
            int n = prefixDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                block7: {
                    SBAComponentBehaviour behaviour;
                    block8: {
                        block9: {
                            TransportData td;
                            block11: {
                                block10: {
                                    PrefixData prefix;
                                    block6: {
                                        prefix = prefixDataArray[n2];
                                        String reactionName = prefix.getFunction();
                                        CompiledExpression ce = SBAModel.this.compiledBioPEPA.getFunctionalRate(reactionName).getRightHandSide();
                                        ce.accept(this.fc);
                                        reaction = new SBAReaction(reactionName, ce);
                                        if (!(prefix instanceof ActionData)) break block6;
                                        ActionData ad = (ActionData)prefix;
                                        if (ad.getLocations().size() > 0 && !ad.getLocations().contains(compartment.getName())) break block7;
                                        behaviour = new SBAComponentBehaviour(name, compartmentName, prefix.getOperator());
                                        behaviour.setStoichiometry((int)prefix.getStoichometry());
                                        break block8;
                                    }
                                    if (!(prefix instanceof TransportData)) break block9;
                                    td = (TransportData)prefix;
                                    if (!compartmentName.equals(td.getSourceLocation())) break block10;
                                    behaviour = new SBAComponentBehaviour(name, compartmentName, SBAComponentBehaviour.Type.REACTANT);
                                    break block11;
                                }
                                if (!compartmentName.equals(td.getTargetLocation())) break block7;
                                behaviour = new SBAComponentBehaviour(name, td.getTargetLocation(), SBAComponentBehaviour.Type.PRODUCT);
                            }
                            if (td.getOperator().equals((Object)PrefixData.Operator.BI_TRANSPORTATION)) {
                                reaction.reversible = true;
                            }
                            reaction.transportation = td;
                            break block8;
                        }
                        throw new IllegalArgumentException("Unrecognised subclass of PrefixData.");
                    }
                    reaction.addComponent(behaviour);
                    this.recordReaction(reaction);
                }
                ++n2;
            }
        }

        private final void recordReaction(SBAReaction reaction) {
            if (this.currentReactions.containsKey(reaction.name)) {
                this.currentReactions.get(reaction.name).add(reaction);
            } else {
                this.newList = new LinkedList<SBAReaction>();
                this.newList.add(reaction);
                this.currentReactions.put(reaction.name, this.newList);
            }
        }

        void visit(CooperationNode node) {
            this.visit(node.getLeft());
            Map<String, List<SBAReaction>> left = this.currentReactions;
            this.currentReactions = new HashMap<String, List<SBAReaction>>();
            this.visit(node.getRight());
            this.actions.clear();
            String[] stringArray = node.getActions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.actions.add(s);
                ++n2;
            }
            for (Map.Entry<String, List<SBAReaction>> me : this.currentReactions.entrySet()) {
                String action = me.getKey();
                if (this.actions.contains(action)) {
                    this.newList = new LinkedList<SBAReaction>();
                    for (SBAReaction one : left.get(action)) {
                        for (SBAReaction two : me.getValue()) {
                            this.newList.add(SBAReaction.merge(one, two));
                        }
                    }
                    left.put(action, this.newList);
                    continue;
                }
                if (left.containsKey(action)) {
                    left.get(action).addAll((Collection<SBAReaction>)me.getValue());
                    continue;
                }
                left.put(action, me.getValue());
            }
            this.currentReactions = left;
        }

        void visit(SystemEquationNode node) {
            if (node instanceof ComponentNode) {
                this.visit((ComponentNode)node);
            } else if (node instanceof CooperationNode) {
                this.visit((CooperationNode)node);
            } else {
                throw new IllegalArgumentException("Unrecognised subclass of SystemEquationNode.");
            }
        }

        private class FunctionChecker
        extends CompiledExpressionVisitor {
            private FunctionChecker() {
            }

            public boolean visit(CompiledDynamicComponent component) {
                return false;
            }

            public boolean visit(CompiledFunction function) {
                switch (function.getFunction()) {
                    case H: 
                    case FLOOR: 
                    case CEILING: {
                        ((SystemEquationVisitor)SystemEquationVisitor.this).SBAModel.this.nonDifferentiableFunctions = true;
                    }
                }
                for (CompiledExpression ce : function.getArguments()) {
                    ce.accept(this);
                }
                return true;
            }

            public boolean visit(CompiledNumber number) {
                return true;
            }

            public boolean visit(CompiledOperatorNode operator) {
                operator.getLeft().accept(this);
                operator.getRight().accept(this);
                return true;
            }

            public boolean visit(CompiledSystemVariable variable) {
                switch (variable.getVariable()) {
                    case TIME: {
                        ((SystemEquationVisitor)SystemEquationVisitor.this).SBAModel.this.timeDependentRates = true;
                    }
                }
                return true;
            }
        }
    }
}

