/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.systemsbiology.math.Expression;
import org.systemsbiology.math.Symbol;
import org.systemsbiology.math.SymbolEvaluator;
import org.systemsbiology.util.DataNotFoundException;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;
import uk.ac.ed.inf.biopepa.core.sba.SBAComponentBehaviour;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulationTracer {
    private static String lineTerminator = System.getProperty("line.separator");
    private Random generator = new Random();

    private static void appendLine(StringBuilder sb, String s) {
        sb.append(s).append(lineTerminator);
    }

    public void outputComponentCounts(StringBuilder sb, HashMap<String, Integer> componentCounts) {
        SimulationTracer.appendLine(sb, " <!-- ");
        for (Map.Entry<String, Integer> entry : componentCounts.entrySet()) {
            SimulationTracer.appendLine(sb, "Component: " + entry.getKey() + " = " + entry.getValue());
        }
        SimulationTracer.appendLine(sb, " --> ");
    }

    void outputAssignment(StringBuilder sb, String procName, int count) {
        SimulationTracer.appendLine(sb, "<V id=\"" + procName + "\" val=\"" + count + "\" />");
    }

    private double expDelay(double mean) {
        return -mean * Math.log(this.generator.nextDouble());
    }

    public void generateSimulationTrace(StringBuilder sb, SBAModel model, String modelName, int numberOfFirings, double timeLimit, boolean displayComments, String modelComment) throws BioPEPAException, DataNotFoundException {
        String[] componentNames = model.getComponentNames();
        HashMap<String, Integer> componentCounts = new HashMap<String, Integer>();
        new MySymbolEvaluator(componentCounts);
        HashMap<String, String> compVarNames = new HashMap<String, String>();
        HashMap<String, String> compIdMap = new HashMap<String, String>();
        HashMap<String, Object> reactionIdMap = new HashMap<String, Object>();
        ComponentNode[] componentNodeArray = model.getComponents();
        int n = componentNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentNode cn = componentNodeArray[n2];
            Integer componentCount = 0;
            String componentName = cn.getName();
            componentCount = new Integer((int)cn.getCount());
            componentCounts.put(componentName, componentCount);
            ++n2;
        }
        SimulationTracer.appendLine(sb, "<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
        SimulationTracer.appendLine(sb, "<!-- Trace file of model " + modelName + " -->");
        SimulationTracer.appendLine(sb, "<Trace model=\"" + modelName + "\" generator=\"BioPEPA-Eclipse-Plugin\" >");
        SimulationTracer.appendLine(sb, "<Comment> " + modelComment + " </Comment>");
        SimulationTracer.appendLine(sb, "<!-- declaration of processes -->");
        SBAReaction[] reactions = model.getReactions();
        ExperimentSet experimentSet = new ExperimentSet();
        experimentSet.emptyExperimentLine("traviando-export");
        int i = 0;
        while (i < componentNames.length) {
            String procName = componentNames[i];
            SimulationTracer.appendLine(sb, "<Process id=\"" + i + "\" name=\"" + procName + "\" >");
            int index = 0;
            while (index < reactions.length) {
                SBAReaction reaction = reactions[index];
                boolean containsThis = false;
                boolean containsOther = false;
                for (SBAComponentBehaviour product : reaction.getProducts()) {
                    String pName = product.getName();
                    containsThis = containsThis || pName == procName;
                    boolean bl = containsOther = containsOther || pName != procName;
                }
                for (SBAComponentBehaviour reactant : reaction.getReactants()) {
                    boolean isThis = procName == reactant.getName();
                    containsThis = containsThis || isThis;
                    boolean bl = containsOther = containsOther || !isThis;
                }
                if (containsThis && !containsOther) {
                    Iterator<SBAComponentBehaviour> idName = "a_" + index;
                    String rName = reaction.getName();
                    SimulationTracer.appendLine(sb, "<Action id=\"" + idName + "\" name =\"" + rName + "\" />");
                    reactionIdMap.put(rName, idName);
                }
                ++index;
            }
            compIdMap.put(procName, Integer.toString(i));
            String popName = "pop_" + i;
            SimulationTracer.appendLine(sb, "<Var id = \"" + popName + "\" name=\"" + procName + "\" />");
            SimulationTracer.appendLine(sb, "</Process>");
            compVarNames.put(procName, popName);
            ++i;
        }
        SimulationTracer.appendLine(sb, "<Interactions>");
        int index = 0;
        while (index < reactions.length) {
            SBAReaction reaction = reactions[index];
            List<SBAComponentBehaviour> products = reaction.getProducts();
            List<SBAComponentBehaviour> reactants = reaction.getReactants();
            String reactionId = "sa_" + index;
            if (products.size() + reactants.size() > 1) {
                SimulationTracer.appendLine(sb, "<Undiraction id=\"" + reactionId + "\" name=\"" + reaction.getName() + "\" >");
                reactionIdMap.put(reaction.getName(), reactionId);
                for (SBAComponentBehaviour p : products) {
                    SimulationTracer.appendLine(sb, "<Touch>" + (String)compIdMap.get(p.getName()) + "</Touch>");
                }
                for (SBAComponentBehaviour r : reactants) {
                    SimulationTracer.appendLine(sb, "<Touch>" + (String)compIdMap.get(r.getName()) + "</Touch>");
                }
                SimulationTracer.appendLine(sb, "</Undiraction>");
            }
            ++index;
        }
        SimulationTracer.appendLine(sb, "</Interactions>");
        SimulationTracer.appendLine(sb, "<Sequence type=\"not-sure\">");
        SimulationTracer.appendLine(sb, "<S>");
        String[] stringArray = componentNames;
        int products = componentNames.length;
        int n3 = 0;
        while (n3 < products) {
            String compName = stringArray[n3];
            String compId = (String)compVarNames.get(compName);
            Number compCount = componentCounts.get(compName);
            this.outputAssignment(sb, compId, compCount.intValue());
            ++n3;
        }
        SimulationTracer.appendLine(sb, "</S>");
        double totalTime = 0.0;
        while (numberOfFirings-- > 0 && totalTime < timeLimit) {
            int newValue;
            Number current;
            double totalRate = 0.0;
            if (displayComments) {
                this.outputComponentCounts(sb, componentCounts);
            }
            SBAReaction[] idName = reactions;
            int n4 = reactions.length;
            int compId = 0;
            while (compId < n4) {
                double rateValue = 0.1;
                totalRate += rateValue;
                ++compId;
            }
            double passedProbability = 0.0;
            double picker = this.generator.nextDouble();
            SBAReaction chosen = null;
            SBAReaction[] sBAReactionArray = reactions;
            int n5 = reactions.length;
            int n6 = 0;
            while (n6 < n5) {
                double rateValue = 1.0;
                passedProbability += rateValue;
                ++n6;
            }
            if (chosen == null) {
                SimulationTracer.appendLine(sb, "<!-- No reaction chosen, must be in deadlocked state -->");
                break;
            }
            String rname = chosen.getName();
            double thisDelay = this.expDelay(1.0 / totalRate);
            SimulationTracer.appendLine(sb, "<A id=\"" + (String)reactionIdMap.get(rname) + "\" t=\"" + (totalTime += thisDelay) + "\"" + " i=\"" + rname + ".1\" >");
            for (SBAComponentBehaviour cb : chosen.getReactants()) {
                if (!cb.type.equals((Object)SBAComponentBehaviour.Type.REACTANT)) continue;
                String rName = cb.getName();
                current = componentCounts.get(rName);
                if (current == null) {
                    throw new BioPEPAException("reactant (" + rName + ") not in map");
                }
                newValue = current.intValue() - cb.getStoichiometry();
                componentCounts.put(rName, newValue);
                this.outputAssignment(sb, (String)compVarNames.get(rName), newValue);
            }
            for (SBAComponentBehaviour cb : chosen.getProducts()) {
                String pName = cb.getName();
                current = componentCounts.get(pName);
                if (current == null) {
                    throw new BioPEPAException("product (" + pName + ") not in map");
                }
                newValue = current.intValue() + cb.getStoichiometry();
                componentCounts.put(pName, newValue);
                this.outputAssignment(sb, (String)compVarNames.get(pName), newValue);
            }
            if (displayComments) {
                SimulationTracer.appendLine(sb, " <!-- This firing's delay is: " + thisDelay + " --> ");
                SimulationTracer.appendLine(sb, " <!-- The rate is: " + totalRate + " --> ");
                this.outputComponentCounts(sb, componentCounts);
            }
            SimulationTracer.appendLine(sb, "</A>");
        }
        SimulationTracer.appendLine(sb, "</Sequence>");
        SimulationTracer.appendLine(sb, "</Trace>");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MySymbolEvaluator
    extends SymbolEvaluator {
        private Map<String, Integer> componentCounts = null;

        public MySymbolEvaluator(Map<String, Integer> compCounts) {
            this.componentCounts = compCounts;
        }

        public Expression getExpressionValue(Symbol symbolName) throws DataNotFoundException {
            Number value = this.componentCounts.get(symbolName.getName());
            if (value == null) {
                throw new DataNotFoundException("Not found: " + symbolName.getName());
            }
            return new Expression(value.doubleValue());
        }

        public double getUnindexedValue(Symbol symbolName) throws DataNotFoundException {
            Integer value = this.componentCounts.get(symbolName.getName());
            if (value == null) {
                throw new DataNotFoundException("Not found: " + symbolName.getName());
            }
            return value.doubleValue();
        }

        public boolean hasValue(Symbol symbolName) {
            return this.componentCounts.containsKey(symbolName.getName());
        }
    }
}

