/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ed.inf.biopepa.core.interfaces.Solver;
import uk.ac.ed.inf.biopepa.core.sba.ISBJava;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solvers {
    private static List<Class<? extends Solver>> solverList = new ArrayList<Class<? extends Solver>>();
    private static List<String> shortNames = new ArrayList<String>();
    private static List<String> longNames = new ArrayList<String>();

    static {
        Solver solver = new ISBJava.Gillespie();
        Solvers.add(solver.getClass(), solver.getShortName(), solver.getDescriptiveName());
        solver = new ISBJava.GibsonBruck();
        Solvers.add(solver.getClass(), solver.getShortName(), solver.getDescriptiveName());
        solver = new ISBJava.TauLeap();
        Solvers.add(solver.getClass(), solver.getShortName(), solver.getDescriptiveName());
        solver = new ISBJava.DormandPrince();
        Solvers.add(solver.getClass(), solver.getShortName(), solver.getDescriptiveName());
        solver = new ISBJava.IMEX();
        Solvers.add(solver.getClass(), solver.getShortName(), solver.getDescriptiveName());
    }

    public static String[] getSolverList() {
        return longNames.toArray(new String[0]);
    }

    public static Solver getSolverInstance(String name) {
        if (name == null || name == "") {
            return null;
        }
        int i = longNames.indexOf(name);
        if (i == -1) {
            i = shortNames.indexOf(name);
        }
        if (i == -1) {
            return null;
        }
        try {
            return solverList.get(i).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void add(Class<? extends Solver> solver, String shortName, String longName) {
        if (solver == null || shortName == null || longName == null) {
            throw new NullPointerException();
        }
        if (shortName == "" || longName == "") {
            throw new IllegalArgumentException();
        }
        if (shortNames.contains(shortName) || longNames.contains(longName)) {
            throw new IllegalArgumentException();
        }
        solverList.add(solver);
        shortNames.add(shortName);
        longNames.add(longName);
    }
}

