/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba.export;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ed.inf.biopepa.core.interfaces.Exporter;
import uk.ac.ed.inf.biopepa.core.sba.export.SBMLExport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Exporters {
    private static List<Class<? extends Exporter>> exporterList = new ArrayList<Class<? extends Exporter>>();
    private static List<String> shortNames = new ArrayList<String>();
    private static List<String> longNames = new ArrayList<String>();

    static {
        SBMLExport sbmle = new SBMLExport();
        Exporters.add(SBMLExport.class, sbmle.getShortName(), sbmle.getLongName());
    }

    public static Exporter getSolverInstance(String name) {
        if (name == null || name == "") {
            return null;
        }
        int i = longNames.indexOf(name);
        if (i == -1) {
            i = shortNames.indexOf(name);
        }
        if (i == -1) {
            return null;
        }
        try {
            return exporterList.get(i).newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void add(Class<? extends Exporter> solver, String shortName, String longName) {
        if (solver == null || shortName == null || longName == null) {
            throw new NullPointerException();
        }
        if (shortName == "" || longName == "") {
            throw new IllegalArgumentException();
        }
        if (shortNames.contains(shortName) || longNames.contains(longName)) {
            throw new IllegalArgumentException();
        }
        exporterList.add(solver);
        shortNames.add(shortName);
        longNames.add(longName);
    }

    public static String[] getShortNames() {
        return shortNames.toArray(new String[0]);
    }

    public static String[] getLongNames() {
        return longNames.toArray(new String[0]);
    }
}

