/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba.export;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledDynamicComponent;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledOperatorNode;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledSystemVariable;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.VariableData;
import uk.ac.ed.inf.biopepa.core.interfaces.Exporter;
import uk.ac.ed.inf.biopepa.core.sba.SBAComponentBehaviour;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;
import uk.ac.ed.inf.biopepa.core.sba.StringConsumer;

public class PrismExport
implements Exporter {
    private SBAModel sbaModel = null;
    private ModelCompiler modelCompiler = null;
    private String modelName = "model";
    private int levelSize = 1;

    public String canExport() {
        return null;
    }

    public String getDescription() {
        return "Prism is a ctmc model checker";
    }

    public String getExportPrefix() {
        return "prism";
    }

    public String getLongName() {
        return "Prism";
    }

    public String getShortName() {
        return "prism";
    }

    public Object requiredDataStructure() {
        return null;
    }

    public void setModel(SBAModel model) throws UnsupportedOperationException {
        this.sbaModel = model;
    }

    public void setModel(ModelCompiler compiledModel) throws UnsupportedOperationException {
        this.modelCompiler = compiledModel;
    }

    public void setName(String modelName) {
        this.modelName = modelName;
    }

    public Object toDataStructure() throws UnsupportedOperationException {
        return null;
    }

    public void setLevelSize(int levelSize) {
        this.levelSize = levelSize;
    }

    private String prismRename(String comp) {
        return "_" + comp;
    }

    public void export(StringConsumer sb, StringConsumer ps) throws IOException {
        String name;
        SBAReaction[] reactions;
        SBAReaction[] name2;
        VariableData[] staticVars;
        sb.appendLine("// Prism model compiled from BioPEPA eclipse Plug-in");
        sb.appendLine("// The level size is: " + this.levelSize);
        Date date = new Date();
        sb.appendLine("// Compiled on: " + date.toString());
        sb.appendLine("");
        sb.appendLine("ctmc");
        sb.appendLine("");
        sb.appendLine("// Now we deal with the model's constant variables");
        sb.appendLine("");
        VariableData[] variableDataArray = staticVars = this.modelCompiler.getStaticVariables();
        int n = staticVars.length;
        int n2 = 0;
        while (n2 < n) {
            VariableData var = variableDataArray[n2];
            name2 = var.getName();
            String countS = var.getValue().toString();
            sb.appendLine("const double " + (String)name2 + " = " + countS + ";");
            ++n2;
        }
        sb.appendLine("");
        sb.appendLine("// Now we deal with the model's rates");
        sb.appendLine("");
        sb.appendLine("module Rates");
        sb.appendLine("");
        name2 = reactions = this.sbaModel.getReactions();
        int n3 = reactions.length;
        n = 0;
        while (n < n3) {
            SBAReaction reaction = name2[n];
            String name3 = this.prismRename(reaction.getName());
            PrismRateVisitor prv = new PrismRateVisitor(reaction);
            reaction.getRate().accept(prv);
            String rate = prv.getValue();
            String normRate = "(" + rate + " ) / LEVELSIZE";
            sb.append("[");
            sb.append(name3);
            sb.append("] ((");
            sb.append(rate);
            sb.append(") > 0 ) -> (");
            sb.append(normRate);
            sb.append(") : true;");
            sb.endLine();
            ++n;
        }
        sb.appendLine("");
        sb.appendLine("endmodule");
        ComponentNode[] components = this.sbaModel.getComponents();
        String[] componentNames = this.sbaModel.getComponentNames();
        String[] compCountStrings = new String[componentNames.length];
        int i = 0;
        while (i < componentNames.length) {
            compCountStrings[i] = Long.toString(components[i].getCount());
            ++i;
        }
        int largestStoichiometry = 1;
        Object[] objectArray = reactions;
        int n4 = reactions.length;
        int prv = 0;
        while (prv < n4) {
            SBAReaction reaction = objectArray[prv];
            for (SBAComponentBehaviour product : reaction.getProducts()) {
                int current = product.getStoichiometry();
                largestStoichiometry = Math.max(largestStoichiometry, current);
            }
            ++prv;
        }
        sb.appendLine("");
        sb.appendLine("// maximum of concentrations");
        sb.append("// Species: ");
        this.separateString(componentNames, ", ", sb);
        sb.endLine();
        sb.append("const int MAX = ");
        if (largestStoichiometry == 1) {
            this.separateString(compCountStrings, " + ", sb);
        } else {
            sb.append("(");
            this.separateString(compCountStrings, " + ", sb);
            sb.append(") * " + largestStoichiometry);
        }
        sb.append(";");
        sb.endLine();
        sb.append("const int LEVELSIZE = ");
        sb.append(Integer.toString(this.levelSize));
        sb.append(";");
        sb.endLine();
        objectArray = components;
        n4 = components.length;
        prv = 0;
        while (prv < n4) {
            Object component = objectArray[prv];
            String compName = ((ComponentNode)component).getName();
            String prismCompName = this.prismRename(compName);
            String countString = Long.toString(((ComponentNode)component).getCount());
            sb.appendLine("");
            sb.appendLine("module " + prismCompName);
            sb.appendLine("");
            sb.append(prismCompName);
            sb.append(" : [0..MAX] init ");
            sb.append(countString);
            sb.append(";");
            sb.endLine();
            SBAReaction[] sBAReactionArray = reactions;
            int n5 = reactions.length;
            int n6 = 0;
            while (n6 < n5) {
                String step;
                int stoichiom;
                SBAReaction reaction = sBAReactionArray[n6];
                List<SBAComponentBehaviour> products = reaction.getProducts();
                List<SBAComponentBehaviour> reactants = reaction.getReactants();
                for (SBAComponentBehaviour reactant : reactants) {
                    if (!compName.equals(reactant.getName()) || !reactant.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT)) continue;
                    stoichiom = reactant.getStoichiometry();
                    step = this.levelSize == 1 ? Integer.toString(stoichiom) : "(" + stoichiom + " * LEVELSIZE" + ")";
                    sb.append("[");
                    sb.append(this.prismRename(reaction.getName()));
                    sb.append("] (");
                    sb.append(prismCompName);
                    sb.append(" >= ");
                    sb.append(step);
                    sb.append(") -> ");
                    sb.append(" 1 ");
                    sb.append(" : (");
                    sb.append(prismCompName);
                    sb.append("' = ");
                    sb.append(prismCompName);
                    sb.append(" - ");
                    sb.append(step);
                    sb.append(");");
                    sb.endLine();
                }
                for (SBAComponentBehaviour product : products) {
                    if (!compName.equals(product.getName())) continue;
                    stoichiom = product.getStoichiometry();
                    step = this.levelSize == 1 ? Integer.toString(stoichiom) : "(" + stoichiom + " * LEVELSIZE" + ")";
                    sb.append("[");
                    sb.append(this.prismRename(reaction.getName()));
                    sb.append("] (");
                    sb.append(prismCompName);
                    sb.append(" + ");
                    sb.append(step);
                    sb.append(" <= MAX) -> ");
                    sb.append(step);
                    sb.append(" : (");
                    sb.append(prismCompName);
                    sb.append("' = ");
                    sb.append(prismCompName);
                    sb.append(" + ");
                    sb.append(step);
                    sb.append(");");
                    sb.endLine();
                }
                ++n6;
            }
            sb.appendLine("");
            sb.appendLine("endmodule");
            sb.appendLine("");
            ++prv;
        }
        int rewardsSoFar = 1;
        Object[] objectArray2 = componentNames;
        int n7 = componentNames.length;
        n4 = 0;
        while (n4 < n7) {
            String compName = objectArray2[n4];
            name = this.prismRename(compName);
            sb.append("// rewards: number of ");
            sb.append(name);
            sb.append(" molecules present");
            sb.endLine();
            sb.appendLine("// reward number " + rewardsSoFar);
            sb.append("rewards \"");
            sb.append(name);
            sb.append("\"");
            sb.endLine();
            sb.append("    true : ");
            sb.append(name);
            sb.append(";");
            sb.endLine();
            sb.appendLine("endrewards");
            ++rewardsSoFar;
            ++n4;
        }
        objectArray2 = componentNames;
        n7 = componentNames.length;
        n4 = 0;
        while (n4 < n7) {
            String compName = objectArray2[n4];
            name = this.prismRename(compName);
            sb.append("// rewards: square of number of ");
            sb.append(name);
            sb.append(" molecules present ");
            sb.endLine();
            sb.appendLine("// (used to calculate standard derivation)");
            sb.appendLine("// reward number " + rewardsSoFar);
            sb.append("rewards \"");
            sb.append(name);
            sb.append("_squared\"");
            sb.endLine();
            sb.append("    true : ");
            sb.append(name);
            sb.append(" * ");
            sb.append(name);
            sb.append(";");
            sb.endLine();
            sb.appendLine("endrewards");
            sb.appendLine("");
            ++rewardsSoFar;
            ++n4;
        }
        sb.appendLine("// The rewards now for the reactions");
        sb.appendLine("// we count both actual prism action firings (abstracted)");
        sb.appendLine("// and the number of simulated reactions (simulated)");
        sb.appendLine("// The abstracted will of course depend on the level size");
        sb.appendLine("// but the simulated should be the same regardless of the");
        sb.appendLine("// level size, obviously depending on how much the abstraction");
        sb.appendLine("// affects the model");
        objectArray2 = reactions;
        n7 = reactions.length;
        n4 = 0;
        while (n4 < n7) {
            Object reaction = objectArray2[n4];
            name = this.prismRename(((SBAReaction)reaction).getName());
            sb.appendLine("// count rewards for " + name + " - abstracted");
            sb.appendLine("// reward number " + rewardsSoFar);
            sb.append("rewards \"");
            sb.append(name);
            sb.append("\"");
            sb.endLine();
            sb.append("[");
            sb.append(name);
            sb.append("] true : 1;");
            sb.endLine();
            sb.appendLine("endrewards");
            sb.appendLine("");
            sb.appendLine("// count rewards for " + name + " - simulated");
            sb.appendLine("// reward number " + ++rewardsSoFar);
            sb.append("rewards \"");
            sb.append(name);
            sb.append("\"");
            sb.endLine();
            sb.append("[");
            sb.append(name);
            sb.append("] true : LEVELSIZE;");
            sb.endLine();
            sb.appendLine("endrewards");
            sb.appendLine("");
            ++rewardsSoFar;
            ++n4;
        }
        ps.appendLine("// Constants:");
        ps.appendLine("const double T; // time instant");
        ps.appendLine("const int i; // number of molecules");
        ps.appendLine("const int rew; // reward variable");
        ps.appendLine("// To use both of these select new experiment in xprism");
        ps.appendLine("// Range rew over the reward variables you wish to plot");
        ps.appendLine("// For a time series analysis use the top one");
        ps.appendLine("// For this model to plot all species range from 1 - " + componentNames.length);
        ps.appendLine("");
        ps.appendLine("// Expected value of model component rew at time T (1 - " + componentNames.length + ")");
        ps.appendLine("R{rew}=? [ I=T ]");
        ps.appendLine("");
        ps.appendLine("// Expected long-run value of model component rew?");
        ps.appendLine("R{rew}=? [ S ]");
        objectArray2 = componentNames;
        n7 = componentNames.length;
        n4 = 0;
        while (n4 < n7) {
            Object compName = objectArray2[n4];
            name = this.prismRename((String)compName);
            ps.appendLine("// Expected number of " + name + " molecules at time T?");
            ps.appendLine("R{\"" + name + "\"}=? [ I=T ]");
            ps.appendLine("// Expected long-run number of " + name + " molecules?");
            ps.appendLine("R{\"" + name + "\"}=? [ S ]");
            ps.appendLine("// Probability of there being i molecules of species " + name + " at time T?");
            ps.appendLine("P=? [ true U[T,T] " + name + "=i ]");
            ps.appendLine("// What is the probability of reaching the maximum number of molecules of species " + name + " at time T?");
            ps.appendLine("P=? [ true U[T,T] \"" + name + "_at_maximum\" ]");
            ps.appendLine("// What is the probability of having reached the maximum number of molecules of species " + name + " at time T or before?");
            ps.appendLine("P=? [ true U<=T \"" + name + "_at_maximum\" ]");
            ps.appendLine("// Stability of species " + name + " in the steady-state?");
            ps.appendLine("S=? [(" + name + " >= (i - 1)) & (" + name + " <= (i + 1)) ]");
            ps.appendLine("// Is species " + name + " depleted?");
            ps.appendLine("label \"" + name + "_depleted\" = " + name + " = 0;");
            ps.appendLine("// Is species " + name + " at its maximum value?");
            ps.appendLine("label \"" + name + "_at_maximum\" = " + name + " = MAX;");
            ++n4;
        }
    }

    private void separateString(String[] names, String sep, StringConsumer sb) throws IOException {
        int size = names.length;
        if (size == 0) {
            return;
        }
        int index = 0;
        while (index < size - 1) {
            sb.append(names[index]);
            sb.append(sep);
            ++index;
        }
        sb.append(names[size - 1]);
    }

    private class PrismRateVisitor
    extends CompiledExpressionVisitor {
        private SBAReaction reaction;
        private String value;

        PrismRateVisitor(SBAReaction r) {
            this.reaction = r;
        }

        public String getValue() {
            return this.value;
        }

        public boolean visit(CompiledDynamicComponent component) {
            this.value = PrismExport.this.prismRename(component.getName());
            return false;
        }

        public boolean visit(CompiledFunction function) {
            if (function.getFunction().isRateLaw()) {
                switch (function.getFunction()) {
                    case fMA: {
                        function.getArguments().get(0).accept(this);
                        List<SBAComponentBehaviour> reactants = this.reaction.getReactants();
                        for (SBAComponentBehaviour reactant : reactants) {
                            String name = PrismExport.this.prismRename(reactant.getName());
                            int stoich = reactant.getStoichiometry();
                            String thisExpr = stoich != 1 ? "pow(" + name + ", " + stoich + ")" : "( " + name + " )";
                            this.value = String.valueOf(this.value) + " * " + thisExpr;
                        }
                        break;
                    }
                    case fMM: {
                        function.getArguments().get(0).accept(this);
                        String arg1 = this.value;
                        function.getArguments().get(1).accept(this);
                        String arg2 = this.value;
                        String substrate = null;
                        String enzyme = null;
                        for (SBAComponentBehaviour cb : this.reaction.getReactants()) {
                            if (cb.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT)) {
                                substrate = PrismExport.this.prismRename(cb.getName());
                            }
                            enzyme = PrismExport.this.prismRename(cb.getName());
                            if (cb.getStoichiometry() == 1) continue;
                            throw new IllegalStateException();
                        }
                        String numerator = "( " + arg1 + " * " + substrate + " * " + enzyme + " )";
                        String denominator = "( " + arg2 + " + " + substrate + ")";
                        this.value = "( " + numerator + " / " + denominator + ")";
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return false;
            }
            if (function.getFunction().args() == 1) {
                function.getArguments().get(0).accept(this);
                String argument = this.value;
                switch (function.getFunction()) {
                    case LOG: {
                        this.value = "log(" + argument + ", 2.71828183)";
                        break;
                    }
                    case EXP: {
                        this.value = "pow(2.71828183, " + argument + ")";
                        break;
                    }
                    case FLOOR: {
                        this.value = "floor(" + argument + ")";
                        break;
                    }
                    case CEILING: {
                        this.value = "ceil(" + argument + ")";
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            throw new IllegalStateException();
        }

        public boolean visit(CompiledNumber number) {
            this.value = number.toString();
            return false;
        }

        public boolean visit(CompiledOperatorNode operator) {
            operator.getLeft().accept(this);
            String left = this.value;
            operator.getRight().accept(this);
            String right = this.value;
            switch (operator.getOperator()) {
                case PLUS: {
                    this.value = this.infixOperatorString(left, "+", right);
                    break;
                }
                case MINUS: {
                    this.value = this.infixOperatorString(left, "-", right);
                    break;
                }
                case DIVIDE: {
                    this.value = this.infixOperatorString(left, "/", right);
                    break;
                }
                case MULTIPLY: {
                    this.value = this.infixOperatorString(left, "*", right);
                    break;
                }
                case POWER: {
                    this.value = "pow(" + left + ", " + right + ")";
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return false;
        }

        private String infixOperatorString(String left, String oper, String right) {
            String result = "(" + left + ")" + oper + "(" + right + ")";
            return result;
        }

        public boolean visit(CompiledSystemVariable variable) {
            throw new IllegalStateException();
        }
    }
}

