/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba.export;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import uk.ac.ed.inf.biopepa.core.compiler.CompartmentData;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledDynamicComponent;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledOperatorNode;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledSystemVariable;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.interfaces.Exporter;
import uk.ac.ed.inf.biopepa.core.sba.SBAComponentBehaviour;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBMLExport
implements Exporter {
    public static final String sbmlOpeningMathElement = "<math xmlns=\"http://www.w3.org/1998/Math/MathML\">";
    public static final String sbmlClosingMathElement = "</math>";
    public static final String xmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String sbmlHeader = "<sbml xmlns=\"http://www.sbml.org/sbml/level2/version3\" level=\"2\" version=\"3\">";
    public static final String sbmlTimeSymbol = "<csymbol encoding=\"text\" definitionURL=\"http://www.sbml.org/sbml/symbols/time\"> t </csymbol>";
    private static String term = System.getProperty("line.separator");
    private SBAModel model;
    private String name = null;
    private boolean fMM;
    private boolean H;
    private static final String description;
    private StringBuilder sbml;
    private StringBuilder parameters;
    private StringBuilder initialAssignment;
    private StringBuilder reactions;
    private StringBuilder rules;
    private int parameterIndendation;
    private int assignmentIndentation;
    private int rulesIndentation;
    private Set<String> recordedVariables = new HashSet<String>();
    private Map<String, String> sbmlMap = new HashMap<String, String>();

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("Systems Biology Markup Language Level 2 Version 3.").append(term);
        sb.append("The Systems Biology Markup Language (SBML) is a computer-readable format for representing models of biological processes. It's applicable to simulations of metabolism, cell-signaling, and many other topics.").append(term);
        sb.append(term).append(xmlHeader).append(term);
        sb.append(sbmlHeader).append(term);
        sb.append("\t<model id=\"...\"").append(term);
        sb.append("\t\t...").append(term);
        sb.append("\t</model>").append(term);
        sb.append("</sbml>");
        description = sb.toString();
    }

    SBMLExport() {
    }

    @Override
    public void setModel(SBAModel model) {
        if (model == null) {
            throw new NullPointerException("SBA model must be non-null");
        }
        if (this.model != null) {
            throw new IllegalStateException("Model has already been set.");
        }
        this.model = model;
    }

    @Override
    public void setName(String modelName) {
        this.name = modelName;
    }

    @Override
    public String toString() {
        String fString;
        String s;
        if (this.model == null) {
            throw new IllegalStateException("Model has not been set using setModel/1");
        }
        this.sbml = new StringBuilder();
        this.parameters = new StringBuilder();
        this.initialAssignment = new StringBuilder();
        this.rules = new StringBuilder();
        this.reactions = new StringBuilder();
        this.sbmlMap.clear();
        this.recordedVariables.clear();
        HashMap<String, String> flattened = new HashMap<String, String>();
        HashSet<String> problemNames = new HashSet<String>();
        CompartmentData[] compartments = this.model.getCompartments();
        int i = 0;
        while (i < compartments.length) {
            s = compartments[i].getName();
            fString = SBMLExport.flattenName(s);
            if (flattened.containsKey(fString)) {
                problemNames.add(s);
            } else {
                flattened.put(fString, s);
            }
            ++i;
        }
        SBAReaction[] reactionsArray = this.model.getReactions();
        int i2 = 0;
        while (i2 < reactionsArray.length) {
            s = reactionsArray[i2].getName();
            fString = SBMLExport.flattenName(s);
            if (flattened.containsKey(fString)) {
                problemNames.add(s);
            } else {
                flattened.put(fString, s);
            }
            ++i2;
        }
        ComponentNode[] components = this.model.getComponents();
        int i3 = 0;
        while (i3 < components.length) {
            s = components[i3].getName();
            fString = SBMLExport.flattenName(s);
            if (flattened.containsKey(fString)) {
                problemNames.add(s);
            } else {
                flattened.put(fString, s);
            }
            ++i3;
        }
        for (Map.Entry me : flattened.entrySet()) {
            if (((String)me.getKey()).equals(me.getValue())) continue;
            this.sbmlMap.put((String)me.getValue(), (String)me.getKey());
        }
        this.mapNames(problemNames);
        this.sbml.append(xmlHeader).append(term);
        this.sbml.append(sbmlHeader).append(term);
        this.sbml.append("\t<model id=\"");
        if (this.name != null && !this.name.equals("")) {
            this.sbml.append(SBMLExport.flattenName(this.name));
        } else {
            this.sbml.append(SBMLExport.flattenName(Integer.toString(this.model.hashCode())));
        }
        this.sbml.append("\">").append(term);
        this.parameterIndendation = 3;
        this.assignmentIndentation = 3;
        this.rulesIndentation = 3;
        this.reactions.append("\t\t<listOfReactions>").append(term);
        Object[] objectArray = this.model.getReactions();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            SBAReaction rn = objectArray[n2];
            this.reactions.append(this.toSBML(rn, 3));
            ++n2;
        }
        this.reactions.append("\t\t</listOfReactions>").append(term);
        this.reactions.append("\t</model>").append(term);
        this.reactions.append("</sbml>");
        if (this.fMM || this.H) {
            this.sbml.append("\t\t<listOfFunctionDefinitions>").append(term);
            if (this.fMM) {
                this.sbml.append(this.sbmlFMM(3));
            }
            if (this.H) {
                this.sbml.append(this.sbmlH(3));
            }
            this.sbml.append("\t\t</listOfFunctionDefinitions>").append(term);
        }
        this.sbml.append("\t\t<listOfCompartmentTypes>").append(term);
        objectArray = CompartmentData.Type.values();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            SBAReaction type = objectArray[n2];
            this.sbml.append("\t\t\t").append(this.toSBML((CompartmentData.Type)((Object)type))).append(term);
            ++n2;
        }
        this.sbml.append("\t\t</listOfCompartmentTypes>").append(term);
        this.sbml.append("\t\t<listOfCompartments>").append(term);
        if (compartments.length > 0) {
            i = 0;
            while (i < compartments.length) {
                this.sbml.append("\t\t\t");
                this.sbml.append(this.toSBML(compartments[i]));
                this.sbml.append(term);
                ++i;
            }
        } else {
            this.sbml.append("\t\t\t<compartment id=\"main\" size=\"1.0\"/>").append(term);
        }
        this.sbml.append("\t\t</listOfCompartments>").append(term);
        this.sbml.append("\t\t<listOfSpecies>").append(term);
        i = 0;
        while (i < components.length) {
            this.sbml.append("\t\t\t").append(this.toSBML(components[i])).append(term);
            ++i;
        }
        this.sbml.append("\t\t</listOfSpecies>").append(term);
        if (this.parameters.length() > 0) {
            this.sbml.append("\t\t<listOfParameters>").append(term);
            this.sbml.append((CharSequence)this.parameters);
            this.sbml.append("\t\t</listOfParameters>").append(term);
        }
        if (this.initialAssignment.length() > 0) {
            this.sbml.append("\t\t<listOfInitialAssignments>").append(term);
            this.sbml.append((CharSequence)this.initialAssignment);
            this.sbml.append("\t\t</listOfInitialAssignments>").append(term);
        }
        if (this.rules.length() > 0) {
            this.sbml.append("\t\t<listOfRules>").append(term);
            this.sbml.append((CharSequence)this.rules);
            this.sbml.append("\t\t</listOfRules>").append(term);
        }
        this.sbml.append((CharSequence)this.reactions);
        return this.sbml.toString();
    }

    private void mapNames(Set<String> names) {
        HashSet<String> currentlyUsed = new HashSet<String>();
        currentlyUsed.addAll(this.sbmlMap.values());
        for (String next : names) {
            String s = SBMLExport.flattenName(next);
            ArrayList<Integer> numbers = new ArrayList<Integer>();
            Pattern p = Pattern.compile(String.valueOf(s) + "_\\d+");
            for (String existing : currentlyUsed) {
                if (!p.matcher(existing).matches()) continue;
                numbers.add(new Integer(existing.substring(s.length() + 1)));
            }
            if (numbers.size() > 0) {
                int[] intArray = new int[numbers.size()];
                int i = 0;
                while (i < intArray.length) {
                    intArray[i] = (Integer)numbers.get(i);
                    ++i;
                }
                Arrays.sort(intArray);
                s = String.valueOf(s) + "_" + (intArray[intArray.length - 1] + 1);
            } else {
                s = String.valueOf(s) + "_2";
            }
            currentlyUsed.add(s);
            this.sbmlMap.put(next, s);
        }
    }

    @Override
    public Object toDataStructure() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private String sbmlFMM(int indentation) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indentation) {
            sb.append("\t");
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuilder();
        sb.append(indent).append("<functionDefinition id=\"fMM\">").append(term);
        sb.append(indent).append("\t").append(sbmlOpeningMathElement).append(term);
        sb.append(indent).append("\t\t").append("<lambda>").append(term);
        sb.append(indent).append("\t\t\t").append("<bvar><ci> v_M </ci></bvar>").append(term);
        sb.append(indent).append("\t\t\t").append("<bvar><ci> K_M </ci></bvar>").append(term);
        sb.append(indent).append("\t\t\t").append("<bvar><ci> S </ci></bvar>").append(term);
        sb.append(indent).append("\t\t\t").append("<bvar><ci> E </ci></bvar>").append(term);
        sb.append(indent).append("\t\t\t").append("<apply>").append(term);
        sb.append(indent).append("\t\t\t\t").append("<divide/>").append(term);
        sb.append(indent).append("\t\t\t\t").append("<apply>").append(term);
        sb.append(indent).append("\t\t\t\t\t").append("<times/>").append(term);
        sb.append(indent).append("\t\t\t\t\t").append("<ci> v_M </ci>").append(term);
        sb.append(indent).append("\t\t\t\t\t").append("<ci> S </ci>").append(term);
        sb.append(indent).append("\t\t\t\t\t").append("<ci> E </ci>").append(term);
        sb.append(indent).append("\t\t\t\t").append("</apply>").append(term);
        sb.append(indent).append("\t\t\t\t").append("<apply>").append(term);
        sb.append(indent).append("\t\t\t\t\t").append("<plus/>").append(term);
        sb.append(indent).append("\t\t\t\t\t").append("<ci> K_M </ci>").append(term);
        sb.append(indent).append("\t\t\t\t\t").append("<ci> S </ci>").append(term);
        sb.append(indent).append("\t\t\t\t").append("</apply>").append(term);
        sb.append(indent).append("\t\t\t").append("</apply>").append(term);
        sb.append(indent).append("\t\t").append("</lambda>").append("").append(term);
        sb.append(indent).append("\t").append(sbmlClosingMathElement).append("").append(term);
        sb.append(indent).append("</functionDefinition>").append(term);
        return sb.toString();
    }

    private String sbmlH(int indentation) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indentation) {
            sb.append("\t");
            ++i;
        }
        String indent = sb.toString();
        sb = new StringBuilder();
        sb.append(indent).append("<functionDefinition id=\"H\">").append(term);
        sb.append(indent).append("\t").append(sbmlOpeningMathElement).append(term);
        sb.append(indent).append("\t\t").append("<lambda>").append(term);
        sb.append(indent).append("\t\t\t").append("<bvar><ci> X </ci></bvar>").append(term);
        sb.append(indent).append("\t\t\t\t").append("<piecewise>").append(term);
        sb.append(indent).append("\t\t\t\t\t").append("<piece>").append(term);
        sb.append(indent).append("\t\t\t\t\t\t").append("<cn> 1 </cn>").append(term);
        sb.append(indent).append("\t\t\t\t\t\t").append("<apply>").append(term);
        sb.append(indent).append("\t\t\t\t\t\t\t").append("<gt/>").append(term);
        sb.append(indent).append("\t\t\t\t\t\t\t").append("<ci> X </ci>").append(term);
        sb.append(indent).append("\t\t\t\t\t\t\t").append("<cn> 0 </cn>").append(term);
        sb.append(indent).append("\t\t\t\t\t\t").append("</apply>").append(term);
        sb.append(indent).append("\t\t\t\t\t").append("</piece>").append(term);
        sb.append(indent).append("\t\t\t\t\t").append("<otherwise>").append(term);
        sb.append(indent).append("\t\t\t\t\t\t").append("<cn> 0 </cn>").append(term);
        sb.append(indent).append("\t\t\t\t\t").append("</otherwise>").append(term);
        sb.append(indent).append("\t\t\t\t").append("</piecewise>").append(term);
        sb.append(indent).append("\t\t").append("</lambda>").append("").append(term);
        sb.append(indent).append("\t").append(sbmlClosingMathElement).append("").append(term);
        sb.append(indent).append("</functionDefinition>").append(term);
        return sb.toString();
    }

    private String toSBML(CompartmentData.Type type) {
        return "<compartmentType id=\"" + type.toString() + "\"/>";
    }

    private String toSBML(CompartmentData data) {
        StringBuilder sb = new StringBuilder();
        sb.append("<compartment id=\"").append(data.getName()).append("\"");
        sb.append(" compartmentType=\"").append(data.getType().toString()).append("\"");
        if (data.getType().getDimensions() != 3) {
            sb.append(" spatialDimensions=\"").append(data.getType().getDimensions()).append("\"");
        }
        sb.append(" size=\"").append(data.getVolume()).append("\"");
        if (data.getParent() != null) {
            sb.append(" outside=\"").append(data.getParent()).append("\"");
        }
        sb.append("/>");
        return sb.toString();
    }

    private String toSBML(ComponentNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append("<species id=\"");
        if (!this.sbmlMap.containsKey(node.getName())) {
            sb.append(node.getName()).append("\"");
        } else {
            sb.append(this.sbmlMap.get(node.getName())).append("\"");
            sb.append(" name=\"").append(node.getComponent()).append("\"");
        }
        sb.append(" compartment=\"").append(node.getCompartment() == null ? "main" : node.getCompartment().getName()).append("\"");
        sb.append(" initialAmount=\"").append(node.getCount()).append("\"");
        sb.append(" substanceUnits=\"item\" hasOnlySubstanceUnits=\"true\"");
        sb.append("/>");
        return sb.toString();
    }

    private String toSBML(SBAReaction reaction, int indentation) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indentation) {
            sb.append("\t");
            ++i;
        }
        String tabs = sb.toString();
        sb = new StringBuilder();
        sb.append(tabs).append("<reaction id=\"");
        String name = reaction.getName();
        if (this.sbmlMap.containsKey(name)) {
            sb.append(this.sbmlMap.get(name)).append("\" name=\"").append(name);
        } else {
            sb.append(name);
        }
        sb.append("\" reversible=\"false\">").append(term);
        List<SBAComponentBehaviour> list = reaction.getReactants();
        for (SBAComponentBehaviour outerCB : list) {
            if (!outerCB.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT)) continue;
            sb.append(tabs).append("\t<listOfReactants>").append(term);
            for (SBAComponentBehaviour cb : list) {
                if (!cb.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT)) continue;
                sb.append(tabs).append("\t\t").append(this.toSBML(cb)).append(term);
            }
            sb.append(tabs).append("\t</listOfReactants>").append(term);
            break;
        }
        list = reaction.getProducts();
        if (list.size() > 0) {
            sb.append(tabs).append("\t<listOfProducts>").append(term);
            for (SBAComponentBehaviour cb : list) {
                sb.append(tabs).append("\t\t").append(this.toSBML(cb)).append(term);
            }
            sb.append(tabs).append("\t</listOfProducts>").append(term);
        }
        list = reaction.getReactants();
        for (SBAComponentBehaviour outerCB : list) {
            if (outerCB.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT)) continue;
            sb.append(tabs).append("\t<listOfModifiers>").append(term);
            for (SBAComponentBehaviour cb : list) {
                if (cb.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT)) continue;
                sb.append(tabs).append("\t\t").append(this.toSBML(cb)).append(term);
            }
            sb.append(tabs).append("\t</listOfModifiers>").append(term);
            break;
        }
        sb.append(tabs).append("\t<kineticLaw>").append(term);
        sb.append(tabs).append("\t\t").append(sbmlOpeningMathElement).append(term);
        SBMLRateGenerator sbmlRG = new SBMLRateGenerator(reaction, indentation + 3);
        sbmlRG.generate();
        sb.append(sbmlRG.toString());
        sb.append(tabs).append("\t\t").append(sbmlClosingMathElement).append(term);
        sb.append(tabs).append("\t</kineticLaw>").append(term);
        sb.append(tabs).append("</reaction>").append(term);
        return sb.toString();
    }

    private String toSBML(SBAComponentBehaviour component) {
        StringBuilder sb = new StringBuilder();
        SBAComponentBehaviour.Type type = component.getType();
        if (type.equals((Object)SBAComponentBehaviour.Type.CATALYST) || type.equals((Object)SBAComponentBehaviour.Type.INHIBITOR)) {
            sb.append("<modifierSpeciesReference");
        } else {
            sb.append("<speciesReference");
        }
        sb.append(" species=\"");
        String name = component.getName();
        if (this.sbmlMap.containsKey(name)) {
            sb.append(this.sbmlMap.get(name));
        } else {
            sb.append(name);
        }
        sb.append("\"");
        if (component.getStoichiometry() != 1) {
            sb.append(" stoichiometry=\"").append(component.getStoichiometry()).append("\"");
        }
        sb.append("/>");
        return sb.toString();
    }

    private void addParameter(String name, String value, boolean dynamic) {
        String sName;
        if (!name.equals(SBMLExport.flattenName(name))) {
            HashSet<String> set = new HashSet<String>();
            set.add(name);
            this.mapNames(set);
            sName = this.sbmlMap.get(name);
        } else {
            sName = name;
        }
        int i = 0;
        while (i < this.parameterIndendation) {
            this.parameters.append("\t");
            ++i;
        }
        this.parameters.append("<parameter id=\"").append(sName);
        this.parameters.append("\" value=\"").append(value).append("\"");
        if (dynamic) {
            this.parameters.append(" constant=\"false\"");
        }
        this.parameters.append("/>").append(term);
    }

    private void addInitialAssignment(String name, String expression) {
        String sName;
        if (!name.equals(SBMLExport.flattenName(name))) {
            HashSet<String> set = new HashSet<String>();
            set.add(name);
            this.mapNames(set);
            sName = this.sbmlMap.get(name);
        } else {
            sName = name;
        }
        StringBuilder indent = new StringBuilder();
        int i = 0;
        while (i < this.assignmentIndentation) {
            indent.append("\t");
            ++i;
        }
        this.initialAssignment.append((CharSequence)indent).append("<initialAssignment symbol=\"");
        this.initialAssignment.append(sName).append("\">").append(term);
        this.initialAssignment.append((CharSequence)indent).append("\t").append(sbmlOpeningMathElement).append(term);
        this.initialAssignment.append(expression);
        this.initialAssignment.append((CharSequence)indent).append("\t").append(sbmlClosingMathElement).append(term);
        this.initialAssignment.append((CharSequence)indent).append("</initialAssignment>").append(term);
    }

    private void addDynamicVariableAssignment(String name, String expression) {
        String sName;
        if (!name.equals(SBMLExport.flattenName(name))) {
            HashSet<String> set = new HashSet<String>();
            set.add(name);
            this.mapNames(set);
            sName = this.sbmlMap.get(name);
        } else {
            sName = name;
        }
        StringBuilder indent = new StringBuilder();
        int i = 0;
        while (i < this.rulesIndentation) {
            indent.append("\t");
            ++i;
        }
        this.rules.append((CharSequence)indent).append("<assignmentRule variable=\"");
        this.rules.append(sName).append("\">").append(term);
        this.rules.append((CharSequence)indent).append("\t").append(sbmlOpeningMathElement).append(term);
        this.rules.append(expression);
        this.rules.append((CharSequence)indent).append("\t").append(sbmlClosingMathElement).append(term);
        this.rules.append((CharSequence)indent).append("</assignmentRule>").append(term);
    }

    public static String flattenName(String name) {
        char[] charArray = name.toCharArray();
        boolean prepend = !Character.isLetter(charArray[0]) && charArray[0] != '_';
        int i = 1;
        while (i < charArray.length) {
            if (!Character.isLetterOrDigit(charArray[i])) {
                charArray[i] = 95;
            }
            ++i;
        }
        return String.valueOf(prepend ? "_" : "") + new String(charArray);
    }

    @Override
    public String getExportPrefix() {
        return "xml";
    }

    @Override
    public void setModel(ModelCompiler compiledModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object requiredDataStructure() {
        return SBAModel.class;
    }

    @Override
    public String canExport() {
        if (this.model == null) {
            throw new IllegalStateException("Model has not been set using setModel/1");
        }
        SBMLParseable visitor = new SBMLParseable();
        SBAReaction[] sBAReactionArray = this.model.getReactions();
        int n = sBAReactionArray.length;
        int n2 = 0;
        while (n2 < n) {
            SBAReaction sbar = sBAReactionArray[n2];
            if (!sbar.getRate().accept(visitor)) {
                return visitor.response;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public String getLongName() {
        return "Systems Biology Markup Language";
    }

    @Override
    public String getShortName() {
        return "SBML";
    }

    private class ParameterVisitor
    extends CompiledExpressionVisitor {
        Number number = null;

        private ParameterVisitor() {
        }

        public boolean visit(CompiledDynamicComponent component) {
            return false;
        }

        public boolean visit(CompiledFunction function) {
            return false;
        }

        public boolean visit(CompiledNumber number) {
            this.number = number.getNumber();
            return !number.hasExpandedForm();
        }

        public boolean visit(CompiledOperatorNode operator) {
            return false;
        }

        public boolean visit(CompiledSystemVariable variable) {
            return false;
        }
    }

    private class SBMLParseable
    extends CompiledExpressionVisitor {
        String response = null;

        private SBMLParseable() {
        }

        public boolean visit(CompiledDynamicComponent component) {
            return true;
        }

        public boolean visit(CompiledFunction function) {
            switch (function.getFunction()) {
                case LOG: 
                case EXP: 
                case H: 
                case FLOOR: 
                case CEILING: 
                case fMA: 
                case fMM: 
                case TANH: {
                    break;
                }
                default: {
                    this.response = "Model uses the " + function.getFunction().toString() + " function, which is currently not supported in exporting to SBML.";
                    return false;
                }
            }
            for (CompiledExpression ce : function.getArguments()) {
                if (ce.accept(this)) continue;
                return false;
            }
            return true;
        }

        public boolean visit(CompiledNumber number) {
            return true;
        }

        public boolean visit(CompiledOperatorNode operator) {
            return operator.getLeft().accept(this) && operator.getRight().accept(this);
        }

        public boolean visit(CompiledSystemVariable variable) {
            switch (variable.getVariable()) {
                case TIME: {
                    return true;
                }
            }
            this.response = "Model uses the " + variable.toString() + " variable, which is currently not supported in exporting to SBML.";
            return false;
        }
    }

    private class SBMLRateGenerator
    extends CompiledExpressionVisitor {
        StringBuilder sb = new StringBuilder();
        int indentation = 0;
        CompiledOperatorNode.Operator lastOperator;
        SBAReaction reaction;

        private SBMLRateGenerator(int indentation) {
            this.indentation = indentation;
        }

        SBMLRateGenerator(SBAReaction reaction, int indentation) {
            this(indentation);
            this.reaction = reaction;
        }

        void generate() {
            this.reaction.getRate().accept(this);
        }

        public boolean visit(CompiledDynamicComponent component) {
            if (component.hasExpandedForm()) {
                return component.returnExpandedForm().accept(this);
            }
            String name = component.getName();
            if (!SBMLExport.this.recordedVariables.contains(name)) {
                SBMLExport.this.recordedVariables.add(name);
                CompiledExpression ce = SBMLExport.this.model.getStaticExpression(name);
                ParameterVisitor pv = new ParameterVisitor();
                if (ce != null && ce.accept(pv)) {
                    SBMLExport.this.addParameter(name, ce.toString(), false);
                } else if (ce == null) {
                    ce = SBMLExport.this.model.getDynamicExpression(name);
                    if (ce != null) {
                        SBMLExport.this.addParameter(name, pv.number != null ? pv.number.toString() : "1", true);
                        SBMLRateGenerator sbmlRG = new SBMLRateGenerator(SBMLExport.this.rulesIndentation + 2);
                        ce.accept(sbmlRG);
                        SBMLExport.this.addDynamicVariableAssignment(name, sbmlRG.toString());
                    }
                } else {
                    SBMLRateGenerator sbmlRG = new SBMLRateGenerator(SBMLExport.this.assignmentIndentation + 2);
                    SBMLExport.this.addParameter(name, pv.number != null ? pv.number.toString() : "1", false);
                    ce.accept(sbmlRG);
                    SBMLExport.this.addInitialAssignment(name, sbmlRG.toString());
                }
            }
            this.sb = new StringBuilder();
            this.indentation();
            this.sb.append("<ci> ");
            if (SBMLExport.this.sbmlMap.containsKey(component.getName())) {
                this.sb.append((String)SBMLExport.this.sbmlMap.get(component.getName()));
            } else {
                this.sb.append(component.getName());
            }
            this.sb.append(" </ci>").append(term);
            return true;
        }

        public boolean visit(CompiledFunction function) {
            boolean apply;
            if (function.hasExpandedForm()) {
                return function.returnExpandedForm().accept(this);
            }
            this.sb = new StringBuilder();
            CompiledFunction.Function f = function.getFunction();
            boolean bl = apply = !f.equals((Object)CompiledFunction.Function.fMA) || this.reaction.getReactants().size() != 0;
            if (apply) {
                this.indentation();
                this.sb.append("<apply>").append(term);
                ++this.indentation;
                this.indentation();
                switch (f) {
                    case LOG: {
                        this.sb.append("<ln/>").append(term);
                        break;
                    }
                    case EXP: {
                        this.sb.append("<exp/>").append(term);
                        break;
                    }
                    case CEILING: {
                        this.sb.append("<ceiling/>").append(term);
                        break;
                    }
                    case FLOOR: {
                        this.sb.append("<floor/>").append(term);
                        break;
                    }
                    case TANH: {
                        this.sb.append("<tanh/>").append(term);
                        break;
                    }
                    case H: {
                        this.sb.append("<ci> H </ci>").append(term);
                        SBMLExport.this.H = true;
                        break;
                    }
                    case fMA: {
                        this.sb.append("<times/>").append(term);
                        this.lastOperator = CompiledOperatorNode.Operator.MULTIPLY;
                        break;
                    }
                    case fMM: {
                        this.sb.append("<ci> fMM </ci>").append(term);
                        SBMLExport.this.fMM = true;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            StringBuilder fSB = new StringBuilder(this.sb.toString());
            for (CompiledExpression ce : function.getArguments()) {
                ce.accept(this);
                fSB.append(this.sb.toString());
            }
            this.sb = fSB;
            if (f.isRateLaw()) {
                switch (f) {
                    case fMA: {
                        String name;
                        for (SBAComponentBehaviour cb : this.reaction.getReactants()) {
                            name = cb.getName();
                            this.indentation();
                            this.sb.append("<ci> ");
                            if (SBMLExport.this.sbmlMap.containsKey(name)) {
                                this.sb.append((String)SBMLExport.this.sbmlMap.get(name));
                            } else {
                                this.sb.append(name);
                            }
                            this.sb.append(" </ci>").append(term);
                        }
                        break;
                    }
                    case fMM: {
                        String name;
                        SBAComponentBehaviour[] cbArray = new SBAComponentBehaviour[2];
                        for (SBAComponentBehaviour cb : this.reaction.getReactants()) {
                            if (cb.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT)) {
                                cbArray[0] = cb;
                                continue;
                            }
                            cbArray[1] = cb;
                        }
                        SBAComponentBehaviour[] sBAComponentBehaviourArray = cbArray;
                        int n = cbArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            SBAComponentBehaviour cb;
                            cb = sBAComponentBehaviourArray[n2];
                            name = cb.getName();
                            this.indentation();
                            this.sb.append("<ci> ");
                            if (SBMLExport.this.sbmlMap.containsKey(name)) {
                                this.sb.append((String)SBMLExport.this.sbmlMap.get(name));
                            } else {
                                this.sb.append(name);
                            }
                            this.sb.append(" </ci>").append(term);
                            ++n2;
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            if (apply) {
                --this.indentation;
                this.indentation();
                this.sb.append("</apply>").append(term);
            }
            return true;
        }

        public boolean visit(CompiledNumber number) {
            if (number.hasExpandedForm()) {
                return number.returnExpandedForm().accept(this);
            }
            this.sb = new StringBuilder();
            this.indentation();
            this.sb.append("<cn> ");
            this.sb.append(number.evaluatesToLong() ? (double)number.longValue() : number.doubleValue());
            this.sb.append(" </cn>").append(term);
            return true;
        }

        public boolean visit(CompiledOperatorNode operator) {
            boolean apply;
            if (operator.hasExpandedForm()) {
                return operator.returnExpandedForm().accept(this);
            }
            this.sb = new StringBuilder();
            CompiledOperatorNode.Operator previousOp = this.lastOperator;
            this.lastOperator = operator.getOperator();
            boolean bl = apply = !this.lastOperator.equals((Object)previousOp) || !previousOp.equals((Object)CompiledOperatorNode.Operator.MULTIPLY) && !previousOp.equals((Object)CompiledOperatorNode.Operator.PLUS);
            if (apply) {
                this.indentation();
                this.sb.append("<apply>").append(term);
                ++this.indentation;
                this.indentation();
                switch (this.lastOperator) {
                    case PLUS: {
                        this.sb.append("<plus/>").append(term);
                        break;
                    }
                    case MINUS: {
                        this.sb.append("<minus/>").append(term);
                        break;
                    }
                    case MULTIPLY: {
                        this.sb.append("<times/>").append(term);
                        break;
                    }
                    case DIVIDE: {
                        this.sb.append("<divide/>").append(term);
                        break;
                    }
                    case POWER: {
                        this.sb.append("<power/>").append(term);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            StringBuilder opSB = new StringBuilder(this.sb.toString());
            operator.getLeft().accept(this);
            opSB.append(this.sb.toString());
            operator.getRight().accept(this);
            opSB.append(this.sb.toString());
            this.sb = opSB;
            if (apply) {
                --this.indentation;
                this.indentation();
                this.sb.append("</apply>").append(term);
            }
            this.lastOperator = previousOp;
            return true;
        }

        public boolean visit(CompiledSystemVariable variable) {
            if (variable.hasExpandedForm()) {
                return variable.returnExpandedForm().accept(this);
            }
            this.sb = new StringBuilder();
            this.indentation();
            switch (variable.getVariable()) {
                case TIME: {
                    this.sb.append(SBMLExport.sbmlTimeSymbol).append(term);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return true;
        }

        private final void indentation() {
            int i = 0;
            while (i < this.indentation) {
                this.sb.append("\t");
                ++i;
            }
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

