/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.core.sba.export;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.systemsbiology.util.DataNotFoundException;
import uk.ac.ed.inf.biopepa.core.BioPEPAException;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledDynamicComponent;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpression;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledExpressionVisitor;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledFunction;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledNumber;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledOperatorNode;
import uk.ac.ed.inf.biopepa.core.compiler.CompiledSystemVariable;
import uk.ac.ed.inf.biopepa.core.compiler.ComponentNode;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;
import uk.ac.ed.inf.biopepa.core.sba.SBAComponentBehaviour;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.SBAReaction;

public class SimulationTracer {
    private int numberFiringsLimit = Integer.MAX_VALUE;
    private double timeLimit = Double.MAX_VALUE;
    private SBAModel sbaModel;
    private Random generator = new Random();
    private double dataPointStep = 1.0;
    private Result simulationResults;
    private double[] delays = new double[]{50.0, 50.0, 50.0};
    private ExperimentSet.ExperimentLine[] phaseLines;

    public SimulationTracer(SBAModel model) {
        this.sbaModel = model;
    }

    public void setTimeLimit(double newTimeLimit) {
        this.timeLimit = newTimeLimit;
    }

    public void setFiringsLimit(int newLimit) {
        this.numberFiringsLimit = newLimit;
    }

    private double expDelay(double mean) {
        return -mean * Math.log(this.generator.nextDouble());
    }

    public void setDataPointStep(double newDataPointStep) {
        this.dataPointStep = newDataPointStep;
    }

    public Result getSimulationResults() {
        return this.simulationResults;
    }

    public void setDelays(double[] delays) {
        this.delays = delays;
    }

    public void setPhaseLines(ExperimentSet.ExperimentLine[] phaseLines) {
        this.phaseLines = phaseLines;
    }

    public void generateSimulationTrace(SimulationTraceLog traceLog) throws BioPEPAException, DataNotFoundException, IOException {
        String[] componentNames = this.sbaModel.getComponentNames();
        HashMap<String, Integer> componentCounts = new HashMap<String, Integer>();
        ComponentNode[] componentNodeArray = this.sbaModel.getComponents();
        int n = componentNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentNode cn = componentNodeArray[n2];
            Integer componentCount = 0;
            String componentName = cn.getName();
            componentCount = new Integer((int)cn.getCount());
            componentCounts.put(componentName, componentCount);
            ++n2;
        }
        traceLog.traceLogHeader(componentCounts);
        SBAReaction[] sbaReactions = this.sbaModel.getReactions();
        TraceResults results = this.timeLimit == Double.MAX_VALUE ? new TraceResultsUnlimitedTime(componentNames, 0.0) : new TraceResultsFixedTime(componentNames, 0.0);
        double totalTime = 0.0;
        int numberOfFirings = this.numberFiringsLimit;
        int currentPhase = 0;
        if (this.delays == null || this.phaseLines == null) {
            this.delays = new double[1];
            this.delays[0] = this.timeLimit;
            ExperimentSet phaseSet = new ExperimentSet();
            ExperimentSet.ExperimentLine zeroPhase = phaseSet.emptyExperimentLine("zero-phase");
            this.phaseLines = new ExperimentSet.ExperimentLine[1];
            this.phaseLines[0] = zeroPhase;
        }
        double currentPhaseDelay = this.delays[currentPhase];
        ExperimentSet.ExperimentLine currentLine = this.phaseLines[currentPhase];
        while (numberOfFirings-- >= 0 && totalTime < this.timeLimit) {
            int newValue;
            Number current;
            double totalRate = 0.0;
            traceLog.displayComponentCounts(componentCounts);
            double[] reactionRates = new double[sbaReactions.length];
            int index = 0;
            while (index < sbaReactions.length) {
                double rateValue;
                SBAReaction reaction = sbaReactions[index];
                RateVisitor rateVisitor = new RateVisitor(totalTime, componentCounts, reaction, currentLine);
                reaction.getRate().accept(rateVisitor);
                reactionRates[index] = rateValue = rateVisitor.getValue();
                traceLog.displayEnabledReaction(reaction.getName(), rateValue);
                totalRate += rateValue;
                ++index;
            }
            double thisDelay = this.expDelay(1.0 / totalRate);
            if (totalRate <= 0.0) {
                traceLog.reportDeadlocked();
                results.completeDeadLock(componentCounts);
                break;
            }
            if (thisDelay > currentPhaseDelay) {
                totalTime += currentPhaseDelay;
                if (++currentPhase >= this.delays.length) {
                    currentPhase = 0;
                }
                currentPhaseDelay = this.delays[currentPhase];
                currentLine = this.phaseLines[currentPhase];
                results.updateResults(totalTime, componentCounts);
                continue;
            }
            totalTime += thisDelay;
            currentPhaseDelay -= thisDelay;
            double passedProbability = 0.0;
            double picker = this.generator.nextDouble();
            double chooser = totalRate * picker;
            SBAReaction chosen = null;
            int index2 = 0;
            while (index2 < sbaReactions.length) {
                SBAReaction reaction = sbaReactions[index2];
                double rateValue = reactionRates[index2];
                if (chooser < (passedProbability += rateValue)) {
                    chosen = reaction;
                    break;
                }
                ++index2;
            }
            if (chosen == null) {
                traceLog.reportDeadlocked();
                results.completeDeadLock(componentCounts);
                break;
            }
            String rname = chosen.getName();
            traceLog.startEvent(rname, totalTime);
            results.updateResults(totalTime, componentCounts);
            for (SBAComponentBehaviour cb : chosen.getReactants()) {
                if (!cb.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT)) continue;
                String rName = cb.getName();
                current = componentCounts.get(rName);
                if (current == null) {
                    throw new BioPEPAException("reactant (" + rName + ") not in map");
                }
                newValue = current.intValue() - cb.getStoichiometry();
                componentCounts.put(rName, newValue);
                traceLog.outputComponentUpdate(rName, newValue);
            }
            for (SBAComponentBehaviour cb : chosen.getProducts()) {
                String pName = cb.getName();
                current = componentCounts.get(pName);
                if (current == null) {
                    throw new BioPEPAException("product (" + pName + ") not in map");
                }
                newValue = current.intValue() + cb.getStoichiometry();
                componentCounts.put(pName, newValue);
                traceLog.outputComponentUpdate(pName, newValue);
            }
            traceLog.endEvent(thisDelay, totalRate, componentCounts);
        }
        this.simulationResults = results;
        traceLog.traceLogFooter();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NullTraceLog
    implements SimulationTraceLog {
        @Override
        public void displayComponentCounts(HashMap<String, Integer> componentCounts) throws IOException {
        }

        @Override
        public void displayEnabledReaction(String rName, double rValue) throws IOException {
        }

        @Override
        public void endEvent(double thisDelay, double totalRate, HashMap<String, Integer> componentCounts) throws IOException {
        }

        @Override
        public void outputComponentUpdate(String rName, int newValue) throws IOException {
        }

        @Override
        public void reportDeadlocked() throws IOException {
        }

        @Override
        public void startEvent(String rname, double totalTime) throws BioPEPAException, IOException {
        }

        @Override
        public void traceLogFooter() throws IOException {
        }

        @Override
        public void traceLogHeader(HashMap<String, Integer> componentCounts) throws IOException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RateVisitor
    extends CompiledExpressionVisitor {
        private double time;
        private Map<String, Integer> componentCounts;
        private double value;
        private SBAReaction reaction;
        private ExperimentSet.ExperimentLine experimentLine;

        RateVisitor(double time, Map<String, Integer> counts, SBAReaction r, ExperimentSet.ExperimentLine el) {
            this.componentCounts = counts;
            this.time = time;
            this.reaction = r;
            this.experimentLine = el;
        }

        public double getValue() {
            return this.value;
        }

        @Override
        public boolean visit(CompiledDynamicComponent component) {
            String name = component.getName();
            Integer count = this.componentCounts.get(name);
            if (count == null) {
                throw new IllegalStateException();
            }
            this.value = count.doubleValue();
            return false;
        }

        @Override
        public boolean visit(CompiledFunction function) {
            if (function.getFunction().isRateLaw()) {
                switch (function.getFunction()) {
                    case fMA: {
                        function.getArguments().get(0).accept(this);
                        List<SBAComponentBehaviour> reactants = this.reaction.getReactants();
                        for (SBAComponentBehaviour reactant : reactants) {
                            Integer count = this.componentCounts.get(reactant.getName());
                            double k = Math.pow(count.doubleValue(), reactant.getStoichiometry());
                            this.value *= k;
                        }
                        break;
                    }
                    case fMM: {
                        function.getArguments().get(0).accept(this);
                        double arg1 = this.value;
                        function.getArguments().get(1).accept(this);
                        double arg2 = this.value;
                        String substrate = null;
                        String enzyme = null;
                        for (SBAComponentBehaviour cb : this.reaction.getReactants()) {
                            if (cb.getType().equals((Object)SBAComponentBehaviour.Type.REACTANT)) {
                                substrate = cb.getName();
                            }
                            enzyme = cb.getName();
                            if (cb.getStoichiometry() == 1) continue;
                            throw new IllegalStateException();
                        }
                        Integer substrateCount = this.componentCounts.get(substrate);
                        Integer enzymeCount = this.componentCounts.get(enzyme);
                        double numerator = arg1 * substrateCount.doubleValue() * enzymeCount.doubleValue();
                        double denominator = arg2 * substrateCount.doubleValue();
                        this.value = numerator / denominator;
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return false;
            }
            if (function.getFunction().args() == 1) {
                function.getArguments().get(0).accept(this);
                double argument = this.value;
                switch (function.getFunction()) {
                    case LOG: {
                        this.value = Math.log(argument);
                        break;
                    }
                    case EXP: {
                        this.value = Math.exp(argument);
                        break;
                    }
                    case H: {
                        this.value = argument > 0.0 ? 1 : 0;
                        break;
                    }
                    case FLOOR: {
                        this.value = Math.floor(argument);
                        break;
                    }
                    case CEILING: {
                        this.value = Math.ceil(argument);
                        break;
                    }
                    case TANH: {
                        this.value = Math.tanh(argument);
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                return false;
            }
            return false;
        }

        @Override
        public boolean visit(CompiledNumber number) {
            if (!this.overrideRate(number)) {
                this.value = number.doubleValue();
            }
            return false;
        }

        private boolean overrideRate(CompiledExpression ce) {
            if (ce.hasExpandedForm() && ce.returnExpandedForm() instanceof CompiledDynamicComponent) {
                CompiledDynamicComponent cdc = (CompiledDynamicComponent)ce.returnExpandedForm();
                String cvName = cdc.getName();
                cvName = ce.returnExpandedForm().toString();
                Number expandedValue = this.experimentLine.getRateValue(cvName);
                if (expandedValue != null) {
                    this.value = expandedValue.doubleValue();
                    return true;
                }
                return false;
            }
            return false;
        }

        @Override
        public boolean visit(CompiledOperatorNode operator) {
            operator.getLeft().accept(this);
            double left = this.value;
            operator.getRight().accept(this);
            double right = this.value;
            switch (operator.getOperator()) {
                case PLUS: {
                    this.value = left + right;
                    break;
                }
                case MINUS: {
                    this.value = left - right;
                    break;
                }
                case DIVIDE: {
                    this.value = left / right;
                    break;
                }
                case MULTIPLY: {
                    this.value = left * right;
                    break;
                }
                case POWER: {
                    this.value = Math.pow(left, right);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return false;
        }

        @Override
        public boolean visit(CompiledSystemVariable variable) {
            switch (variable.getVariable()) {
                case TIME: {
                    this.value = this.time;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SimulationTraceLog {
        public void traceLogHeader(HashMap<String, Integer> var1) throws IOException;

        public void traceLogFooter() throws IOException;

        public void displayComponentCounts(HashMap<String, Integer> var1) throws IOException;

        public void displayEnabledReaction(String var1, double var2) throws IOException;

        public void startEvent(String var1, double var2) throws BioPEPAException, IOException;

        public void outputComponentUpdate(String var1, int var2) throws IOException;

        public void endEvent(double var1, double var3, HashMap<String, Integer> var5) throws IOException;

        public void reportDeadlocked() throws IOException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface TraceResults
    extends Result {
        public void updateResults(double var1, HashMap<String, Integer> var3);

        public void completeDeadLock(HashMap<String, Integer> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TraceResultsFixedTime
    implements TraceResults {
        private String[] componentNames;
        private double[][] results;
        private double[] timepoints;
        private int ourTimeIndex;

        TraceResultsFixedTime(String[] compNames, double startTime) {
            this.componentNames = compNames;
            int timepointsSize = 0;
            double fakeTime = startTime;
            while (fakeTime < SimulationTracer.this.timeLimit) {
                ++timepointsSize;
                fakeTime += SimulationTracer.this.dataPointStep;
            }
            this.timepoints = new double[timepointsSize];
            fakeTime = startTime;
            int index = 0;
            while (index < timepointsSize) {
                this.timepoints[index] = fakeTime;
                fakeTime += SimulationTracer.this.dataPointStep;
                ++index;
            }
            this.results = new double[this.componentNames.length][];
            int i = 0;
            while (i < this.componentNames.length) {
                this.results[i] = new double[timepointsSize];
                ++i;
            }
            this.ourTimeIndex = 0;
        }

        @Override
        public void updateResults(double newTotalTime, HashMap<String, Integer> componentCounts) {
            while (this.ourTimeIndex < this.timepoints.length && this.timepoints[this.ourTimeIndex] <= newTotalTime) {
                int index = 0;
                while (index < this.componentNames.length) {
                    double thisValue;
                    this.results[index][this.ourTimeIndex] = thisValue = componentCounts.get(this.componentNames[index]).doubleValue();
                    ++index;
                }
                ++this.ourTimeIndex;
            }
        }

        @Override
        public void completeDeadLock(HashMap<String, Integer> componentCounts) {
            this.updateResults(SimulationTracer.this.timeLimit, componentCounts);
        }

        @Override
        public String[] getActionNames() {
            return null;
        }

        @Override
        public double getActionThroughput(int index) {
            return 0.0;
        }

        @Override
        public String[] getComponentNames() {
            return this.componentNames;
        }

        @Override
        public Map<String, Number> getModelParameters() {
            return null;
        }

        @Override
        public double getPopulation(int index) {
            return 0.0;
        }

        @Override
        public String getSimulatorName() {
            return "Trace-simulation";
        }

        @Override
        public Map<String, Number> getSimulatorParameters() {
            return null;
        }

        @Override
        public double[] getTimePoints() {
            return this.timepoints;
        }

        @Override
        public double[] getTimeSeries(int index) {
            return this.results[index];
        }

        @Override
        public boolean throughputSupported() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TraceResultsUnlimitedTime
    implements TraceResults {
        private String[] componentNames;
        private LinkedList<Number>[] results;
        private LinkedList<Number> timepoints;
        private double ourTimeIndex;

        TraceResultsUnlimitedTime(String[] compNames, double startTime) {
            this.componentNames = compNames;
            this.timepoints = new LinkedList();
            this.results = new LinkedList[this.componentNames.length];
            int index = 0;
            while (index < this.componentNames.length) {
                this.results[index] = new LinkedList();
                ++index;
            }
        }

        @Override
        public void updateResults(double newTotalTime, HashMap<String, Integer> componentCounts) {
            while (this.ourTimeIndex <= newTotalTime) {
                this.timepoints.addLast(this.ourTimeIndex);
                int index = 0;
                while (index < this.componentNames.length) {
                    double thisValue = componentCounts.get(this.componentNames[index]).doubleValue();
                    this.results[index].addLast(thisValue);
                    ++index;
                }
                this.ourTimeIndex += SimulationTracer.this.dataPointStep;
            }
        }

        @Override
        public void completeDeadLock(HashMap<String, Integer> componentCounts) {
            this.updateResults(SimulationTracer.this.timeLimit, componentCounts);
        }

        @Override
        public String[] getActionNames() {
            return null;
        }

        @Override
        public double getActionThroughput(int index) {
            return 0.0;
        }

        @Override
        public String[] getComponentNames() {
            return this.componentNames;
        }

        @Override
        public Map<String, Number> getModelParameters() {
            return null;
        }

        @Override
        public double getPopulation(int index) {
            return 0.0;
        }

        @Override
        public String getSimulatorName() {
            return "Trace-simulation";
        }

        @Override
        public Map<String, Number> getSimulatorParameters() {
            return null;
        }

        private double[] convertLinkedList(LinkedList<Number> list) {
            double[] values = new double[list.size()];
            int index = 0;
            for (Number value : list) {
                values[index] = value.doubleValue();
                ++index;
            }
            return values;
        }

        @Override
        public double[] getTimePoints() {
            return this.convertLinkedList(this.timepoints);
        }

        @Override
        public double[] getTimeSeries(int index) {
            return this.convertLinkedList(this.results[index]);
        }

        @Override
        public boolean throughputSupported() {
            return false;
        }
    }
}

