/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.tests;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java_cup.runtime.Symbol;
import uk.ac.ed.inf.biopepa.core.compiler.ModelCompiler;
import uk.ac.ed.inf.biopepa.core.compiler.ProblemInfo;
import uk.ac.ed.inf.biopepa.core.dom.Model;
import uk.ac.ed.inf.biopepa.core.dom.internal.BioPEPALexer;
import uk.ac.ed.inf.biopepa.core.dom.internal.BioPEPAParser;
import uk.ac.ed.inf.biopepa.core.dom.internal.BioPEPASymbolFactory;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.interfaces.Solver;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;
import uk.ac.ed.inf.biopepa.core.sba.Parameters;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.Solvers;

public class Parser {
    public static void main(String[] args) throws Exception {
        String source = null;
        if (args.length == 0) {
            System.err.println("Please specify input file:");
            System.err.println(" java -jar biopepa.jar <filename.biopepa>");
            System.exit(1);
        } else {
            source = Parser.readFile(args[0]);
        }
        long tic = System.currentTimeMillis();
        Model model = Parser.parse(source);
        System.out.println("Preview of BioPEPA Compiler 0.0.1.v20080208");
        System.out.println("*******************************************\n");
        ModelCompiler c = new ModelCompiler(model);
        ProblemInfo[] problems = c.compile();
        long toc = System.currentTimeMillis();
        if (problems.length == 0) {
            System.out.println("Model accepted.");
            System.out.println("Elapsed time:" + (toc - tic) + " ms");
            SBAModel sba = new SBAModel(c);
            sba.parseBioPEPA();
            System.out.println(sba.toString());
            System.out.println("--------------------------------------------------------------------------------");
            Solver solver = Solvers.getSolverInstance("gillespie");
            Parameters parameters = solver.getRequiredParameters();
            parameters.setValue(Parameters.Parameter.Stop_Time, 20.0);
            parameters.setValue(Parameters.Parameter.Independent_Replications, 1000);
            parameters.setValue(Parameters.Parameter.Components, new String[]{"X", "Y", "Z"});
            ExperimentSet experSet = new ExperimentSet();
            ExperimentSet.ExperimentLine experLine = experSet.emptyExperimentLine("results");
            Result result = solver.startTimeSeriesAnalysis(sba, parameters, experLine, null);
            String[] components = result.getComponentNames();
            System.out.println("Final population levels");
            int i = 0;
            while (i < components.length) {
                System.out.println(String.valueOf(components[i]) + " = " + result.getPopulation(i));
                ++i;
            }
        } else {
            System.out.println("Compiler returned with the following warnings/errors:");
            System.out.println();
            ProblemInfo[] problemInfoArray = problems;
            int n = problems.length;
            int n2 = 0;
            while (n2 < n) {
                ProblemInfo p = problemInfoArray[n2];
                System.out.print(p.message);
                if (p.sourceRange == null) {
                    System.out.println(" [?]");
                } else {
                    System.out.println(" [" + p.sourceRange.getChar() + "]");
                }
                ++n2;
            }
        }
        System.exit(0);
    }

    private static String readFile(String location) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(location));
        StringBuffer buffer = new StringBuffer();
        String line = null;
        while ((line = r.readLine()) != null) {
            buffer.append(String.valueOf(line) + "\n");
        }
        return buffer.toString();
    }

    public static Model parse(String source) throws Exception {
        BioPEPASymbolFactory symbolFactory = new BioPEPASymbolFactory();
        BioPEPAParser parser = new BioPEPAParser(new BioPEPALexer(new StringReader(source), symbolFactory), symbolFactory);
        Symbol symbol = parser.parse();
        return (Model)symbol.value;
    }
}

