/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import uk.ac.ed.inf.biopepa.ui.BioPEPAPlugin;

public class ImageManager {
    private static ImageManager manager = null;
    private static final String ICON_PATH = "icons/";
    private ImageRegistry registry = BioPEPAPlugin.getDefault().getImageRegistry();

    private ImageManager() {
    }

    public static ImageManager getInstance() {
        if (manager == null) {
            manager = new ImageManager();
        }
        return manager;
    }

    public Image getImage(ICONS icon) {
        return this.getImageDescriptor(icon).createImage();
    }

    public ImageDescriptor getImageDescriptor(ICONS icon) {
        ImageDescriptor descriptor = this.registry.getDescriptor(icon.getFileName());
        if (descriptor == null) {
            descriptor = BioPEPAPlugin.getImageDescriptor(ICON_PATH + icon.getFileName());
            this.registry.put(icon.getFileName(), descriptor);
        }
        return descriptor;
    }

    public void dispose() {
        this.registry.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ICONS {
        CLEAR("clear.gif");

        String filename;

        private ICONS(String filename) {
            this.filename = filename;
        }

        String getFileName() {
            return this.filename;
        }
    }
}

