/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.export;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.dialogs.SaveAsDialog;
import uk.ac.ed.inf.biopepa.core.interfaces.Exporter;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;
import uk.ac.ed.inf.biopepa.ui.interfaces.IResourceProvider;
import uk.ac.ed.inf.biopepa.ui.wizards.export.ExportPage;

public class ExportWizard
extends Wizard
implements IResourceProvider {
    BioPEPAModel model;
    ExportPage exportPage;

    public ExportWizard(BioPEPAModel model) {
        if (model == null) {
            throw new NullPointerException("Error; model does not exist.");
        }
        this.model = model;
        this.setHelpAvailable(false);
        this.setWindowTitle("Export options for Bio-PEPA");
    }

    public boolean performFinish() {
        Exporter exporter = this.exportPage.getExporter();
        exporter.setName(this.model.getUnderlyingResource().getName());
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getShell());
        IPath path = this.model.getUnderlyingResource().getFullPath();
        path = path.removeFileExtension().addFileExtension(exporter.getExportPrefix());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        saveAsDialog.setOriginalFile(file);
        saveAsDialog.open();
        path = saveAsDialog.getResult();
        if (path == null) {
            return false;
        }
        path = path.removeFileExtension().addFileExtension(exporter.getExportPrefix());
        file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        String contents = null;
        try {
            contents = exporter.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        ByteArrayInputStream source = new ByteArrayInputStream(contents.getBytes());
        try {
            if (file.exists()) {
                file.setContents((InputStream)source, 0, null);
            } else {
                file.create((InputStream)source, 0, null);
            }
            file.refreshLocal(0, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void addPages() {
        this.exportPage = new ExportPage(this.model);
        this.addPage((IWizardPage)this.exportPage);
    }

    public IResource getUnderlyingResource() {
        return this.model.getUnderlyingResource();
    }
}

