/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.export;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;
import uk.ac.ed.inf.biopepa.core.sba.LineStringBuilder;
import uk.ac.ed.inf.biopepa.core.sba.StringConsumer;
import uk.ac.ed.inf.biopepa.core.sba.export.PrismExport;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;
import uk.ac.ed.inf.biopepa.ui.interfaces.IResourceProvider;

public class PrismExportWizard
extends Wizard
implements IResourceProvider {
    BioPEPAModel model;
    private ExportPage exportPage;

    public PrismExportWizard(BioPEPAModel model) {
        if (model == null) {
            throw new NullPointerException("Error; model does not exist.");
        }
        this.model = model;
        this.setHelpAvailable(false);
        this.setWindowTitle("Export options for Bio-PEPA");
    }

    public void addPages() {
        this.exportPage = new ExportPage("Export a Traviando Trace");
        this.addPage((IWizardPage)this.exportPage);
    }

    public boolean performFinish() {
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getShell());
        IPath path = this.model.getUnderlyingResource().getFullPath();
        path = path.removeFileExtension().addFileExtension("pm");
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        saveAsDialog.setOriginalFile(file);
        saveAsDialog.open();
        path = saveAsDialog.getResult();
        if (path == null) {
            return false;
        }
        path = path.removeFileExtension().addFileExtension("pm");
        file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        IPath propsPath = this.exportPage.getCSLPath();
        if (propsPath == null) {
            propsPath = path.removeFileExtension().addFileExtension("csl");
        }
        IFile propsFile = ResourcesPlugin.getWorkspace().getRoot().getFile(propsPath);
        LineStringBuilder prismLsb = new LineStringBuilder();
        LineStringBuilder propsLsb = new LineStringBuilder();
        try {
            int levelSize = this.exportPage.getLevelSize();
            PrismExport pexport = new PrismExport();
            pexport.setLevelSize(levelSize);
            pexport.setModel(this.model.getCompiledModel());
            pexport.setModel(this.model.getSBAModel());
            pexport.export((StringConsumer)prismLsb, (StringConsumer)propsLsb);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        byte[] prismBuf = prismLsb.toString().getBytes();
        ByteArrayInputStream prismSource = new ByteArrayInputStream(prismBuf);
        byte[] propsBuf = propsLsb.toString().getBytes();
        ByteArrayInputStream propsSource = new ByteArrayInputStream(propsBuf);
        try {
            if (file.exists()) {
                file.setContents((InputStream)prismSource, 0, null);
            } else {
                file.create((InputStream)prismSource, 0, null);
            }
            file.refreshLocal(0, null);
            if (this.exportPage.getOutputCsl()) {
                if (propsFile.exists()) {
                    propsFile.setContents((InputStream)propsSource, 0, null);
                } else {
                    propsFile.create((InputStream)propsSource, 0, null);
                }
                propsFile.refreshLocal(0, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public IResource getUnderlyingResource() {
        return this.model.getUnderlyingResource();
    }

    private class ExportPage
    extends WizardPage {
        private Text levelSizeText;
        private IPath cslPath;
        private Button setPropertiesFile;
        private Label cslFileLabel;
        private Button outputCslCheckButton;
        private ModifyListener modifyListener;
        private Listener commonListener;

        protected ExportPage(String pageName) {
            super(pageName);
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    ExportPage.this.validate();
                }
            };
            this.commonListener = new Listener(){

                public void handleEvent(Event event) {
                    ExportPage.this.validate();
                }
            };
            this.setTitle("Prism CTMC Export");
            this.setDescription("Translate the biopepa model into a Prism model");
            this.cslPath = null;
        }

        public IPath getCSLPath() {
            return this.cslPath;
        }

        public boolean getOutputCsl() {
            return this.outputCslCheckButton.getSelection();
        }

        public void createControl(Composite parent) {
            int textStyle = 133120;
            int labelStyle = 16388;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.setControl((Control)composite);
            Label tmpLabel = new Label(composite, labelStyle);
            tmpLabel.setText("Please set the level size for this translation");
            tmpLabel.setLayoutData((Object)this.createDefaultGridData());
            Composite labelsComposite = new Composite(composite, 0);
            GridLayout labelsCompLayout = new GridLayout(2, false);
            labelsComposite.setLayout((Layout)labelsCompLayout);
            Label levelsLabel = new Label(labelsComposite, labelStyle);
            levelsLabel.setText("Level size: (default 1)");
            this.levelSizeText = new Text(labelsComposite, textStyle);
            this.levelSizeText.setLayoutData((Object)this.newTextGridData());
            this.levelSizeText.setText("");
            this.levelSizeText.addModifyListener(this.modifyListener);
            this.setPropertiesFile = new Button(labelsComposite, 8);
            this.setPropertiesFile.setText("Set .csl");
            this.setPropertiesFile.setEnabled(true);
            class SetCSL
            implements SelectionListener {
                SetCSL() {
                }

                public void widgetSelected(SelectionEvent event) {
                    ExportPage.this.setCSLFile();
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }
            }
            this.setPropertiesFile.addSelectionListener((SelectionListener)new SetCSL());
            this.cslFileLabel = new Label(labelsComposite, labelStyle);
            this.cslFileLabel.setText("No file set");
            this.outputCslCheckButton = new Button(labelsComposite, 32);
            this.outputCslCheckButton.setText("Output csl properties file");
            this.outputCslCheckButton.setSelection(true);
            this.validate();
        }

        private GridData newTextGridData() {
            GridData textGridData = new GridData();
            textGridData.widthHint = 80;
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = true;
            return textGridData;
        }

        private void validate() {
            this.setPageComplete(false);
            this.setErrorMessage(null);
            String lText = this.levelSizeText.getText().trim();
            try {
                if (!lText.isEmpty()) {
                    Integer.parseInt(lText);
                }
            }
            catch (Exception exception) {
                this.setPageComplete(false);
                this.setErrorMessage("Cannot parse level size");
                return;
            }
            this.setPageComplete(true);
        }

        public int getLevelSize() {
            String text = this.levelSizeText.getText().trim();
            if (text.isEmpty()) {
                return 1;
            }
            try {
                return Integer.parseInt(text);
            }
            catch (Exception exception) {
                return 1;
            }
        }

        private GridData createDefaultGridData() {
            return new GridData(4, 0x1000000, true, false);
        }

        private boolean setCSLFile() {
            SaveAsDialog saveAsDialog = new SaveAsDialog(this.getShell());
            IPath path = PrismExportWizard.this.model.getUnderlyingResource().getFullPath();
            path = path.removeFileExtension().addFileExtension("csl");
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            saveAsDialog.setOriginalFile(file);
            saveAsDialog.open();
            this.cslPath = path = saveAsDialog.getResult();
            String label = ".../" + path.lastSegment();
            if (label.length() > 30) {
                label = String.valueOf(label.substring(0, 25)) + "...";
            }
            this.setPropertiesFile.setText("Change:");
            this.cslFileLabel.setText(label);
            return true;
        }
    }
}

