/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.export;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.sba.export.SimulationTracer;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.ISemanticElement;
import uk.ac.ed.inf.common.ui.plotting.Plotting;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.common.ui.plotview.PlotViewPlugin;

public class SimulationTraceJob
extends Job {
    private SimulationTracer simulationTracer;
    private SimulationTracer.SimulationTraceLog traceLogger;
    private boolean doGraph = false;
    private IFile outputFile;

    public SimulationTraceJob(String name) {
        super(name);
    }

    public void setSimulationTracer(SimulationTracer st) {
        this.simulationTracer = st;
    }

    public void setSimulationTraceLogger(SimulationTracer.SimulationTraceLog slt) {
        this.traceLogger = slt;
    }

    public void setDoGraph(boolean dg) {
        this.doGraph = dg;
    }

    public void setOutputFile(IFile file) {
        this.outputFile = file;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.simulationTracer.generateSimulationTrace(this.traceLogger);
            if (this.doGraph) {
                Result result = this.simulationTracer.getSimulationResults();
                InfoWithAxes info = new InfoWithAxes();
                List list = info.getYSeries();
                info.setXSeries(Series.create((double[])result.getTimePoints(), (String)"Time"));
                String[] names = result.getComponentNames();
                int i = 0;
                while (i < names.length) {
                    list.add(Series.create((double[])result.getTimeSeries(i), (String)names[i]));
                    ++i;
                }
                info.setShowLegend(true);
                info.setYLabel("Process Count / Variable Value");
                final IChart chart = Plotting.getPlottingTools().createTimeSeriesChart(info);
                class Semantic
                implements ISemanticElement {
                    Semantic() {
                    }

                    public String getDescription(String format) {
                        return "Trace Generation Simulation";
                    }

                    public Object getAdapter(Class arg0) {
                        return null;
                    }
                }
                chart.setSemanticElement((ISemanticElement)new Semantic());
                Runnable runnable = new Runnable(){

                    public void run() {
                        PlotViewPlugin.getDefault().reveal(chart);
                    }
                };
                Display.getDefault().syncExec(runnable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "uk.ac.ed.inf.biopepa.ui", e.getMessage());
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            if (this.outputFile != null) {
                this.outputFile.refreshLocal(0, null);
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new Status(4, "uk.ac.ed.inf.biopepa.ui", e.getMessage());
        }
    }
}

