/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.export;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.sba.export.TraviandoExport;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.ISemanticElement;
import uk.ac.ed.inf.common.ui.plotting.Plotting;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.common.ui.plotview.PlotViewPlugin;

public class TraviandoExportJob
extends Job {
    private TraviandoExport traviandoExport;
    private IFile outputFile;
    private boolean doGraph;

    public TraviandoExportJob(String name) {
        super(name);
    }

    public void setTraviandoExport(TraviandoExport trexp) {
        this.traviandoExport = trexp;
    }

    public void setOutputFile(IFile file) {
        this.outputFile = file;
    }

    public void setDisplayGraph(boolean b) {
        this.doGraph = b;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (this.outputFile != null) {
                String filePath = this.outputFile.getLocation().toOSString();
                this.traviandoExport.exportToFile(filePath);
            } else {
                this.traviandoExport.justDrawTheGraph();
            }
            Result result = this.traviandoExport.getSimulationResults();
            if (this.doGraph) {
                InfoWithAxes info = new InfoWithAxes();
                List list = info.getYSeries();
                info.setXSeries(Series.create((double[])result.getTimePoints(), (String)"Time"));
                String[] names = result.getComponentNames();
                int i = 0;
                while (i < names.length) {
                    list.add(Series.create((double[])result.getTimeSeries(i), (String)names[i]));
                    ++i;
                }
                info.setShowLegend(true);
                info.setYLabel("Process Count / Variable Value");
                final IChart chart = Plotting.getPlottingTools().createTimeSeriesChart(info);
                class Semantic
                implements ISemanticElement {
                    Semantic() {
                    }

                    public String getDescription(String format) {
                        return "Trace Generation Simulation";
                    }

                    public Object getAdapter(Class arg0) {
                        return null;
                    }
                }
                chart.setSemanticElement((ISemanticElement)new Semantic());
                Runnable runnable = new Runnable(){

                    public void run() {
                        PlotViewPlugin.getDefault().reveal(chart);
                    }
                };
                Display.getDefault().syncExec(runnable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Status(4, "uk.ac.ed.inf.biopepa.ui", e.getMessage());
        }
        try {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (this.outputFile != null) {
                this.outputFile.refreshLocal(0, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return new Status(4, "uk.ac.ed.inf.biopepa.ui", e.getMessage());
        }
        return Status.OK_STATUS;
    }
}

