/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.export;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SaveAsDialog;
import uk.ac.ed.inf.biopepa.core.sba.FileStringConsumer;
import uk.ac.ed.inf.biopepa.core.sba.SBAModel;
import uk.ac.ed.inf.biopepa.core.sba.StringConsumer;
import uk.ac.ed.inf.biopepa.core.sba.export.SimulationTracer;
import uk.ac.ed.inf.biopepa.core.sba.export.TraviandoExport;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;
import uk.ac.ed.inf.biopepa.ui.interfaces.IResourceProvider;
import uk.ac.ed.inf.biopepa.ui.wizards.export.SimulationTraceJob;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.PhasesPage;

public class TraviandoExportWizard
extends Wizard
implements IResourceProvider {
    BioPEPAModel model;
    private ExportPage exportPage;
    private PhasesPage phasesPage;

    public TraviandoExportWizard(BioPEPAModel model) {
        if (model == null) {
            throw new NullPointerException("Error; model does not exist.");
        }
        this.model = model;
        this.setHelpAvailable(false);
        this.setWindowTitle("Export options for Bio-PEPA");
    }

    public void addPages() {
        this.exportPage = new ExportPage("Export a Traviando Trace");
        this.addPage((IWizardPage)this.exportPage);
        this.phasesPage = new PhasesPage(this.model);
        this.addPage((IWizardPage)this.phasesPage);
    }

    public boolean performFinish() {
        SimulationTracer.NullTraceLog traceLogger;
        SBAModel sbaModel = this.model.getSBAModel();
        SimulationTracer simTrace = new SimulationTracer(sbaModel);
        SimulationTraceJob traceJob = new SimulationTraceJob("Traviando Export");
        if (this.exportPage.getExportTraceFile()) {
            SaveAsDialog saveAsDialog = new SaveAsDialog(this.getShell());
            IPath path = this.model.getUnderlyingResource().getFullPath();
            path = path.removeFileExtension().addFileExtension("xml");
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            saveAsDialog.setOriginalFile(file);
            saveAsDialog.open();
            path = saveAsDialog.getResult();
            if (path == null) {
                return false;
            }
            path = path.removeFileExtension().addFileExtension("xml");
            file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            String filePath = file.getLocation().toOSString();
            FileStringConsumer fsc = new FileStringConsumer(filePath);
            TraviandoExport.TraviandoTraceLog travLog = new TraviandoExport.TraviandoTraceLog((StringConsumer)fsc, sbaModel);
            travLog.setCompleteConsumer(true);
            String modelName = path.removeFileExtension().lastSegment();
            travLog.setModelName(modelName);
            travLog.setDisplayComments(this.exportPage.getDisplayComments());
            travLog.setModelComment(this.exportPage.getModelComment());
            traceLogger = travLog;
            traceJob.setOutputFile(file);
        } else {
            traceLogger = new SimulationTracer.NullTraceLog();
            traceJob.setOutputFile(null);
        }
        simTrace.setDataPointStep(this.exportPage.getDataPointSize());
        simTrace.setFiringsLimit(this.exportPage.getFiringsLimit());
        simTrace.setTimeLimit(this.exportPage.getTimeLimit());
        simTrace.setDelays(this.phasesPage.getDelays());
        simTrace.setPhaseLines(this.phasesPage.getPhaseLines());
        traceJob.setDoGraph(this.exportPage.getDisplayGraph());
        traceJob.setSimulationTracer(simTrace);
        traceJob.setSimulationTraceLogger((SimulationTracer.SimulationTraceLog)traceLogger);
        traceJob.schedule();
        return true;
    }

    public IResource getUnderlyingResource() {
        return this.model.getUnderlyingResource();
    }

    private class ExportPage
    extends WizardPage {
        private Button firingsLimitCheck;
        private Text firingsLimitText;
        private Button exportTraceFile;
        private Button timingLimitCheck;
        private Text timeLimitText;
        private Button displayCommentsButton;
        private Text modelCommentText;
        private Button displayGraph;
        private Text dataPointsText;
        private ModifyListener modifyListener;
        private Listener checkBoxListener;

        protected ExportPage(String pageName) {
            super(pageName);
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    ExportPage.this.validate();
                }
            };
            this.checkBoxListener = new Listener(){

                public void handleEvent(Event event) {
                    ExportPage.this.enableWidgets();
                    ExportPage.this.validate();
                }
            };
            this.setTitle("Traviando Trace Export");
            this.setDescription("Set up a trace for Traviando Export");
        }

        public void createControl(Composite parent) {
            int textStyle = 133120;
            int labelStyle = 16388;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout());
            this.setControl((Control)composite);
            Label tmpLabel = new Label(composite, labelStyle);
            tmpLabel.setText("Please set the time or firings limit for this trace");
            tmpLabel.setLayoutData((Object)this.createDefaultGridData());
            Composite labelsComposite = new Composite(composite, 0);
            GridLayout labelsCompLayout = new GridLayout(3, false);
            labelsComposite.setLayout((Layout)labelsCompLayout);
            Label firingLabel = new Label(labelsComposite, labelStyle);
            this.firingsLimitCheck = new Button(labelsComposite, 32);
            this.firingsLimitCheck.setSelection(true);
            this.firingsLimitCheck.addListener(13, this.checkBoxListener);
            firingLabel.setText("Number of firings limit");
            this.firingsLimitText = new Text(labelsComposite, textStyle);
            this.firingsLimitText.setText("200");
            this.firingsLimitText.setLayoutData((Object)this.newTextGridData());
            this.firingsLimitText.addModifyListener(this.modifyListener);
            Label timeLimitLabel = new Label(labelsComposite, labelStyle);
            this.timingLimitCheck = new Button(labelsComposite, 32);
            this.timingLimitCheck.setSelection(false);
            this.timingLimitCheck.addListener(13, this.checkBoxListener);
            this.timeLimitText = new Text(labelsComposite, textStyle);
            timeLimitLabel.setText("Set the time limit for this trace");
            this.timeLimitText.setText("200");
            this.timeLimitText.setLayoutData((Object)this.newTextGridData());
            this.timeLimitText.addModifyListener(this.modifyListener);
            this.exportTraceFile = new Button(composite, 32);
            this.exportTraceFile.setText("Export a trace file");
            this.exportTraceFile.setSelection(false);
            this.displayCommentsButton = new Button(composite, 32);
            this.displayCommentsButton.setText("Output Comments");
            this.displayCommentsButton.setSelection(false);
            Label explainComment = new Label(composite, labelStyle);
            explainComment.setText("Enter a comment for what the model does(this isn't hugely important)");
            this.modelCommentText = new Text(composite, 18432);
            this.modelCommentText.setText("Trace generated from BioPEPA Eclipse Plugin");
            this.displayGraph = new Button(composite, 32);
            this.displayGraph.setText("Show results graph");
            this.displayGraph.setSelection(false);
            this.displayGraph.addListener(13, this.checkBoxListener);
            Label explainDataPoints = new Label(composite, labelStyle);
            explainDataPoints.setText("Set the increment in data point size for the graph");
            this.dataPointsText = new Text(composite, textStyle);
            this.dataPointsText.setText("");
            this.dataPointsText.setLayoutData((Object)this.newTextGridData());
            this.dataPointsText.addModifyListener(this.modifyListener);
            this.enableWidgets();
            this.validate();
        }

        private GridData newTextGridData() {
            GridData textGridData = new GridData();
            textGridData.widthHint = 80;
            textGridData.horizontalAlignment = 4;
            textGridData.grabExcessHorizontalSpace = true;
            return textGridData;
        }

        private void enableWidgets() {
            if (this.firingsLimitCheck.getSelection()) {
                this.firingsLimitText.setEnabled(true);
            } else {
                this.firingsLimitText.setEnabled(false);
            }
            if (this.timingLimitCheck.getSelection()) {
                this.timeLimitText.setEnabled(true);
            } else {
                this.timeLimitText.setEnabled(false);
            }
            if (this.displayGraph.getSelection()) {
                this.dataPointsText.setEnabled(true);
            } else {
                this.dataPointsText.setEnabled(false);
            }
        }

        private void validate() {
            String text;
            this.setPageComplete(false);
            this.setErrorMessage(null);
            String fText = this.firingsLimitText.getText().trim();
            String tText = this.timeLimitText.getText().trim();
            boolean firingsChecked = this.firingsLimitCheck.getSelection();
            boolean timingsChecked = this.timingLimitCheck.getSelection();
            if (firingsChecked) {
                try {
                    Integer.parseInt(fText);
                }
                catch (Exception exception) {
                    this.setPageComplete(false);
                    this.setErrorMessage("Cannot parse firings limit");
                    return;
                }
            }
            if (timingsChecked) {
                try {
                    Double.parseDouble(tText);
                }
                catch (Exception exception) {
                    this.setPageComplete(false);
                    this.setErrorMessage("Cannot parse time limit");
                    return;
                }
            }
            if (!firingsChecked && !timingsChecked) {
                this.setPageComplete(false);
                this.setErrorMessage("You must set one kind of limit");
                return;
            }
            if (this.displayGraph.getSelection() && !(text = this.dataPointsText.getText().trim()).isEmpty()) {
                try {
                    Double.parseDouble(text);
                }
                catch (Exception exception) {
                    this.setPageComplete(false);
                    this.setErrorMessage("Cannot parse data points");
                    return;
                }
            }
            this.setPageComplete(true);
        }

        public int getFiringsLimit() {
            if (this.firingsLimitCheck.getSelection()) {
                String text = this.firingsLimitText.getText().trim();
                try {
                    return Integer.parseInt(text);
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            return Integer.MAX_VALUE;
        }

        public double getTimeLimit() {
            if (this.timingLimitCheck.getSelection()) {
                String text = this.timeLimitText.getText().trim();
                try {
                    return Double.parseDouble(text);
                }
                catch (Exception exception) {
                    return 0.0;
                }
            }
            return Double.MAX_VALUE;
        }

        public boolean getExportTraceFile() {
            return this.exportTraceFile.getSelection();
        }

        public boolean getDisplayComments() {
            return this.displayCommentsButton.getSelection();
        }

        public String getModelComment() {
            if (this.modelCommentText == null) {
                return "";
            }
            return this.modelCommentText.getText();
        }

        public boolean getDisplayGraph() {
            return this.displayGraph.getSelection();
        }

        public double getDataPointSize() {
            if (this.displayGraph.getSelection()) {
                String text = this.dataPointsText.getText().trim();
                if (text.isEmpty()) {
                    return 1.0;
                }
                try {
                    return Double.parseDouble(text);
                }
                catch (Exception exception) {
                    return 0.0;
                }
            }
            return Double.MAX_VALUE;
        }

        private GridData createDefaultGridData() {
            return new GridData(4, 0x1000000, true, false);
        }
    }
}

