/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.timeseries;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import uk.ac.ed.inf.biopepa.core.interfaces.Result;
import uk.ac.ed.inf.biopepa.core.interfaces.Solver;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;
import uk.ac.ed.inf.biopepa.core.sba.Parameters;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.ISemanticElement;
import uk.ac.ed.inf.common.ui.plotting.Plotting;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.common.ui.plotview.PlotViewPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisJob
extends Job {
    private static String term = System.getProperty("line.separator");
    BioPEPAModel model;
    Solver solver;
    Parameters parameters;
    ExperimentSet experimentation;
    private boolean justBuildCsv;
    private IPath csvPath;

    AnalysisJob(BioPEPAModel model, Parameters parameters, ExperimentSet experiments, Solver solver) {
        super("Time-series Analysis (" + solver.getShortName() + ")");
        this.model = model;
        this.parameters = parameters;
        this.solver = solver;
        this.experimentation = experiments;
        this.justBuildCsv = false;
        this.csvPath = null;
    }

    public void setJustBuildCsv(boolean b) {
        this.justBuildCsv = b;
    }

    public void setCsvPath(IPath p) {
        this.csvPath = p;
    }

    protected IStatus run(IProgressMonitor monitor) {
        LinkedList experimentLines = this.experimentation.getExperimentLines();
        try {
            for (ExperimentSet.ExperimentLine experLine : experimentLines) {
                Result result = this.model.timeSeriesAnalysis(this.solver, this.parameters, experLine, monitor);
                experLine.setResult(result);
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        try {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (this.experimentation.getSeparateGraphs()) {
                for (ExperimentSet.ExperimentLine experLine : experimentLines) {
                    LinkedList<ExperimentSet.ExperimentLine> singleList = new LinkedList<ExperimentSet.ExperimentLine>();
                    singleList.add(experLine);
                    this.drawGraph(false, experLine.getName(), singleList);
                }
            } else {
                this.drawGraph(true, "results", experimentLines);
            }
        }
        catch (Exception e) {
            return new Status(4, "uk.ac.ed.inf.biopepa.ui", e.getMessage());
        }
        return Status.OK_STATUS;
    }

    private void drawGraph(boolean isSingleGraph, String graphTitle, LinkedList<ExperimentSet.ExperimentLine> experimentLines) {
        if (experimentLines.isEmpty()) {
            return;
        }
        InfoWithAxes info = new InfoWithAxes();
        List list = info.getYSeries();
        for (ExperimentSet.ExperimentLine experLine : experimentLines) {
            Result result = experLine.getResult();
            info.setXSeries(Series.create((double[])result.getTimePoints(), (String)"Time"));
            String[] names = result.getComponentNames();
            String name = experLine.getName();
            String prefix = isSingleGraph && name != null ? String.valueOf(name) + " - " : "";
            int i = 0;
            while (i < names.length) {
                list.add(Series.create((double[])result.getTimeSeries(i), (String)(String.valueOf(prefix) + names[i])));
                ++i;
            }
        }
        info.setShowLegend(true);
        info.setYLabel("Process Count / Variable Value");
        IPath path = this.model.getUnderlyingResource().getFullPath();
        path.removeFileExtension();
        if (graphTitle.equals("")) {
            info.setGraphTitle(path.lastSegment());
        } else {
            info.setGraphTitle(String.valueOf(path.lastSegment()) + " - " + graphTitle);
        }
        final IChart chart = Plotting.getPlottingTools().createTimeSeriesChart(info);
        Result[] resultsArray = new Result[experimentLines.size()];
        int i = 0;
        while (i < experimentLines.size()) {
            resultsArray[i] = experimentLines.get(i).getResult();
            ++i;
        }
        ResultsAdapter ra = new ResultsAdapter(resultsArray);
        chart.setSemanticElement((ISemanticElement)ra);
        if (this.csvPath != null) {
            IPath thisCsvPath = (IPath)this.csvPath.clone();
            if (!isSingleGraph) {
                thisCsvPath = thisCsvPath.removeFileExtension();
                thisCsvPath = thisCsvPath.addFileExtension(graphTitle);
                thisCsvPath = thisCsvPath.addFileExtension("csv");
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(thisCsvPath);
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(Plotting.getPlottingTools().convertToCSV(chart));
                if (file.exists()) {
                    file.setContents((InputStream)is, true, false, (IProgressMonitor)new NullProgressMonitor());
                } else {
                    file.create((InputStream)is, true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        if (!this.justBuildCsv) {
            Runnable runnable = new Runnable(){

                public void run() {
                    PlotViewPlugin.getDefault().reveal(chart);
                }
            };
            Display.getDefault().syncExec(runnable);
        }
    }

    private class ResultsAdapter
    implements ISemanticElement {
        private Result[] results;

        ResultsAdapter(Result[] results) {
            this.results = results;
        }

        public Object getAdapter(Class adapter) {
            if (adapter.equals(Result.class)) {
                return this.results;
            }
            return null;
        }

        public String getDescription(String format) {
            StringBuilder sb = new StringBuilder();
            if ("CSV".equals(format)) {
                Result[] resultArray = this.results;
                int n = this.results.length;
                int n2 = 0;
                while (n2 < n) {
                    Result result = resultArray[n2];
                    sb.append("# Simulator: ").append(result.getSimulatorName()).append(term);
                    for (Map.Entry me : result.getSimulatorParameters().entrySet()) {
                        sb.append("# ").append((String)me.getKey()).append(": ").append(((Number)me.getValue()).toString()).append(term);
                    }
                    sb.append("# Model Parameters").append(term);
                    for (Map.Entry me : result.getModelParameters().entrySet()) {
                        sb.append("# ").append((String)me.getKey()).append(" = ").append(((Number)me.getValue()).toString()).append(term);
                    }
                    ++n2;
                }
            }
            return sb.toString();
        }
    }
}

