/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.biopepa.ui.wizards.timeseries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.dialogs.SaveAsDialog;
import uk.ac.ed.inf.biopepa.core.interfaces.Solver;
import uk.ac.ed.inf.biopepa.core.sba.ExperimentSet;
import uk.ac.ed.inf.biopepa.core.sba.Parameters;
import uk.ac.ed.inf.biopepa.core.sba.Solvers;
import uk.ac.ed.inf.biopepa.ui.BioPEPAEvent;
import uk.ac.ed.inf.biopepa.ui.interfaces.BioPEPAModel;
import uk.ac.ed.inf.biopepa.ui.interfaces.IResourceProvider;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.AlgorithmWizardPage;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.AnalysisJob;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.ImportCSVPage;
import uk.ac.ed.inf.biopepa.ui.wizards.timeseries.SpeciesSelectionWizardPage;

public class TimeSeriesAnalysisWizard
extends Wizard
implements IResourceProvider {
    BioPEPAModel model;
    Solver solver;
    Map<Parameters.Parameter, Object> uParameters;
    Parameters parameters;
    private SpeciesSelectionWizardPage speciesSelectionPage;
    private ImportCSVPage importCSVPage;

    public TimeSeriesAnalysisWizard(BioPEPAModel model) {
        if (model == null) {
            throw new NullPointerException("Error; model does not exist.");
        }
        this.model = model;
        this.setHelpAvailable(false);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Time-series analysis wizard");
        this.uParameters = new HashMap<Parameters.Parameter, Object>();
        this.loadParameters();
    }

    public void addPages() {
        SpeciesSelectionWizardPage sswp = new SpeciesSelectionWizardPage(this.model, this.uParameters);
        this.addPage((IWizardPage)sswp);
        this.addPage((IWizardPage)new AlgorithmWizardPage(this.model, this.uParameters));
        this.importCSVPage = new ImportCSVPage(this.model);
        this.addPage((IWizardPage)this.importCSVPage);
    }

    public IResource getUnderlyingResource() {
        return this.model.getUnderlyingResource();
    }

    public boolean performFinish() {
        this.parameters.setValue(Parameters.Parameter.Components, this.uParameters.get(Parameters.Parameter.Components));
        this.saveParameters();
        this.model.notify(new BioPEPAEvent(this.model, BioPEPAEvent.Event.MODIFIED, 1L));
        ExperimentSet experSet = this.importCSVPage.getExperimentSet();
        if (experSet == null) {
            experSet = new ExperimentSet();
            experSet.addExperimentLine(experSet.emptyExperimentLine("results"));
        }
        experSet.setSeparateGraphs(this.importCSVPage.getSeparateGraphs());
        AnalysisJob myJob = new AnalysisJob(this.model, this.parameters, experSet, this.solver);
        boolean onlyCsv = this.importCSVPage.getJustBuildCsv();
        myJob.setJustBuildCsv(onlyCsv);
        if (onlyCsv) {
            SaveAsDialog saveAsDialog = new SaveAsDialog(this.getShell());
            IPath path = this.model.getUnderlyingResource().getFullPath();
            path = path.removeFileExtension().addFileExtension("csv");
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            saveAsDialog.setOriginalFile(file);
            saveAsDialog.open();
            path = saveAsDialog.getResult();
            myJob.setCsvPath(path);
        }
        myJob.schedule();
        return true;
    }

    private void loadParameters() {
        Class<?> c = new String[0].getClass();
        Parameters.Parameter[] pArray = Parameters.Parameter.values();
        this.solver = Solvers.getSolverInstance((String)this.model.getProperty("solver"));
        Parameters.Parameter[] parameterArray = pArray;
        int n = pArray.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                Parameters.Parameter p = parameterArray[n2];
                String s = this.model.getProperty(p.getKey());
                if (s != null) {
                    Object o = p.parseString(s);
                    if (o != null) {
                        this.uParameters.put(p, o);
                    } else if (p.getType().equals(c)) {
                        StringBuilder sb = new StringBuilder(s);
                        ArrayList<String> al = new ArrayList<String>();
                        try {
                            while (sb.length() > 0) {
                                int index = sb.indexOf(":");
                                if (index != -1) {
                                    int length = Integer.parseInt(sb.substring(0, index));
                                    sb.delete(0, index + 1);
                                    al.add(sb.substring(0, length));
                                    sb.delete(0, length);
                                    continue;
                                }
                                break block9;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            break block9;
                        }
                        this.uParameters.put(p, al.toArray(new String[0]));
                    }
                }
            }
            ++n2;
        }
    }

    private void saveParameters() {
        Class<?> c = new String[0].getClass();
        if (this.solver != null) {
            this.model.setProperty("solver", this.solver.getShortName());
        }
        for (Map.Entry<Parameters.Parameter, Object> me : this.uParameters.entrySet()) {
            if (me.getKey().getType().equals(c) && me.getValue() != null) {
                String[] sa = (String[])me.getValue();
                StringBuilder sb = new StringBuilder();
                String[] stringArray = sa;
                int n = sa.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    sb.append(s.length()).append(":").append(s);
                    ++n2;
                }
                this.model.setProperty(me.getKey().getKey(), sb.toString());
                continue;
            }
            if (me.getValue() == null) continue;
            this.model.setProperty(me.getKey().getKey(), me.getValue().toString());
        }
    }
}

