/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.plotting.dialogs;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.dialogs.ChartPreview;
import uk.ac.ed.inf.common.ui.plotting.internal.CommonChart;

public class ChartDialog
extends Dialog {
    protected IChart chart;
    private Point initialSize;
    private Canvas paintCanvas;
    private ChartPreview preview;

    public ChartDialog(Shell parentShell, IChart chart) {
        this(parentShell, chart, null);
    }

    public ChartDialog(Shell parentShell, IChart chart, Point initialSize) {
        super(parentShell);
        Assert.isTrue((boolean)(chart instanceof CommonChart));
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.chart = chart;
        this.initialSize = initialSize;
    }

    public IChart getChart() {
        return this.chart;
    }

    protected Point getInitialSize() {
        if (this.initialSize == null) {
            return new Point(800, 600);
        }
        return this.initialSize;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.paintCanvas = new Canvas(composite, 2048);
        this.paintCanvas.setLayoutData((Object)new GridData(1808));
        this.paintCanvas.setBackground(Display.getDefault().getSystemColor(1));
        this.preview = new ChartPreview(this.chart);
        this.paintCanvas.addPaintListener((PaintListener)this.preview);
        this.paintCanvas.addControlListener((ControlListener)this.preview);
        this.preview.setPreview(this.paintCanvas);
        this.preview.renderModel();
        this.paintCanvas.setLayoutData((Object)new GridData(1808));
        return composite;
    }
}

