/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.plotting.dialogs;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.internal.CommonChart;

public class ChartPreview
implements PaintListener,
ControlListener {
    private transient Canvas preview = null;
    private Chart cm = null;
    private transient boolean bIsPainting = false;
    private transient Image buffer;
    private static int X_OFFSET = 3;
    private static int Y_OFFSET = 3;

    public ChartPreview(IChart chart) {
        this.cm = ((CommonChart)chart).getBirtChart();
    }

    public void renderModel() {
        if (this.preview != null && !this.preview.isDisposed()) {
            this.updateBuffer();
            this.preview.redraw();
        }
    }

    private void updateBuffer() {
        if (this.bIsPainting) {
            return;
        }
        Exception paintError = null;
        Rectangle re = this.preview.getClientArea();
        Rectangle adjustedRe = new Rectangle(0, 0, re.width, re.height);
        if (adjustedRe.width - 2 * X_OFFSET <= 0 || adjustedRe.height - 2 * Y_OFFSET <= 0) {
            if (this.buffer != null && !this.buffer.isDisposed()) {
                this.buffer.dispose();
                this.buffer = null;
            }
            return;
        }
        if (this.cm == null) {
            this.buffer = null;
        } else {
            Image oldBuffer;
            block18: {
                this.bIsPainting = true;
                oldBuffer = null;
                if (this.buffer == null) {
                    this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
                } else {
                    Rectangle ore = this.buffer.getBounds();
                    oldBuffer = this.buffer;
                    if (!adjustedRe.equals((Object)ore)) {
                        this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
                    }
                }
                GC gc = new GC((Drawable)this.buffer);
                gc.setForeground(Display.getDefault().getSystemColor(1));
                gc.fillRectangle(this.buffer.getBounds());
                Bounds bo = BoundsImpl.create((double)X_OFFSET, (double)Y_OFFSET, (double)(adjustedRe.width - 2 * X_OFFSET), (double)(adjustedRe.height - 2 * Y_OFFSET));
                IDeviceRenderer deviceRenderer = null;
                try {
                    try {
                        deviceRenderer = PluginSettings.instance().getDevice("dv.SWT");
                        deviceRenderer.setProperty("device.output.context", (Object)gc);
                        bo.scale(72.0 / (double)deviceRenderer.getDisplayServer().getDpiResolution());
                        Generator gr = Generator.instance();
                        RunTimeContext rtc = new RunTimeContext();
                        GeneratedChartState state = gr.build(deviceRenderer.getDisplayServer(), this.cm, bo, null, rtc, null);
                        gr.render(deviceRenderer, state);
                    }
                    catch (Exception ex) {
                        paintError = ex;
                        gc.dispose();
                        if (deviceRenderer != null) {
                            deviceRenderer.dispose();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    gc.dispose();
                    if (deviceRenderer != null) {
                        deviceRenderer.dispose();
                    }
                    throw throwable;
                }
                gc.dispose();
                if (deviceRenderer != null) {
                    deviceRenderer.dispose();
                }
            }
            if (paintError != null) {
                this.buffer = oldBuffer;
            }
            if (oldBuffer != null && oldBuffer != this.buffer) {
                oldBuffer.dispose();
            }
            this.bIsPainting = false;
        }
    }

    public void paintControl(PaintEvent pe) {
        GC gc = pe.gc;
        if (this.buffer != null) {
            gc.drawImage(this.buffer, 0, 0);
        }
    }

    public void setPreview(Canvas paintCanvas) {
        this.preview = paintCanvas;
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (this.preview != null && !this.preview.isDisposed()) {
            this.updateBuffer();
            this.preview.redraw();
        }
    }
}

