/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.plotting.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import uk.ac.ed.inf.common.ui.plotting.internal.ICSVExporter;

public abstract class AbstractCSVExporter
implements ICSVExporter {
    private ByteArrayOutputStream os = new ByteArrayOutputStream();
    private String fHeader = "";
    protected static final byte[] SEP = ", ".getBytes();
    protected static final byte[] NEW_LINE = System.getProperty("line.separator").getBytes();

    protected AbstractCSVExporter() {
    }

    public final byte[] getCSV() throws IOException {
        this.handleHeader(this.os);
        this.handleChart(this.os);
        return this.os.toByteArray();
    }

    public void setHeader(String header) {
        this.fHeader = header == null ? "" : header;
    }

    protected abstract void handleChart(ByteArrayOutputStream var1) throws IOException;

    protected static String format(String original) {
        return "\"" + original + "\"";
    }

    private void handleHeader(ByteArrayOutputStream baos) throws IOException {
        if (this.fHeader == null || this.fHeader == "") {
            return;
        }
        String term = System.getProperty("line.separator");
        String header = this.fHeader;
        if (!this.fHeader.startsWith("#")) {
            header = "# " + header.replaceAll(term, String.valueOf(term) + "# ") + term;
        }
        baos.write(header.getBytes());
    }
}

