/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.plotting.internal;

import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.common.ui.plotting.internal.ChartWithAxesBuilder;

public class BarChartBuilder
extends ChartWithAxesBuilder {
    private SeriesDefinition xSeriesDefinition;

    public BarChartBuilder(InfoWithAxes info) {
        super(info, true);
    }

    protected void buildXAxis() {
        super.buildXAxis();
        this.xAxis.getMajorGrid().getLineAttributes().setVisible(false);
        this.xAxis.getLabel().setVisible(false);
    }

    protected void buildXSeries() {
        String[] values = this.info.getCategories();
        TextDataSet categoryValues = TextDataSetImpl.create((Object)values);
        org.eclipse.birt.chart.model.component.Series seriesCategory = SeriesImpl.create();
        seriesCategory.setDataSet((DataSet)categoryValues);
        this.xSeriesDefinition = SeriesDefinitionImpl.create();
        this.xSeriesDefinition.getSeriesPalette().shift(1);
        this.xAxis.getSeriesDefinitions().add((Object)this.xSeriesDefinition);
        this.xSeriesDefinition.getSeries().add((Object)seriesCategory);
    }

    protected void buildYSeries() {
        SeriesDefinition seriesDefinitionY = SeriesDefinitionImpl.create();
        this.yAxis.getSeriesDefinitions().add((Object)seriesDefinitionY);
        for (Series series : ((InfoWithAxes)this.info).getYSeries()) {
            double[] values = series.getValues();
            BarSeries barSeries = this.createBarSeries(series.getValues());
            Double[] recordedValues = new Double[values.length];
            int j = 0;
            while (j < recordedValues.length) {
                recordedValues[j] = values[j];
                ++j;
            }
            barSeries.setSeriesIdentifier((Object)series.getLabel());
            seriesDefinitionY.getSeriesPalette().shift(1);
            seriesDefinitionY.getSeries().add((Object)barSeries);
        }
    }

    protected void handleLegend(Legend legend) {
        super.handleLegend(legend);
        legend.setItemType(LegendItemType.CATEGORIES_LITERAL);
    }

    private BarSeries createBarSeries(double[] values) {
        NumberDataSet orthoValuesDataSet1 = NumberDataSetImpl.create((Object)values);
        BarSeries series = (BarSeries)BarSeriesImpl.create();
        series.setRiserOutline(null);
        series.setDataSet((DataSet)orthoValuesDataSet1);
        return series;
    }
}

