/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.plotting.internal;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Grid;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.internal.Generic2DGraph;
import uk.ac.ed.inf.common.ui.plotting.internal.OptionKind;

public abstract class ChartWithAxesBuilder
extends Generic2DGraph {
    protected Axis xAxis;
    protected Axis yAxis;
    protected boolean isXAxisText;

    public ChartWithAxesBuilder(InfoWithAxes info, boolean isXAxisText) {
        super(info, (Chart)ChartWithAxesImpl.create());
        this.isXAxisText = isXAxisText;
    }

    protected void handleChart(Chart chart) {
        this.xAxis = ((ChartWithAxes)chart).getPrimaryBaseAxes()[0];
        this.buildXAxis();
        this.buildXSeries();
        this.yAxis = ((ChartWithAxes)chart).getPrimaryOrthogonalAxis(this.xAxis);
        this.buildYAxis();
        this.buildYSeries();
    }

    protected abstract void buildXSeries();

    protected abstract void buildYSeries();

    protected void buildXAxis() {
        AxisType type = this.isXAxisText ? AxisType.TEXT_LITERAL : AxisType.LINEAR_LITERAL;
        double rotation = this.isXAxisText ? Double.parseDouble((String)this.options.get((Object)OptionKind.X_AXIS_ROTATION)) : 0.0;
        this.xAxis.setType(type);
        this.xAxis.getLabel().getCaption().getFont().setRotation(rotation);
        this.setCaptions(this.xAxis, ((InfoWithAxes)this.info).getXSeries().getLabel());
        this.setGrid(this.xAxis, TickStyle.BELOW_LITERAL);
    }

    protected void buildYAxis() {
        this.yAxis.setType(AxisType.LINEAR_LITERAL);
        this.setCaptions(this.yAxis, ((InfoWithAxes)this.info).getYLabel());
        this.setGrid(this.yAxis, TickStyle.LEFT_LITERAL);
    }

    private void setCaptions(Axis axis, String title) {
        axis.getLabel().setVisible(true);
        axis.getLabel().getCaption().getFont().setSize(Float.parseFloat((String)this.options.get((Object)OptionKind.AXIS_TICK_FONT_SIZE)));
        if (title.length() == 0) {
            axis.getTitle().setVisible(false);
        } else {
            axis.getTitle().setVisible(true);
        }
        Text titleCaption = axis.getTitle().getCaption();
        titleCaption.setValue(title);
        titleCaption.getFont().setBold(false);
        titleCaption.getFont().setSize(Float.parseFloat((String)this.options.get((Object)OptionKind.AXIS_LABEL_FONT_SIZE)));
    }

    protected void setGrid(Axis axis, TickStyle style) {
        Grid majorGrid = axis.getMajorGrid();
        majorGrid.setTickStyle(style);
        majorGrid.getLineAttributes().setVisible(true);
        majorGrid.getLineAttributes().setColor(ColorDefinitionImpl.GREY());
        majorGrid.getLineAttributes().setStyle(LineStyle.DASHED_LITERAL);
    }
}

