/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.plotting.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.birt.chart.extension.datafeed.StockEntry;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.StockDataSet;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import uk.ac.ed.inf.common.ui.plotting.internal.AbstractCSVExporter;

public class ChartWithAxesCSVExporter
extends AbstractCSVExporter {
    private ChartWithAxes fChart;

    public ChartWithAxesCSVExporter(ChartWithAxes birtChart) {
        this.fChart = birtChart;
    }

    protected void handleChart(ByteArrayOutputStream outputStream) throws IOException {
        Axis xAxis = this.fChart.getPrimaryBaseAxes()[0];
        Axis yAxis = this.fChart.getPrimaryOrthogonalAxis(xAxis);
        SeriesDefinition ySeriesDef = (SeriesDefinition)yAxis.getSeriesDefinitions().get(0);
        int numberOfSeries = ySeriesDef.getSeries().size();
        String xAxisLabel = xAxis.getTitle().getCaption().getValue();
        SeriesDefinition xSeriesDef = (SeriesDefinition)xAxis.getSeriesDefinitions().get(0);
        Series xSeries = (Series)xSeriesDef.getSeries().get(0);
        Object xValues = xSeries.getDataSet().getValues();
        int numberOfPoints = -1;
        if (xValues instanceof double[]) {
            numberOfPoints = ((double[])xValues).length;
        } else if (xValues instanceof String[]) {
            numberOfPoints = ((String[])xValues).length;
        } else {
            throw new IOException("Conversion of " + xValues.getClass() + " not supported");
        }
        outputStream.write(("# " + xAxisLabel).getBytes());
        outputStream.write(SEP);
        int i = 0;
        while (i < numberOfSeries) {
            String title = ChartWithAxesCSVExporter.format((String)((Series)ySeriesDef.getSeries().get(i)).getSeriesIdentifier());
            outputStream.write(title.getBytes());
            if (i != numberOfSeries - 1) {
                outputStream.write(SEP);
            }
            ++i;
        }
        outputStream.write(NEW_LINE);
        int p = 0;
        while (p < numberOfPoints) {
            String xElem = null;
            xElem = xValues instanceof double[] ? Double.toString(((double[])xValues)[p]) : ChartWithAxesCSVExporter.format(((String[])xValues)[p]);
            outputStream.write(xElem.getBytes());
            outputStream.write(SEP);
            int s = 0;
            while (s < numberOfSeries) {
                Series series = (Series)ySeriesDef.getSeries().get(s);
                String yElem = Double.toString(this.getValueAtTimePoint(series, p));
                outputStream.write(yElem.getBytes());
                if (s != numberOfSeries - 1) {
                    outputStream.write(SEP);
                }
                ++s;
            }
            outputStream.write(NEW_LINE);
            ++p;
        }
    }

    private double getValueAtTimePoint(Series series, int timePoint) {
        if (series instanceof LineSeries) {
            return ((double[])series.getDataSet().getValues())[timePoint];
        }
        if (series instanceof StockSeries) {
            StockDataSet set = (StockDataSet)series.getDataSet();
            return ((StockEntry[])set.getValues())[timePoint].getLow();
        }
        throw new IllegalStateException();
    }
}

