/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.plotting.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import uk.ac.ed.inf.common.ui.plotting.internal.AbstractCSVExporter;

public class ChartWithoutAxesCSVExporter
extends AbstractCSVExporter {
    private ChartWithoutAxes fChart;

    public ChartWithoutAxesCSVExporter(ChartWithoutAxes birtChart) {
        this.fChart = birtChart;
    }

    protected void handleChart(ByteArrayOutputStream outputStream) throws IOException {
        SeriesDefinition xSeriesDef = (SeriesDefinition)this.fChart.getSeriesDefinitions().get(0);
        Series xSeries = (Series)xSeriesDef.getSeries().get(0);
        Object xValues = xSeries.getDataSet().getValues();
        int numOfColumns = -1;
        if (xValues instanceof double[]) {
            numOfColumns = ((double[])xValues).length;
        } else if (xValues instanceof String[]) {
            numOfColumns = ((String[])xValues).length;
        } else {
            throw new IOException("Conversion of " + xValues.getClass() + " not supported");
        }
        int c = 0;
        while (c < numOfColumns) {
            if (c == 0) {
                outputStream.write("# ".getBytes());
            }
            String text = null;
            if (xValues instanceof double[]) {
                text = Double.toString(((double[])xValues)[c]);
            } else if (xValues instanceof String[]) {
                text = ChartWithoutAxesCSVExporter.format(((String[])xValues)[c]);
            }
            outputStream.write(text.getBytes());
            if (c != numOfColumns - 1) {
                outputStream.write(SEP);
            }
            ++c;
        }
        outputStream.write(NEW_LINE);
        SeriesDefinition ySeriesDef = (SeriesDefinition)xSeriesDef.getSeriesDefinitions().get(0);
        Series ySeries = (Series)ySeriesDef.getSeries().get(0);
        Object yValues = ySeries.getDataSet().getValues();
        int c2 = 0;
        while (c2 < numOfColumns) {
            String text = null;
            if (yValues instanceof double[]) {
                text = Double.toString(((double[])yValues)[c2]);
            } else if (yValues instanceof String[]) {
                text = ChartWithoutAxesCSVExporter.format(((String[])yValues)[c2]);
            }
            outputStream.write(text.getBytes());
            if (c2 != numOfColumns - 1) {
                outputStream.write(SEP);
            }
            ++c2;
        }
    }
}

