/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.plotting.internal;

import java.util.HashMap;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.layout.Legend;
import uk.ac.ed.inf.common.ui.plotting.data.AbstractGraphInfo;
import uk.ac.ed.inf.common.ui.plotting.internal.OptionKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Generic2DGraph {
    protected AbstractGraphInfo info;
    protected Chart chart;
    protected HashMap<OptionKind, String> options = Generic2DGraph.createDefaultOptionMap();

    private static HashMap<OptionKind, String> createDefaultOptionMap() {
        HashMap<OptionKind, String> map = new HashMap<OptionKind, String>();
        map.put(OptionKind.EXPLOSION, "5");
        map.put(OptionKind.FONT_NAME, "Arial");
        map.put(OptionKind.TITLE_FONT_SIZE, "14");
        map.put(OptionKind.AXIS_LABEL_FONT_SIZE, "12");
        map.put(OptionKind.LEGEND_FONT_SIZE, "12");
        map.put(OptionKind.AXIS_TICK_FONT_SIZE, "10");
        map.put(OptionKind.X_AXIS_ROTATION, "90");
        return map;
    }

    public Generic2DGraph(AbstractGraphInfo info, Chart chart) {
        if (info == null) {
            throw new NullPointerException();
        }
        this.info = info;
        this.chart = chart;
    }

    public final Chart createChart() {
        this.chart.getTitle().getLabel().getCaption().setValue(this.info.getGraphTitle());
        this.chart.getTitle().getLabel().getCaption().getFont().setBold(true);
        this.chart.getTitle().getLabel().getCaption().getFont().setSize(Float.parseFloat(this.options.get((Object)OptionKind.TITLE_FONT_SIZE)));
        ChartDimension dimension = this.info.isHas3DEffect() ? ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL : ChartDimension.TWO_DIMENSIONAL_LITERAL;
        this.chart.setDimension(dimension);
        this.handleLegend(this.chart.getLegend());
        this.handleChart(this.chart);
        return this.chart;
    }

    protected abstract void handleChart(Chart var1);

    protected void handleLegend(Legend legend) {
        legend.setItemType(LegendItemType.CATEGORIES_LITERAL);
        legend.setVisible(this.info.isShowLegend());
        legend.getText().getFont().setSize(Float.parseFloat(this.options.get((Object)OptionKind.LEGEND_FONT_SIZE)));
    }
}

