/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.plotting.internal;

import java.util.ArrayList;
import java.util.Formatter;
import org.eclipse.birt.chart.extension.datafeed.StockEntry;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Marker;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.StockDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.StockDataSetImpl;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.model.type.LineSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.model.type.impl.LineSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.StockSeriesImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import uk.ac.ed.inf.common.ui.plotting.data.ConfidenceSeries;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.common.ui.plotting.internal.ChartWithAxesBuilder;

public class LineChartBuilder
extends ChartWithAxesBuilder {
    private static ColorDefinition[] COLORS;
    private static LineStyle[] LINES;

    static {
        ArrayList<ColorDefinition> colors = new ArrayList<ColorDefinition>();
        colors.add(ColorDefinitionImpl.create((int)255, (int)0, (int)0));
        colors.add(ColorDefinitionImpl.create((int)0, (int)0, (int)255));
        colors.add(ColorDefinitionImpl.create((int)0, (int)255, (int)0));
        colors.add(ColorDefinitionImpl.create((int)255, (int)255, (int)0));
        colors.add(ColorDefinitionImpl.create((int)255, (int)200, (int)0));
        colors.add(ColorDefinitionImpl.create((int)255, (int)0, (int)255));
        colors.add(ColorDefinitionImpl.create((int)0, (int)255, (int)255));
        colors.add(ColorDefinitionImpl.create((int)255, (int)175, (int)175));
        colors.add(ColorDefinitionImpl.create((int)128, (int)128, (int)128));
        colors.add(ColorDefinitionImpl.create((int)0, (int)0, (int)0));
        colors.add(ColorDefinitionImpl.create((int)192, (int)0, (int)0));
        colors.add(ColorDefinitionImpl.create((int)0, (int)0, (int)192));
        colors.add(ColorDefinitionImpl.create((int)0, (int)192, (int)0));
        colors.add(ColorDefinitionImpl.create((int)192, (int)192, (int)0));
        colors.add(ColorDefinitionImpl.create((int)192, (int)0, (int)192));
        colors.add(ColorDefinitionImpl.create((int)0, (int)192, (int)192));
        colors.add(ColorDefinitionImpl.create((int)64, (int)64, (int)64));
        colors.add(ColorDefinitionImpl.create((int)255, (int)64, (int)64));
        colors.add(ColorDefinitionImpl.create((int)64, (int)64, (int)255));
        colors.add(ColorDefinitionImpl.create((int)64, (int)255, (int)64));
        COLORS = colors.toArray(new ColorDefinition[colors.size()]);
        LINES = new LineStyle[]{LineStyle.SOLID_LITERAL, LineStyle.DASHED_LITERAL, LineStyle.DOTTED_LITERAL};
    }

    public LineChartBuilder(InfoWithAxes info) {
        super(info, false);
    }

    protected void buildXSeries() {
        double[] xDoubles = ((InfoWithAxes)this.info).getXSeries().getValues();
        NumberDataSet xValues = NumberDataSetImpl.create((Object)xDoubles);
        org.eclipse.birt.chart.model.component.Series xSeries = SeriesImpl.create();
        xSeries.setDataSet((DataSet)xValues);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        this.xAxis.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)xSeries);
    }

    protected void buildYSeries() {
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        this.yAxis.getSeriesDefinitions().add((Object)sdY);
        int i = 0;
        int j = 0;
        for (Series series : ((InfoWithAxes)this.info).getYSeries()) {
            double[] values = series.getValues();
            LineSeries ls = this.createLineSeries(values);
            ls.setSeriesIdentifier((Object)series.getLabel());
            this.setAttibutes(ls, i, j);
            sdY.getSeries().add((Object)ls);
            if (series instanceof ConfidenceSeries) {
                this.chart.setType("Stock Chart");
                this.chart.setSubType("Standard Stock Chart");
                double[] radii = ((ConfidenceSeries)series).getRadii();
                StockSeries ss = this.createStockSeries(values, radii);
                String id = new Formatter().format("%2.1f%% c.i.", ((ConfidenceSeries)series).getConfidenceLevel() * 100.0).toString();
                ss.setSeriesIdentifier((Object)id);
                this.setAttibutes(ss, i, j);
                sdY.getSeries().add((Object)ss);
            }
            ++i;
            ++j;
        }
    }

    private void setAttibutes(LineSeries series, int colorIndex, int lineIndex) {
        LineAttributes la = series.getLineAttributes();
        la.setColor((ColorDefinition)EcoreUtil.copy((EObject)COLORS[colorIndex % COLORS.length]));
        la.setStyle(LINES[lineIndex % LINES.length]);
        la.setThickness(2);
    }

    private void setAttibutes(StockSeries series, int colorIndex, int lineIndex) {
        LineAttributes la = series.getLineAttributes();
        la.setColor((ColorDefinition)EcoreUtil.copy((EObject)COLORS[colorIndex % COLORS.length]));
        la.setStyle(LINES[lineIndex % LINES.length]);
        la.setThickness(2);
    }

    private StockSeries createStockSeries(double[] averages, double[] radii) {
        StockEntry[] entries = new StockEntry[averages.length];
        int i = 0;
        while (i < entries.length) {
            double down = averages[i] - radii[i];
            double up = averages[i] + radii[i];
            entries[i] = new StockEntry(down, down, up, up);
            ++i;
        }
        StockDataSet stockValues = StockDataSetImpl.create((Object)entries);
        StockSeries ss = (StockSeries)StockSeriesImpl.create();
        ss.setDataSet((DataSet)stockValues);
        ss.getLabel().setVisible(false);
        ss.setStickLength(1);
        ss.setShowAsBarStick(true);
        return ss;
    }

    private LineSeries createLineSeries(double[] values) {
        NumberDataSet orthohonalValuesDataSet = NumberDataSetImpl.create((Object)values);
        LineSeries ls = (LineSeries)LineSeriesImpl.create();
        ls.setDataSet((DataSet)orthohonalValuesDataSet);
        for (Object o : ls.getMarkers()) {
            ((Marker)o).setVisible(this.info.isShowMarkers());
        }
        ls.getLabel().setVisible(false);
        return ls;
    }

    protected void handleLegend(Legend legend) {
        super.handleLegend(legend);
        legend.setItemType(LegendItemType.SERIES_LITERAL);
    }
}

