/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.plotting.internal;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.Serializer;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.impl.SerializerImpl;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.IPlottingTools;
import uk.ac.ed.inf.common.ui.plotting.ISemanticElement;
import uk.ac.ed.inf.common.ui.plotting.PlottingException;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithoutAxes;
import uk.ac.ed.inf.common.ui.plotting.internal.AbstractCSVExporter;
import uk.ac.ed.inf.common.ui.plotting.internal.BarChartBuilder;
import uk.ac.ed.inf.common.ui.plotting.internal.ChartWithAxesCSVExporter;
import uk.ac.ed.inf.common.ui.plotting.internal.ChartWithoutAxesCSVExporter;
import uk.ac.ed.inf.common.ui.plotting.internal.CommonChart;
import uk.ac.ed.inf.common.ui.plotting.internal.LineChartBuilder;
import uk.ac.ed.inf.common.ui.plotting.internal.PieChartBuilder;

public class PlottingTools
implements IPlottingTools {
    public IChart createBarChart(InfoWithAxes info) {
        BarChartBuilder builder = new BarChartBuilder(info);
        CommonChart chart = new CommonChart(builder.createChart());
        return chart;
    }

    public IChart createPieChart(InfoWithoutAxes info) {
        PieChartBuilder builder = new PieChartBuilder(info);
        CommonChart chart = new CommonChart(builder.createChart());
        return chart;
    }

    public IChart createTimeSeriesChart(InfoWithAxes info) {
        LineChartBuilder builder = new LineChartBuilder(info);
        CommonChart chart = new CommonChart(builder.createChart());
        return chart;
    }

    public void convertToPNG(IChart chart, int width, int height, int dpi, String filePath) throws PlottingException {
        if (chart == null || filePath == null) {
            throw new NullPointerException();
        }
        Chart birtChart = ((CommonChart)chart).getBirtChart();
        PluginSettings ps = PluginSettings.instance();
        try {
            IDeviceRenderer idr = ps.getDevice("dv.PNG");
            RunTimeContext rtc = new RunTimeContext();
            Generator gr = Generator.instance();
            GeneratedChartState gcs = null;
            Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)width, (double)height);
            gcs = gr.build(idr.getDisplayServer(), birtChart, bo, null, rtc, null);
            idr.setProperty("device.file.identifier", (Object)filePath);
            idr.setProperty("device.resolution", (Object)dpi);
            gr.render(idr, gcs);
        }
        catch (ChartException ce) {
            throw new PlottingException(4, ce.getMessage());
        }
    }

    public void write(IChart chart, String path) throws PlottingException {
        Serializer serialiser = SerializerImpl.instance();
        Chart birtChart = ((CommonChart)chart).getBirtChart();
        try {
            serialiser.write(birtChart, (OutputStream)new BufferedOutputStream(new FileOutputStream(path)));
        }
        catch (Exception e) {
            Status status = new Status(4, "uk.ac.ed.inf.common.ui.charting", "Serialisation error", (Throwable)e);
            throw new PlottingException((IStatus)status);
        }
    }

    public byte[] convertToCSV(IChart chart) throws IOException {
        Chart birtChart = ((CommonChart)chart).getBirtChart();
        AbstractCSVExporter exporter = null;
        exporter = birtChart instanceof ChartWithAxes ? new ChartWithAxesCSVExporter((ChartWithAxes)birtChart) : new ChartWithoutAxesCSVExporter((ChartWithoutAxes)birtChart);
        ISemanticElement se = chart.resolveSemanticElement();
        if (se != null) {
            exporter.setHeader(se.getDescription("CSV"));
        }
        return exporter.getCSV();
    }
}

