/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.plotview.views.actions;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SaveChartDialog
extends TitleAreaDialog {
    private Point originalValues = null;
    private Point result = null;
    private Text widthText;
    private Text heightText;

    public SaveChartDialog(Shell parentShell, int width, int height) {
        super(parentShell);
        this.originalValues = new Point(width, height);
        this.result = new Point(width, height);
    }

    public Point getPoint() {
        return this.result;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Export Options");
        this.setMessage("Select size and resolution");
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        main.setLayout((Layout)layout);
        main.setLayoutData((Object)new GridData(1808));
        main.setFont(parentComposite.getFont());
        Group group = new Group(main, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        group.setText("Select Size");
        GridLayout groupLayout = GridLayoutFactory.copyLayout((GridLayout)layout);
        group.setLayout((Layout)groupLayout);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SaveChartDialog.this.setDialogComplete(SaveChartDialog.this.validatePage());
            }
        };
        this.widthText = this.createRow((Composite)group, "Width", this.originalValues.x);
        this.widthText.addModifyListener(listener);
        this.heightText = this.createRow((Composite)group, "Height", this.originalValues.y);
        this.heightText.addModifyListener(listener);
        Button restoreOriginal = new Button((Composite)group, 8);
        restoreOriginal.setText("Reset");
        restoreOriginal.setToolTipText("Restore current size");
        restoreOriginal.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SaveChartDialog.this.widthText.setText(Integer.toString(((SaveChartDialog)SaveChartDialog.this).originalValues.x));
                SaveChartDialog.this.heightText.setText(Integer.toString(((SaveChartDialog)SaveChartDialog.this).originalValues.y));
                SaveChartDialog.this.setDialogComplete(SaveChartDialog.this.validatePage());
            }
        });
        GridData buttonData = new GridData();
        buttonData.horizontalSpan = 2;
        buttonData.horizontalAlignment = 131072;
        restoreOriginal.setLayoutData((Object)buttonData);
        return parentComposite;
    }

    private void setDialogComplete(boolean complete) {
        this.getButton(0).setEnabled(complete);
    }

    private boolean validatePage() {
        this.setErrorMessage(null);
        this.result = null;
        int currentWidth = 0;
        int currentHeight = 0;
        try {
            currentWidth = Integer.parseInt(this.widthText.getText());
            if (currentWidth <= 0) {
                this.setErrorMessage("Width must be a positive integer");
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage("Invalid width");
            return false;
        }
        try {
            currentHeight = Integer.parseInt(this.heightText.getText());
            if (currentHeight <= 0) {
                this.setErrorMessage("Height must be a positive integer");
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage("Invalid height");
            return false;
        }
        this.result = new Point(currentWidth, currentHeight);
        return true;
    }

    protected void cancelPressed() {
        this.result = null;
        super.cancelPressed();
    }

    private Text createRow(Composite main, String label, int value) {
        Label rowLabel = new Label(main, 0);
        rowLabel.setText(label);
        rowLabel.setLayoutData((Object)new GridData());
        Text rowText = new Text(main, 2048);
        rowText.setText(Integer.toString(value));
        rowText.setLayoutData((Object)new GridData(768));
        return rowText;
    }
}

