/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.jobs;

import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IProgressConstants;
import uk.ac.ed.inf.common.data.IResultData;
import uk.ac.ed.inf.common.ui.plotting.IChart;
import uk.ac.ed.inf.common.ui.plotting.Plotting;
import uk.ac.ed.inf.common.ui.plotting.data.InfoWithAxes;
import uk.ac.ed.inf.common.ui.plotting.data.Series;
import uk.ac.ed.inf.common.ui.plotview.PlotViewPlugin;

public abstract class ResultCollectorJob
extends WorkspaceJob {
    private Action action;

    public ResultCollectorJob(String name) {
        super(name);
    }

    public final IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        this.action = null;
        IResultData data = this.createResultData(monitor);
        this.action = this.createOKAction(data);
        this.action.setText("Show results");
        if (this.isModal()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ResultCollectorJob.this.action.run();
                }
            });
        } else {
            this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
            this.setProperty(IProgressConstants.ACTION_PROPERTY, this.action);
        }
        return Status.OK_STATUS;
    }

    protected abstract IResultData createResultData(IProgressMonitor var1) throws CoreException;

    protected Action createOKAction(final IResultData data) {
        return new Action("View results"){

            public void run() {
                InfoWithAxes info = new InfoWithAxes();
                Series x = Series.create((double[])data.getTimeSeries(), (String)"Time");
                info.setXSeries(x);
                int s = 0;
                while (s < data.getNumberOfInstances()) {
                    Series y = Series.create((double[])data.getValues(s), (String)("Exp. " + (s + 1)));
                    info.getYSeries().add(y);
                    ++s;
                }
                info.setYLabel("Probability");
                info.setShowLegend(true);
                info.setShowMarkers(false);
                info.setGraphTitle("Passage-Time Analysis");
                IChart chart = Plotting.getPlottingTools().createTimeSeriesChart(info);
                PlotViewPlugin.getDefault().reveal(chart);
            }
        };
    }

    private boolean isModal() {
        Boolean isModal = (Boolean)this.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        if (isModal == null) {
            return false;
        }
        return isModal;
    }
}

