/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.ui.wizards.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import uk.ac.ed.inf.common.ui.wizards.IActionFieldsProvider;
import uk.ac.ed.inf.common.ui.wizards.PassageTimeAnalysisWizard;
import uk.ac.ed.inf.common.ui.wizards.internal.IUpdatable;

public class PassageTimePage
extends WizardPage
implements IUpdatable {
    private static final Map<String, String> SOLVER_NAMES = new HashMap<String, String>();
    private static final Map<String, String> ANALYSIS_TYPES = new HashMap<String, String>();
    private Combo solver = null;
    private Text sourceActions = null;
    private Text targetActions = null;
    private Text startTime = null;
    private Text stopTime = null;
    private Text timeStep = null;
    private Text advancedText = null;
    private Map<String, String> optionMap;
    private IActionFieldsProvider fProvider;
    private Button staticAnalysisButton;
    private Button useLocationAwareButton;
    private Text locationAwareComponent;

    static {
        SOLVER_NAMES.put("Gauss", "gauss");
        SOLVER_NAMES.put("Grassman", "grassman");
        SOLVER_NAMES.put("Gauss-Seidel", "gauss_seidel");
        SOLVER_NAMES.put("Successive Overrelaxation", "sor");
        SOLVER_NAMES.put("BiConjugate Gradient", "bicg");
        SOLVER_NAMES.put("BiConjugate Gradient Stabilised", "bicgstab");
        SOLVER_NAMES.put("BiConjugate Gradient Stabilised 2", "bicgstab2");
        SOLVER_NAMES.put("Conjugate Gradient on Normal Equations", "cgnr");
        SOLVER_NAMES.put("Conjugate Gradient Stabilised", "cgs");
        SOLVER_NAMES.put("Transpose-Free Quasi-Minimum Residual", "tfqmr");
        SOLVER_NAMES.put("Aggregation Isolation", "ai");
        SOLVER_NAMES.put("AIR with table-driven relaxation", "air");
        SOLVER_NAMES.put("Automatic", "automatic");
        ANALYSIS_TYPES.put("Passage Time", "passage");
    }

    public PassageTimePage(String pageName, IActionFieldsProvider provider) {
        super(pageName);
        this.fProvider = provider;
        this.setTitle("Analysis Settings");
        this.setDescription("Configure ipc/hydra for this analysis.");
    }

    public void setWizard(IWizard wizard) {
        super.setWizard(wizard);
        this.optionMap = ((PassageTimeAnalysisWizard)wizard).getOptionMap();
    }

    public void update() {
        if (!this.isControlCreated()) {
            return;
        }
        String solverCode = null;
        for (Map.Entry<String, String> entry : SOLVER_NAMES.entrySet()) {
            if (!entry.getKey().equals(this.solver.getText())) continue;
            solverCode = entry.getValue();
            break;
        }
        this.optionMap.put("uk.ac.ed.inf.common.solver", solverCode);
        this.optionMap.put("uk.ac.ed.inf.common.source_actions", this.sourceActions.getText());
        this.optionMap.put("uk.ac.ed.inf.common.target_actions", this.targetActions.getText());
        this.optionMap.put("uk.ac.ed.inf.common.start_time", this.startTime.getText());
        this.optionMap.put("uk.ac.ed.inf.common.stop_time", this.stopTime.getText());
        this.optionMap.put("uk.ac.ed.inf.common.time_step", this.timeStep.getText());
        this.optionMap.put("uk.ac.ed.inf.common.advanced_arguments", this.advancedText.getText());
        String value = Boolean.toString(this.staticAnalysisButton.getSelection());
        this.optionMap.put("uk.ac.ed.inf.common.static_analysis", value);
        boolean useLocationAware = this.useLocationAwareButton.getSelection();
        String locAware = Boolean.toString(useLocationAware);
        this.optionMap.put("uk.ac.ed.inf.common.location_aware", locAware);
        if (useLocationAware) {
            this.optionMap.put("uk.ac.ed.inf.common.attached_component", this.locationAwareComponent.getText());
        }
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        GridLayout solverLayout = new GridLayout();
        solverLayout.numColumns = 2;
        solverLayout.makeColumnsEqualWidth = false;
        main.setLayout((Layout)solverLayout);
        this.setControl((Control)main);
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PassageTimePage.this.updatePage();
            }
        };
        SelectionAdapter sListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PassageTimePage.this.updatePage();
            }
        };
        Label solverLabel = new Label(main, 0);
        solverLabel.setText("Solver for steady-state probability distribution:");
        solverLabel.setLayoutData((Object)new GridData(768));
        this.solver = new Combo(main, 8);
        this.solver.addSelectionListener((SelectionListener)sListener);
        for (String name : SOLVER_NAMES.keySet()) {
            this.solver.add(name);
        }
        this.solver.setLayoutData((Object)new GridData(768));
        Label sourceLabel = new Label(main, 0);
        sourceLabel.setText("Source Actions (comma-separated list):");
        this.sourceActions = new Text(main, 2048);
        this.sourceActions.setLayoutData((Object)new GridData(768));
        this.sourceActions.addModifyListener(listener);
        Label targetLabel = new Label(main, 0);
        targetLabel.setText("Target Actions (comma-separated list):");
        this.targetActions = new Text(main, 2048);
        this.targetActions.setLayoutData((Object)new GridData(768));
        this.targetActions.addModifyListener(listener);
        Composite startComp = new Composite(main, 0);
        startComp.setLayoutData((Object)new GridData(768));
        GridLayout startLayout = new GridLayout(2, false);
        startComp.setLayout((Layout)startLayout);
        Label startLabel = new Label(startComp, 0);
        startLabel.setText("Start Time:");
        this.startTime = new Text(startComp, 2048);
        this.startTime.setLayoutData((Object)new GridData(768));
        this.startTime.addModifyListener(listener);
        Composite stopComp = new Composite(main, 0);
        stopComp.setLayoutData((Object)new GridData(768));
        GridLayout stopLayout = new GridLayout(2, false);
        stopComp.setLayout((Layout)stopLayout);
        Label stopLabel = new Label(stopComp, 0);
        stopLabel.setText("Stop Time:");
        this.stopTime = new Text(stopComp, 2048);
        this.stopTime.setLayoutData((Object)new GridData(768));
        this.stopTime.addModifyListener(listener);
        Composite stepComp = new Composite(main, 0);
        GridData stepData = new GridData(768);
        stepData.horizontalSpan = 2;
        stepComp.setLayoutData((Object)stepData);
        GridLayout stepLayout = new GridLayout(2, false);
        stepComp.setLayout((Layout)stepLayout);
        Label stepLabel = new Label(stepComp, 0);
        stepLabel.setText("Time Step:");
        this.timeStep = new Text(stepComp, 2048);
        this.timeStep.setLayoutData((Object)new GridData(768));
        this.timeStep.addModifyListener(listener);
        Group advancedGroup = new Group(main, 8);
        advancedGroup.setText("Advanced Options");
        GridData advData = new GridData(1808);
        advData.horizontalSpan = 2;
        advancedGroup.setLayoutData((Object)advData);
        advancedGroup.setLayout((Layout)new GridLayout());
        this.staticAnalysisButton = new Button((Composite)advancedGroup, 32);
        this.staticAnalysisButton.setText("Perform static analysis");
        this.staticAnalysisButton.setLayoutData((Object)new GridData(768));
        this.useLocationAwareButton = new Button((Composite)advancedGroup, 32);
        this.useLocationAwareButton.setText("Use location-aware probe");
        this.useLocationAwareButton.setLayoutData((Object)new GridData(768));
        this.locationAwareComponent = new Text((Composite)advancedGroup, 2048);
        GridData gData = new GridData(768);
        gData.horizontalIndent = 20;
        this.locationAwareComponent.setLayoutData((Object)gData);
        Label extraOptions = new Label((Composite)advancedGroup, 0);
        extraOptions.setText("Additional Options");
        extraOptions.setLayoutData((Object)new GridData(768));
        this.advancedText = new Text((Composite)advancedGroup, 2114);
        this.advancedText.setLayoutData((Object)new GridData(1808));
        this.advancedText.addModifyListener(listener);
        this.useLocationAwareButton.addSelectionListener((SelectionListener)sListener);
        this.useLocationAwareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PassageTimePage.this.locationAwareComponent.setFocus();
            }
        });
        this.initialisePage();
    }

    private void initialisePage() {
        String solverCode = this.optionMap.get("uk.ac.ed.inf.common.solver");
        if (solverCode == null) {
            solverCode = "sor";
        }
        for (Map.Entry<String, String> entry : SOLVER_NAMES.entrySet()) {
            if (!entry.getValue().equals(solverCode)) continue;
            this.solver.setText(entry.getKey());
            break;
        }
        String sourceAction = this.optionMap.get("uk.ac.ed.inf.common.source_actions");
        if (sourceAction == null) {
            sourceAction = "";
        }
        this.sourceActions.setText(sourceAction);
        String targetAction = this.optionMap.get("uk.ac.ed.inf.common.target_actions");
        if (targetAction == null) {
            targetAction = "";
        }
        this.targetActions.setText(targetAction);
        String start = this.optionMap.get("uk.ac.ed.inf.common.start_time");
        if (start == null) {
            start = "0.1";
        }
        this.startTime.setText(start);
        String stop = this.optionMap.get("uk.ac.ed.inf.common.stop_time");
        if (stop == null) {
            stop = "10.0";
        }
        this.stopTime.setText(stop);
        String step = this.optionMap.get("uk.ac.ed.inf.common.time_step");
        if (step == null) {
            step = "1.0";
        }
        this.timeStep.setText(step);
        String staticAnalysis = this.optionMap.get("uk.ac.ed.inf.common.static_analysis");
        if (staticAnalysis == null) {
            staticAnalysis = "false";
        }
        this.staticAnalysisButton.setSelection(Boolean.parseBoolean(staticAnalysis));
        String locationAware = this.optionMap.get("uk.ac.ed.inf.common.location_aware");
        if (locationAware == null) {
            locationAware = "false";
        }
        this.useLocationAwareButton.setSelection(Boolean.parseBoolean(locationAware));
        String locAwareComponent = this.optionMap.get("uk.ac.ed.inf.common.attached_component");
        if (locAwareComponent == null) {
            locAwareComponent = "";
        }
        this.locationAwareComponent.setText(locAwareComponent);
        String adv = this.optionMap.get("uk.ac.ed.inf.common.advanced_arguments");
        if (adv == null) {
            adv = "";
        }
        this.advancedText.setText(adv);
        this.updatePage();
        this.fProvider.setSourceActionControl(this.sourceActions);
        this.fProvider.setTargetActionControl(this.targetActions);
        this.fProvider.setComponentNameControl(this.locationAwareComponent);
    }

    private void updatePage() {
        String message = this.validate();
        this.setErrorMessage(message);
        if (message == null) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    private String validate() {
        double stop;
        double start;
        this.setMessage(null);
        this.locationAwareComponent.setEnabled(this.useLocationAwareButton.getSelection());
        if (this.sourceActions.getText().trim().equals("")) {
            return "At least one source action needs to be specified";
        }
        if (this.targetActions.getText().trim().equals("")) {
            return "At least one target action needs to be specified";
        }
        try {
            start = Double.parseDouble(this.startTime.getText().trim());
            if (start <= 0.0) {
                return "Start time must be positive";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Start time is not a valid double";
        }
        try {
            stop = Double.parseDouble(this.stopTime.getText().trim());
            if (stop <= 0.0) {
                return "Stop time must be positive";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Stop time is not a valid double";
        }
        if (start >= stop) {
            return "Invalid time interval";
        }
        try {
            double step = Double.parseDouble(this.timeStep.getText().trim());
            if (step < 0.0) {
                return "Time step cannot be negative";
            }
        }
        catch (NumberFormatException numberFormatException) {
            return "Time  step is not a valid double";
        }
        return null;
    }
}

