/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.data;

import java.util.ArrayList;
import java.util.List;
import uk.ac.ed.inf.common.data.IResultData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeSeriesResultData
implements IResultData {
    private double[] fTimeAxis = null;
    private List<double[]> fExperiments = new ArrayList<double[]>();

    public TimeSeriesResultData(double[] timeAxis) {
        this.fTimeAxis = timeAxis;
    }

    public void addExperiment(double[] experiment) {
        this.fExperiments.add(experiment);
    }

    public List<double[]> getExperiments() {
        return this.fExperiments;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int time = 0;
        while (time < this.fTimeAxis.length) {
            buf.append(String.valueOf(this.fTimeAxis[time]) + " ");
            int exp = 0;
            while (exp < this.fExperiments.size()) {
                buf.append(String.valueOf(this.fExperiments.get(exp)[time]) + " ");
                ++exp;
            }
            buf.append("\n");
            ++time;
        }
        return buf.toString();
    }

    @Override
    public int getNumberOfInstances() {
        return this.fExperiments.size();
    }

    @Override
    public double[] getTimeSeries() {
        return this.fTimeAxis;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public double[] getValues(int seriesIndex) {
        return this.fExperiments.get(seriesIndex);
    }
}

