/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.launching;

import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import uk.ac.ed.inf.common.StatusFactory;
import uk.ac.ed.inf.common.launching.LaunchingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseRunner {
    protected Map<String, String> fOptionMap;
    protected ILaunchConfigurationWorkingCopy fCopy;
    protected String fLauncherId;
    protected IFolder fResultFolder;

    public BaseRunner(String launcherId, Map<String, String> optionMap) throws CoreException {
        Assert.isNotNull(optionMap);
        Assert.isNotNull((Object)launcherId);
        this.fOptionMap = optionMap;
        this.fLauncherId = launcherId;
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(this.fLauncherId);
        Assert.isNotNull((Object)type);
        this.fCopy = type.newInstance(null, String.valueOf(this.fLauncherId) + " configuration");
        for (Map.Entry<String, String> entry : this.fOptionMap.entrySet()) {
            this.fCopy.setAttribute(entry.getKey(), entry.getValue());
        }
        this.fResultFolder = LaunchingUtils.getOutputFolder((ILaunchConfiguration)this.fCopy);
        if (this.fResultFolder == null) {
            throw new CoreException((IStatus)StatusFactory.newCannotObtainResultFolder(null, null));
        }
    }

    public final void run(IProgressMonitor monitor) throws CoreException {
        IResourceRuleFactory factory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule createRule = factory.createRule((IResource)this.fResultFolder);
        ISchedulingRule modifyRule = factory.modifyRule((IResource)this.fResultFolder);
        ISchedulingRule multiRule = MultiRule.combine((ISchedulingRule)createRule, (ISchedulingRule)modifyRule);
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor aMonitor) throws CoreException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)aMonitor, (int)100);
                if (BaseRunner.this.fResultFolder.exists()) {
                    BaseRunner.this.fResultFolder.delete(true, (IProgressMonitor)subMonitor.newChild(15));
                }
                subMonitor.setWorkRemaining(85);
                BaseRunner.this.fResultFolder.create(false, true, (IProgressMonitor)subMonitor.newChild(5));
                try {
                    try {
                        BaseRunner.this._run(subMonitor.newChild(75));
                    }
                    catch (CoreException e) {
                        try {
                            BaseRunner.this.fResultFolder.delete(true, (IProgressMonitor)subMonitor.newChild(5));
                        }
                        catch (CoreException deleteException) {
                            throw new CoreException((IStatus)StatusFactory.newCannotRollback(BaseRunner.this.fResultFolder.getFullPath(), deleteException));
                        }
                        throw e;
                    }
                }
                finally {
                    subMonitor.setWorkRemaining(5);
                    BaseRunner.this._updateFolder((IProgressMonitor)subMonitor.newChild(5));
                    if (aMonitor != null) {
                        aMonitor.done();
                    }
                }
            }
        }, multiRule, 1, monitor);
    }

    protected void _updateFolder(IProgressMonitor monitor) throws CoreException {
        IWorkspaceRunnable myRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                BaseRunner.this.fResultFolder.refreshLocal(2, monitor);
            }
        };
        myRunnable.run(monitor);
    }

    protected void _updateFolder() throws CoreException {
        this._updateFolder(null);
    }

    protected abstract void _run(SubMonitor var1) throws CoreException;
}

