/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.common.launching;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import uk.ac.ed.inf.common.launching.RuntimeMonitorWithLock;

public class LaunchingUtils {
    private static final IStringVariableManager VAR_MNG = VariablesPlugin.getDefault().getStringVariableManager();

    public static IFolder getOutputFolder(ILaunchConfiguration configuration) {
        String outputDirectory = null;
        try {
            outputDirectory = configuration.getAttribute("uk.ac.ed.inf.common.output_dir", null);
        }
        catch (CoreException coreException) {
            return null;
        }
        if (outputDirectory == null) {
            return null;
        }
        Path path = new Path(outputDirectory);
        IContainer container = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)path);
        if (container == null || container.getType() != 2) {
            return null;
        }
        return (IFolder)container;
    }

    public static String prepareCommandLineArguments(ILaunchConfiguration config) throws CoreException {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add("--start-time");
        tokens.add(config.getAttribute("uk.ac.ed.inf.common.start_time", "0.1"));
        tokens.add("--stop-time");
        tokens.add(config.getAttribute("uk.ac.ed.inf.common.stop_time", "10.0"));
        tokens.add("--time-step");
        tokens.add(config.getAttribute("uk.ac.ed.inf.common.time_step", "1.0"));
        String[] probeSpecification = null;
        String useLocationAware = config.getAttribute("uk.ac.ed.inf.common.location_aware", "false");
        probeSpecification = !Boolean.parseBoolean(useLocationAware) ? LaunchingUtils.createTokensLocationUnaware(config) : LaunchingUtils.createTokenLocationAware(config);
        String[] stringArray = probeSpecification;
        int n = probeSpecification.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            tokens.add(t);
            ++n2;
        }
        tokens.add("--solver");
        tokens.add(config.getAttribute("uk.ac.ed.inf.common.solver", "sor"));
        if (!Boolean.parseBoolean(config.getAttribute("uk.ac.ed.inf.common.static_analysis", "false"))) {
            tokens.add("--no-static-analysis");
        }
        tokens.add(" " + config.getAttribute("uk.ac.ed.inf.common.advanced_arguments", ""));
        tokens.add(LaunchingUtils.getModelPath(config));
        StringBuffer buf = new StringBuffer();
        for (String t : tokens) {
            buf.append(String.valueOf(t) + " ");
        }
        return buf.toString();
    }

    private static String[] createTokensLocationUnaware(ILaunchConfiguration config) throws CoreException {
        return new String[]{"--source=" + config.getAttribute("uk.ac.ed.inf.common.source_actions", ""), "--target=" + config.getAttribute("uk.ac.ed.inf.common.target_actions", "")};
    }

    private static String[] createTokenLocationAware(ILaunchConfiguration config) throws CoreException {
        String probeName = config.getAttribute("uk.ac.ed.inf.common.attached_component", null);
        String startActions = LaunchingUtils.transform(config.getAttribute("uk.ac.ed.inf.common.source_actions", null));
        String targetActions = LaunchingUtils.transform(config.getAttribute("uk.ac.ed.inf.common.target_actions", null));
        String newToken = "--probe=\"" + probeName + "::(" + startActions + ":start, " + targetActions + ":stop)\"";
        return new String[]{newToken};
    }

    private static String transform(String commaSeparatedValues) {
        String[] actions = commaSeparatedValues.split(",");
        StringBuffer buf = new StringBuffer("(");
        int i = 0;
        while (i < actions.length - 1) {
            buf.append(String.valueOf(actions[i]) + " | ");
            ++i;
        }
        buf.append(String.valueOf(actions[actions.length - 1]) + ")");
        return buf.toString();
    }

    public static String getModelPath(ILaunchConfiguration config) throws CoreException {
        String modelPath = config.getAttribute("uk.ac.ed.inf.common.filename", "");
        return LaunchingUtils.getFullPath(modelPath);
    }

    public static String getFullPath(String text) {
        String path = null;
        try {
            path = VAR_MNG.performStringSubstitution(text).replace('\\', '/');
        }
        catch (CoreException coreException) {}
        return path;
    }

    public static String[] prepareCommandLineForHydraS(IFile file) {
        String fileName = LaunchingUtils.getAbsoluteFilename(file);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add("bash");
        strings.add("-c");
        strings.add("hydra-s " + fileName);
        return strings.toArray(new String[strings.size()]);
    }

    private static String getAbsoluteFilename(IFile file) {
        IPath location = file.getLocation();
        if (Platform.getOS().equals("win32")) {
            location = location.setDevice("/cygdrive/c:");
            return location.toString().replaceFirst("/cygdrive/c:", "/cygdrive/c");
        }
        return location.toString();
    }

    public static String[] prepareCommandLineForHydraUniform(IFile file) {
        String fileNameWithDot = file.getLocation().removeFileExtension().toString();
        StringBuffer buf = new StringBuffer();
        buf.append("hydra-uniform ");
        buf.append(fileNameWithDot);
        buf.append(" -cdf");
        return DebugPlugin.parseArguments((String)buf.toString());
    }

    public static void executeAndWait(ILaunch launch, String[] commandLine) throws CoreException {
        Process p = DebugPlugin.exec((String[])commandLine, null);
        RuntimeMonitorWithLock monitor = new RuntimeMonitorWithLock(launch, p, commandLine[0], null);
        int exitValue = monitor.waitFor();
        if (exitValue != 0) {
            throw new CoreException((IStatus)new Status(4, "uk.ac.ed.inf.common", String.valueOf(commandLine[0]) + " did not quit successfully", null));
        }
    }
}

