/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.core;

import uk.ac.ed.inf.pepa.ctmc.modelchecking.AbstractBoolean;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.CSLAbstractStateProperty;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ICSLModelChecker;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ILogListener;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ModelCheckingException;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ProbabilityInterval;
import uk.ac.ed.inf.pepa.eclipse.core.ProcessAlgebraModelChangedEvent;
import uk.ac.ed.inf.pepa.eclipse.core.internal.PepaModel;

public class PEPAModelChecker
implements ILogListener {
    private PepaModel model;
    private ICSLModelChecker modelChecker;

    public PEPAModelChecker(PepaModel model, ICSLModelChecker modelChecker) {
        this.model = model;
        this.modelChecker = modelChecker;
        modelChecker.addLogListener((ILogListener)this);
    }

    public AbstractBoolean checkProperty(CSLAbstractStateProperty property) {
        AbstractBoolean result = AbstractBoolean.MAYBE;
        ModelCheckingException mce = null;
        long tic = System.currentTimeMillis();
        try {
            result = this.modelChecker.checkProperty(property);
        }
        catch (ModelCheckingException e) {
            mce = e;
        }
        long elapsed = System.currentTimeMillis() - tic;
        this.model.modelCheckingEvent(new ProcessAlgebraModelChangedEvent(6, this.model, (Exception)((Object)mce), elapsed, property.toString()));
        return result;
    }

    public ProbabilityInterval testProperty(CSLAbstractStateProperty property) {
        ProbabilityInterval result = null;
        ModelCheckingException mce = null;
        long tic = System.currentTimeMillis();
        try {
            result = this.modelChecker.testProperty(property);
        }
        catch (ModelCheckingException e) {
            result = new ProbabilityInterval(0.0, 1.0);
            mce = e;
        }
        long elapsed = System.currentTimeMillis() - tic;
        this.model.modelCheckingEvent(new ProcessAlgebraModelChangedEvent(6, this.model, (Exception)((Object)mce), elapsed, property.toString()));
        return result;
    }

    public void notifyLogEntry(String information) {
        this.model.modelCheckingEvent(new ProcessAlgebraModelChangedEvent(7, this.model, null, 0L, information));
    }
}

