/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.core;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaCore;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.core.ProcessAlgebraManager;
import uk.ac.ed.inf.pepa.eclipse.core.internal.EmfPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.internal.PepaModel;

public final class PepaManager
extends ProcessAlgebraManager {
    private HashMap<IResource, IPepaModel> map = new HashMap();
    private IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                IResourceDelta resourceDelta = event.getDelta();
                if (resourceDelta == null) {
                    return;
                }
                resourceDelta.accept(new IResourceDeltaVisitor(){

                    public boolean visit(IResourceDelta delta) throws CoreException {
                        if (!PepaManager.this.isValidPepaFile(delta.getResource())) {
                            return true;
                        }
                        switch (delta.getKind()) {
                            case 1: {
                                break;
                            }
                            case 2: {
                                PepaManager.this.resourceRemoved(delta.getResource());
                                break;
                            }
                            case 4: 
                            case 256: {
                                if ((delta.getFlags() & 0x100) == 0 || !PepaManager.this.map.containsKey(delta.getResource())) break;
                                ((IPepaModel)PepaManager.this.map.get(delta.getResource())).parse();
                                break;
                            }
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                PepaLog.logError(e);
            }
        }
    };

    public boolean isValidPepaFile(IResource resource) {
        if (resource == null) {
            return false;
        }
        boolean result = resource.getType() == 1 && PepaCore.SUPPORTED_EXTENSIONS.contains(resource.getFileExtension());
        return result;
    }

    public IPepaModel getModel(IResource resource) {
        if (this.map.containsKey(resource)) {
            return this.map.get(resource);
        }
        if (this.isValidPepaFile(resource)) {
            return this.lazyCreateModel(resource);
        }
        return null;
    }

    public void shutdown() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
    }

    private IPepaModel lazyCreateModel(IResource resource) {
        if (!resource.exists()) {
            return null;
        }
        PepaModel model = null;
        try {
            model = resource.getFileExtension().equals("emfpepa") ? new EmfPepaModel(resource) : new PepaModel(resource);
            this.map.put(resource, model);
            this.notifyAdded(model);
            model.parse();
        }
        catch (Exception e) {
            PepaLog.logError(e);
        }
        return model;
    }

    private void resourceRemoved(IResource resource) {
        IPepaModel model = this.map.get(resource);
        this.notifyRemoved(model);
        model.dispose();
        this.map.remove(resource);
    }

    public PepaManager() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener, 10);
    }
}

