/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.solution.ISolver;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverException;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverFactory;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModelChangedListener;
import uk.ac.ed.inf.pepa.eclipse.core.PepatoProgressMonitorAdapter;
import uk.ac.ed.inf.pepa.eclipse.core.ProcessAlgebraModelChangedEvent;
import uk.ac.ed.inf.pepa.eclipse.core.internal.OptionHandler;

public abstract class ProcessAlgebraModel
implements IProcessAlgebraModel {
    protected boolean isSolved = false;
    private IResource resource = null;
    protected IStateSpace fStateSpace = null;
    protected OptionHandler fOptionHandler;
    private List<IProcessAlgebraModelChangedListener> fListeners = null;

    public ProcessAlgebraModel(IResource resource) {
        this.resource = resource;
        this.fOptionHandler = new OptionHandler(resource);
        this.fListeners = new ArrayList<IProcessAlgebraModelChangedListener>();
    }

    @Override
    public void addModelChangedListener(IProcessAlgebraModelChangedListener listener) {
        if (listener == null || this.fListeners.contains(listener)) {
            return;
        }
        this.fListeners.add(listener);
    }

    @Override
    public void dispose() {
    }

    @Override
    public abstract void derive(org.eclipse.core.runtime.IProgressMonitor var1) throws DerivationException;

    @Override
    public IStateSpace getStateSpace() {
        return this.fStateSpace;
    }

    @Override
    public IResource getUnderlyingResource() {
        return this.resource;
    }

    @Override
    public abstract boolean isDerivable();

    @Override
    public boolean isSolvable() {
        return this.fStateSpace != null;
    }

    @Override
    public boolean isSolved() {
        return this.isSolved;
    }

    @Override
    public void removeModelChangedListener(IProcessAlgebraModelChangedListener listener) {
        this.fListeners.remove(listener);
    }

    @Override
    public void setSolution(double[] solution) throws DerivationException {
        if (this.isSolvable() && solution != null && this.fStateSpace.size() == solution.length) {
            this.fStateSpace.setSolution(solution);
            this.setSolution(0L, null);
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    public void solveCTMCSteadyState(org.eclipse.core.runtime.IProgressMonitor monitor) throws SolverException {
        SolverException e;
        block7: {
            if (!this.isSolvable()) {
                return;
            }
            e = null;
            long elapsed = 0L;
            try {
                try {
                    ISolver solver = SolverFactory.createSolver((IStateSpace)this.fStateSpace, (OptionMap)this.fOptionHandler.getOptionMap());
                    long tic = System.currentTimeMillis();
                    double[] solution = solver.solve((IProgressMonitor)(monitor == null ? null : new PepatoProgressMonitorAdapter(monitor, "Steady state pdf solution")));
                    elapsed = System.currentTimeMillis() - tic;
                    this.fStateSpace.setSolution(solution);
                }
                catch (SolverException se) {
                    e = se;
                    this.setSolution(elapsed, e);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.setSolution(elapsed, e);
                throw throwable;
            }
            this.setSolution(elapsed, e);
        }
        if (e != null) {
            throw e;
        }
    }

    @Override
    public OptionMap getOptionMap() {
        return this.fOptionHandler.getOptionMap();
    }

    @Override
    public void setOptionMap(OptionMap map) {
        this.fOptionHandler.setOptionMap(map);
    }

    @Override
    public Object getOption(String key) {
        return this.fOptionHandler.getOption(key);
    }

    @Override
    public IResource getResource() {
        return this.fOptionHandler.getResource();
    }

    protected void notify(ProcessAlgebraModelChangedEvent event) {
        for (IProcessAlgebraModelChangedListener listener : this.fListeners) {
            listener.processAlgebraModelChanged(event);
        }
    }

    protected void setSolution(long elapsed, SolverException e) {
        this.isSolved = this.fStateSpace != null && this.fStateSpace.isSolutionAvailable();
        this.notify(new ProcessAlgebraModelChangedEvent(2, (IProcessAlgebraModel)this, (Exception)((Object)e), elapsed));
    }

    protected void setStateSpace(IStateSpace stateSpace, DerivationException exception, long elapsed) {
        this.fStateSpace = stateSpace;
        this.setSolution(0L, null);
        this.notify(new ProcessAlgebraModelChangedEvent(1, (IProcessAlgebraModel)this, (Exception)exception, elapsed));
    }
}

