/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import uk.ac.ed.inf.pepa.eclipse.core.IOptionHandler;
import uk.ac.ed.inf.pepa.eclipse.core.internal.OptionHandler;

public class ResourceUtilities {
    public static IOptionHandler createOptionHandler(IResource resource) {
        return new OptionHandler(resource);
    }

    public static void createPathForFile(IFile file) throws CoreException {
        IProject project = file.getProject();
        IPath path = file.getProjectRelativePath();
        Path copy = Path.EMPTY;
        int i = 0;
        while (i < path.segmentCount() - 1) {
            copy = copy.append(path.segment(i));
            IFolder folder = project != null ? project.getFolder((IPath)copy) : ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)copy);
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            ++i;
        }
    }

    public static void generate(String path, String content, IProgressMonitor monitor) throws IOException, CoreException {
        IFile file = ResourceUtilities.getIFileFromText(path);
        if (monitor != null) {
            monitor.beginTask("Generating " + file.getFullPath(), 3);
        }
        ByteArrayInputStream source = new ByteArrayInputStream(content.getBytes());
        if (file.exists()) {
            file.setContents((InputStream)source, true, false, null);
            if (monitor != null) {
                monitor.worked(2);
            }
        } else {
            ResourceUtilities.createPathForFile(file);
            if (monitor != null) {
                monitor.worked(1);
            }
            file.create((InputStream)source, true, null);
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        file.refreshLocal(0, null);
        if (monitor != null) {
            monitor.done();
        }
    }

    public static IFile getIFileFromText(String text) {
        Path path = new Path(text);
        if (path.segmentCount() > 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }

    public static IPath changeExtension(IResource resource, String newExtension) {
        if (resource == null || newExtension == null) {
            return null;
        }
        IPath path = resource.getFullPath().removeFileExtension();
        String filename = path.lastSegment();
        path = path.removeLastSegments(1);
        path = path.makeRelative();
        if (newExtension.equals("")) {
            return path.append(filename);
        }
        return path.append(String.valueOf(filename) + "." + newExtension);
    }
}

