/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import uk.ac.ed.inf.pepa.analysis.DeadCode;
import uk.ac.ed.inf.pepa.analysis.IProblem;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.model.Action;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.ModelNode;

public class MarkerManager {
    private IPepaModel model;
    private List<IMarker> staticAnalysisMarkers = new ArrayList<IMarker>();
    private List<IMarker> dynamicAnalysisMarkers = new ArrayList<IMarker>();

    public MarkerManager(IPepaModel model) {
        this.model = model;
    }

    public void createStaticAnalysisMarkers() {
        final ModelNode ast = this.model.getAST();
        if (ast == null) {
            throw new NullPointerException("No AST Available!");
        }
        this.clear(this.staticAnalysisMarkers);
        this.clear(this.dynamicAnalysisMarkers);
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IProblem[] iProblemArray = ast.getProblems();
                int n = iProblemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProblem problem = iProblemArray[n2];
                    IMarker marker = MarkerManager.this.model.getUnderlyingResource().createMarker("org.eclipse.core.resources.problemmarker");
                    marker.setAttribute("lineNumber", problem.getStartLine());
                    marker.setAttribute("message", (Object)problem.getMessage());
                    marker.setAttribute("charStart", problem.getChar());
                    marker.setAttribute("charEnd", problem.getChar() + problem.getLength());
                    marker.setAttribute("severity", problem.isError() ? 2 : 1);
                    marker.setAttribute("transient", true);
                    MarkerManager.this.staticAnalysisMarkers.add(marker);
                    ++n2;
                }
            }
        };
        try {
            this.model.getUnderlyingResource().getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            PepaLog.logError(e);
        }
    }

    public void createStateSpaceMarkers(final DeadCode[] deadCode, final String[] transientStates) {
        this.clear(this.dynamicAnalysisMarkers);
        IWorkspaceRunnable addPostDerivationAnalysisMarkersOperation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                Object[] objectArray = deadCode;
                int n = deadCode.length;
                int n2 = 0;
                while (n2 < n) {
                    DeadCode dc = objectArray[n2];
                    MarkerManager.this.createDeadCodeMarker(dc);
                    ++n2;
                }
                objectArray = transientStates;
                n = transientStates.length;
                n2 = 0;
                while (n2 < n) {
                    DeadCode processName = objectArray[n2];
                    MarkerManager.this.createTransientStateMarker((String)processName);
                    ++n2;
                }
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(addPostDerivationAnalysisMarkersOperation, null);
        }
        catch (CoreException e) {
            PepaLog.logError(e);
        }
    }

    private void createTransientStateMarker(String processName) throws CoreException {
        ASTNode sensibleNode = this.model.getAST().getResolver().getProcessDefinition(processName);
        this.createDynamicAnalysisMarker(sensibleNode, "Transient process. Process: " + processName);
    }

    private void createDeadCodeMarker(DeadCode deadCode) {
        for (Action action : deadCode.actions) {
            ASTNode[] usage;
            String actionName = action.prettyPrint();
            ASTNode[] aSTNodeArray = usage = this.model.getAST().getResolver().getActionUsage(deadCode.process.getName(), actionName);
            int n = usage.length;
            int n2 = 0;
            while (n2 < n) {
                ASTNode node = aSTNodeArray[n2];
                try {
                    this.createDeadCodeMarker(node, actionName);
                }
                catch (CoreException e) {
                    PepaLog.logError(e);
                }
                ++n2;
            }
        }
    }

    private void createDeadCodeMarker(ASTNode node, String action) throws CoreException {
        this.createDynamicAnalysisMarker(node, "Dead code. Action: " + action);
    }

    private void createDynamicAnalysisMarker(ASTNode node, String message) throws CoreException {
        IMarker marker = this.model.getUnderlyingResource().createMarker("org.eclipse.core.resources.problemmarker");
        marker.setAttribute("lineNumber", node.getLeftLocation().getLine());
        marker.setAttribute("message", (Object)message);
        marker.setAttribute("charStart", node.getLeftLocation().getChar());
        marker.setAttribute("charEnd", node.getRightLocation().getChar());
        marker.setAttribute("severity", 1);
        marker.setAttribute("transient", true);
        this.dynamicAnalysisMarkers.add(marker);
    }

    private void clear(final List<IMarker> markers) {
        IWorkspaceRunnable clearDynamicAnalysisMarkersOperation = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                for (IMarker marker : markers) {
                    try {
                        marker.delete();
                    }
                    catch (CoreException e) {
                        PepaLog.logError(e);
                    }
                }
                markers.clear();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(clearDynamicAnalysisMarkersOperation, null);
        }
        catch (CoreException e1) {
            PepaLog.logError(e1);
        }
    }
}

