/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.core.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.eclipse.core.IOptionHandler;
import uk.ac.ed.inf.pepa.eclipse.core.PepaCore;
import uk.ac.ed.inf.pepa.eclipse.core.PepatoOptionForwarder;

public class OptionHandler
implements IOptionHandler {
    private OptionMap fCurrentOptionMap;
    private IResource fResource;

    public OptionHandler(IResource resource) {
        Assert.isNotNull((Object)resource);
        this.fResource = resource;
        this.initOptionMap();
    }

    @Override
    public IResource getResource() {
        return this.fResource;
    }

    private void initOptionMap() {
        try {
            this.fCurrentOptionMap = PepatoOptionForwarder.getOptionMapFromPersistentResource(this.fResource);
        }
        catch (CoreException e) {
            PepaCore.getDefault().getLog().log(e.getStatus());
            this.fCurrentOptionMap = new OptionMap();
        }
    }

    @Override
    public OptionMap getOptionMap() {
        return new OptionMap(this.fCurrentOptionMap);
    }

    @Override
    public void setOptionMap(OptionMap map) {
        if (map == null) {
            this.initOptionMap();
        } else {
            this.fCurrentOptionMap = new OptionMap(map);
        }
        try {
            for (Object key : this.fCurrentOptionMap.keySet()) {
                PepatoOptionForwarder.saveOptionInPersistentResource(this.fResource, (String)key, this.fCurrentOptionMap.get(key));
            }
        }
        catch (CoreException e) {
            PepaCore.getDefault().getLog().log(e.getStatus());
        }
    }

    @Override
    public Object getOption(String key) {
        return this.fCurrentOptionMap.get((Object)key);
    }
}

