/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.core.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import uk.ac.ed.inf.pepa.IProgressMonitor;
import uk.ac.ed.inf.pepa.IResourceManager;
import uk.ac.ed.inf.pepa.OptionsMap;
import uk.ac.ed.inf.pepa.analysis.IProblem;
import uk.ac.ed.inf.pepa.analysis.StaticAnalyser;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpace;
import uk.ac.ed.inf.pepa.ctmc.derivation.IStateSpaceBuilder;
import uk.ac.ed.inf.pepa.ctmc.kronecker.IKroneckerStateSpace;
import uk.ac.ed.inf.pepa.ctmc.kronecker.KroneckerDisplayModel;
import uk.ac.ed.inf.pepa.ctmc.modelchecking.ICSLModelChecker;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.core.PEPAModelChecker;
import uk.ac.ed.inf.pepa.eclipse.core.PepatoProgressMonitorAdapter;
import uk.ac.ed.inf.pepa.eclipse.core.ProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.core.ProcessAlgebraModelChangedEvent;
import uk.ac.ed.inf.pepa.eclipse.core.internal.MarkerManager;
import uk.ac.ed.inf.pepa.parsing.ASTNode;
import uk.ac.ed.inf.pepa.parsing.EqualityVisitor;
import uk.ac.ed.inf.pepa.parsing.ModelNode;
import uk.ac.ed.inf.pepa.sba.Mapping;
import uk.ac.ed.inf.pepa.sba.PEPAtoSBA;
import uk.ac.ed.inf.pepa.sba.ReagentCentricPEPAtoSBA;
import uk.ac.ed.inf.pepa.sba.Results;
import uk.ac.ed.inf.pepa.sba.SBAInterface;
import uk.ac.ed.inf.pepa.sba.SBAParseException;
import uk.ac.ed.inf.pepa.sba.SBAReaction;
import uk.ac.ed.inf.pepa.sba.SBASimulatorException;
import uk.ac.ed.inf.pepa.sba.SBAtoISBJava;
import uk.ac.ed.inf.pepa.tools.PepaTools;

public class PepaModel
extends ProcessAlgebraModel
implements IPepaModel {
    protected ModelNode fAstModel = null;
    protected StaticAnalyser fStaticAnalyser = null;
    protected IStateSpace fStateSpace = null;
    protected IKroneckerStateSpace fKroneckerStateSpace = null;
    private boolean fKroneckerDerivationProblem = false;
    protected SBAInterface fSBAModel = null;
    protected SBAtoISBJava fReactionModel = null;
    private long sbaParsetime;
    protected Results fResults = null;
    protected IPepaModel.PEPAForm current = null;
    protected IPepaModel.PEPAForm lastConversion = null;
    protected boolean apparentRate = true;
    protected List<IPepaModel.PEPAForm> possibleConversions = null;
    private MarkerManager markerCreator = new MarkerManager(this);

    public PepaModel(IResource resource) {
        super(resource);
    }

    @Override
    public void parse() throws CoreException {
        long tic = System.currentTimeMillis();
        boolean hasChanged = this.doParse();
        long toc = System.currentTimeMillis();
        this.markerCreator.createStaticAnalysisMarkers();
        if (hasChanged) {
            this.setStateSpace(null, null, 0L);
            this.setSBA(0L);
            this.lastConversion = null;
            this.possibleConversions = null;
            this.fKroneckerStateSpace = null;
            this.fKroneckerDerivationProblem = false;
            this.notify(new ProcessAlgebraModelChangedEvent(0, this, toc - tic));
        }
    }

    protected boolean doParse() throws CoreException {
        String source = null;
        try {
            source = this.getStringFromResource(this.getUnderlyingResource());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "uk.ac.ed.inf.pepa.eclipse.core", 0, "Input/Output problem", (Throwable)e));
        }
        if (source != null) {
            ModelNode oldAstModel = this.fAstModel;
            this.fAstModel = (ModelNode)PepaTools.parse((String)source);
            this.fStaticAnalyser = PepaTools.doStaticAnalysis((ModelNode)this.fAstModel);
            if (oldAstModel == null || this.fAstModel == null) {
                return true;
            }
            return !EqualityVisitor.compare((ASTNode)oldAstModel, (ASTNode)this.fAstModel);
        }
        return true;
    }

    private void setKroneckerStateSpace(org.eclipse.core.runtime.IProgressMonitor monitor) {
        if (!this.isDerivable() || this.fKroneckerDerivationProblem) {
            this.fKroneckerStateSpace = null;
        } else {
            DerivationException de = null;
            long tic = System.currentTimeMillis();
            OptionMap map = new OptionMap(this.fOptionHandler.getOptionMap());
            map.put((Object)"cmtc.derivation.kind", (Object)2);
            try {
                this.fKroneckerStateSpace = (IKroneckerStateSpace)PepaTools.derive((OptionMap)map, (ModelNode)this.fAstModel, (IProgressMonitor)(monitor == null ? null : new PepatoProgressMonitorAdapter(monitor, "Kronecker derivation")), (IResourceManager)IResourceManager.TEMP);
            }
            catch (DerivationException e) {
                this.fKroneckerDerivationProblem = true;
                de = e;
            }
            long elapsed = System.currentTimeMillis() - tic;
            this.notify(new ProcessAlgebraModelChangedEvent(5, (IProcessAlgebraModel)this, (Exception)((Object)de), elapsed));
        }
    }

    @Override
    public KroneckerDisplayModel getDisplayModel() {
        if (this.fKroneckerStateSpace == null) {
            this.setKroneckerStateSpace(null);
        }
        if (this.fKroneckerStateSpace != null) {
            return this.fKroneckerStateSpace.getDisplayModel();
        }
        return null;
    }

    @Override
    public PEPAModelChecker getModelChecker(double boundAccuracy) {
        if (this.fKroneckerStateSpace == null) {
            this.setKroneckerStateSpace(null);
        }
        if (this.fKroneckerStateSpace != null) {
            ICSLModelChecker modelChecker = this.fKroneckerStateSpace.getModelChecker(this.fOptionHandler.getOptionMap(), (IProgressMonitor)new PepatoProgressMonitorAdapter(null, "Model Checker Generation"), boundAccuracy);
            return new PEPAModelChecker(this, modelChecker);
        }
        return null;
    }

    public void modelCheckingEvent(ProcessAlgebraModelChangedEvent event) {
        this.notify(event);
    }

    @Override
    public StaticAnalyser getStaticAnalyser() {
        return this.fStaticAnalyser;
    }

    @Override
    public ModelNode getAST() {
        return this.fAstModel;
    }

    @Override
    public void derive(org.eclipse.core.runtime.IProgressMonitor monitor) throws DerivationException {
        DerivationException de;
        block7: {
            if (!this.isDerivable()) {
                return;
            }
            de = null;
            IStateSpace stateSpace = null;
            IStateSpaceBuilder derivator = PepaTools.getBuilder((ModelNode)this.fAstModel, (OptionMap)this.fOptionHandler.getOptionMap(), (IResourceManager)IResourceManager.TEMP);
            long elapsed = 0L;
            try {
                try {
                    long tic = System.currentTimeMillis();
                    stateSpace = derivator.derive(false, (IProgressMonitor)(monitor == null ? null : new PepatoProgressMonitorAdapter(monitor, "State space derivation")));
                    elapsed = System.currentTimeMillis() - tic;
                }
                catch (DerivationException e) {
                    de = e;
                    this.setStateSpace(stateSpace, de, elapsed);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                this.setStateSpace(stateSpace, de, elapsed);
                throw throwable;
            }
            this.setStateSpace(stateSpace, de, elapsed);
        }
        if (de != null) {
            throw de;
        }
    }

    @Override
    public boolean isDerivable() {
        return this.fAstModel != null && !this.isAstCarryingErrors(this.fAstModel);
    }

    private boolean isAstCarryingErrors(ModelNode ast) {
        IProblem[] iProblemArray = ast.getProblems();
        int n = iProblemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem problem = iProblemArray[n2];
            if (problem.isError()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private String getStringFromResource(IResource resource) throws CoreException, IOException {
        int c;
        BufferedReader in = new BufferedReader(new InputStreamReader(((IFile)resource).getContents()));
        StringBuffer buf = new StringBuffer();
        char[] cbuf = new char[4096];
        while ((c = in.read(cbuf)) != -1) {
            buf.append(cbuf, 0, c);
        }
        return buf.toString();
    }

    @Override
    public boolean isParsable() {
        return this.getUnderlyingResource() != null && this.getUnderlyingResource().exists();
    }

    private final void setSBA(long duration) {
        this.sbaParsetime = duration;
        this.fReactionModel = null;
        this.setISBJava(0L);
    }

    private final void setISBJava(long duration) {
        ProcessAlgebraModelChangedEvent pmce = null;
        pmce = duration == 0L ? new ProcessAlgebraModelChangedEvent(3, this, duration) : new ProcessAlgebraModelChangedEvent(3, this, this.sbaParsetime + duration);
        this.notify(pmce);
        this.fResults = null;
        this.setTimeSeries(0L);
    }

    private final void setTimeSeries(long duration) {
        this.notify(new ProcessAlgebraModelChangedEvent(4, this, duration));
    }

    @Override
    public IPepaModel.PEPAForm[] isSBAParseable() {
        if (this.fReactionModel != null) {
            return this.possibleConversions.toArray(new IPepaModel.PEPAForm[0]);
        }
        this.possibleConversions = new ArrayList<IPepaModel.PEPAForm>();
        if (new PEPAtoSBA(this.fAstModel).isParseable()) {
            this.possibleConversions.add(IPepaModel.PEPAForm.PEPA);
        }
        if (new ReagentCentricPEPAtoSBA(this.fAstModel).isParseable()) {
            this.possibleConversions.add(IPepaModel.PEPAForm.REAGENT_CENTRIC);
        }
        return this.possibleConversions.toArray(new IPepaModel.PEPAForm[0]);
    }

    @Override
    public boolean sbaParse() throws SBAParseException {
        if (this.possibleConversions == null) {
            this.isSBAParseable();
        }
        if (this.possibleConversions.size() == 0 || !this.possibleConversions.contains((Object)this.current)) {
            this.fSBAModel = null;
            this.fReactionModel = null;
            this.fResults = null;
            throw new SBAParseException("Model not parseable for " + this.current.toString());
        }
        if (this.fSBAModel != null && this.current.equals((Object)this.lastConversion)) {
            return false;
        }
        long tic = System.currentTimeMillis();
        try {
            try {
                this.fReactionModel = null;
                if (this.current.equals((Object)IPepaModel.PEPAForm.PEPA)) {
                    PEPAtoSBA pts = new PEPAtoSBA(this.fAstModel);
                    pts.parseModel();
                    this.fSBAModel = pts;
                    this.apparentRate = true;
                } else if (this.current.equals((Object)IPepaModel.PEPAForm.REAGENT_CENTRIC)) {
                    ReagentCentricPEPAtoSBA pts = new ReagentCentricPEPAtoSBA(this.fAstModel);
                    pts.parseModel();
                    this.fSBAModel = pts;
                    this.apparentRate = false;
                }
            }
            catch (Exception e) {
                throw new SBAParseException(e.getMessage());
            }
        }
        finally {
            this.setSBA(System.currentTimeMillis() - tic);
        }
        return true;
    }

    @Override
    public Set<SBAReaction> getReactions() {
        return this.fSBAModel.getReactions();
    }

    @Override
    public void updateReactions(Set<SBAReaction> updatedReactions) throws IllegalArgumentException {
        this.fSBAModel.updateReactions(updatedReactions);
    }

    @Override
    public boolean generateReactions() throws SBAParseException {
        if (this.fSBAModel == null) {
            throw new SBAParseException("Model has not been parsed.");
        }
        long tic = System.currentTimeMillis();
        try {
            try {
                this.fReactionModel = null;
                this.fReactionModel = new SBAtoISBJava(this.fSBAModel);
                this.fReactionModel.generateISBJavaModel("", this.apparentRate);
                this.lastConversion = this.current;
            }
            catch (Exception e) {
                throw new SBAParseException(e.getMessage());
            }
        }
        finally {
            this.setISBJava(System.currentTimeMillis() - tic);
        }
        return true;
    }

    @Override
    public void setForm(IPepaModel.PEPAForm newForm) {
        this.current = newForm;
    }

    @Override
    public void setApparentRateUse(boolean apparentRate) {
        this.apparentRate = apparentRate;
    }

    @Override
    public void generateTimeSeries(OptionsMap options, org.eclipse.core.runtime.IProgressMonitor monitor) throws SBASimulatorException {
        if (this.fReactionModel == null) {
            throw new SBASimulatorException("", null);
        }
        long tic = System.currentTimeMillis();
        try {
            try {
                this.fReactionModel.initialiseSimulator(options);
                this.fResults = null;
                this.fResults = this.fReactionModel.runModel((IProgressMonitor)(monitor == null ? null : new PepatoProgressMonitorAdapter(monitor, "Time Series Analysis")));
            }
            catch (SBASimulatorException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SBASimulatorException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            this.setTimeSeries(System.currentTimeMillis() - tic);
        }
    }

    @Override
    public Results getTimeSeries() {
        return this.fResults;
    }

    @Override
    public OptionsMap.Solver[] getValidTimeSeriesSolvers() {
        if (this.fReactionModel == null) {
            return new OptionsMap.Solver[0];
        }
        return this.fReactionModel.getPermissibleSolvers();
    }

    @Override
    public String getCMDL() {
        if (this.fReactionModel == null) {
            return null;
        }
        return this.fReactionModel.writeCMDL();
    }

    @Override
    public String getMatlab() {
        if (this.fReactionModel == null) {
            return null;
        }
        return this.fReactionModel.writeMatlab();
    }

    @Override
    public Mapping getMapping() {
        if (this.fReactionModel == null) {
            return null;
        }
        return this.fReactionModel.getMapping();
    }
}

