/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ed.inf.pepa.eclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import uk.ac.ed.inf.pepa.ctmc.derivation.DerivationException;
import uk.ac.ed.inf.pepa.ctmc.solution.OptionMap;
import uk.ac.ed.inf.pepa.ctmc.solution.SolverException;
import uk.ac.ed.inf.pepa.eclipse.core.IPepaModel;
import uk.ac.ed.inf.pepa.eclipse.core.IProcessAlgebraModel;
import uk.ac.ed.inf.pepa.eclipse.core.PepaLog;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.PassageTimeWizard;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.ctmcsolver.resourceless.SolverWizard;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ConcretePerformanceMetricFactory;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.ExperimentationWizard;
import uk.ac.ed.inf.pepa.eclipse.ui.wizards.experimentation.pepa.PEPAEvaluator;

public class ActionCommands {
    public static void derive(final IProcessAlgebraModel model) {
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        try {
            progressService.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("State Space Derivation", -1);
                    try {
                        try {
                            model.derive(monitor);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            PepaLog.logError((Throwable)e);
            if (e.getTargetException() instanceof DerivationException) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"State Space Derivation Error", (String)((DerivationException)e.getTargetException()).getMessage());
            } else {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Unexpected Error", (String)e.getTargetException().getMessage());
            }
        }
        catch (InterruptedException interruptedException) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Job Interrupted", (String)"State space derivation interrupted by user");
        }
    }

    public static void experiment(IPepaModel model) {
        ExperimentationWizard wizard = new ExperimentationWizard(new PEPAEvaluator(model), new ConcretePerformanceMetricFactory());
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        dialog.setPageSize(400, 400);
        dialog.open();
    }

    public static void passageTime(IPepaModel model) {
        PassageTimeWizard wizard = new PassageTimeWizard(model);
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        dialog.setPageSize(400, 400);
        dialog.open();
    }

    public static void steadyState(final IProcessAlgebraModel model) {
        OptionMap originalMap = model.getOptionMap();
        SolverWizard wizard = new SolverWizard(originalMap);
        Shell activeShell = Display.getDefault().getActiveShell();
        WizardDialog dialog = new WizardDialog(activeShell, (IWizard)wizard);
        if (dialog.open() == 0) {
            OptionMap map = wizard.getOptionMap();
            model.setOptionMap(map);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        model.solveCTMCSteadyState(monitor);
                    }
                    catch (SolverException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(activeShell);
            try {
                monitorDialog.run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)activeShell, (String)"Error during solution", (String)e.getCause().getMessage());
            }
            catch (InterruptedException interruptedException) {
                MessageDialog.openInformation((Shell)activeShell, (String)"Operation aborted", (String)"Operation interrupted.");
            }
        }
    }
}

